/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.mobile.BizFunctionCollection;
import com.kingdee.eas.mobile.BizFunctionFactory;
import com.kingdee.eas.mobile.BizModuleCollection;
import com.kingdee.eas.mobile.BizModuleFactory;
import com.kingdee.eas.mobile.IBizFunction;
import com.kingdee.eas.mobile.IBizModule;
import com.kingdee.eas.mobile.IMobileConfig;
import com.kingdee.eas.mobile.IServerEngineNew;
import com.kingdee.eas.mobile.MobileConfigCollection;
import com.kingdee.eas.mobile.MobileConfigFactory;
import com.kingdee.eas.mobile.MobileConfigInfo;
import com.kingdee.eas.mobile.ServerEngineNewFactory;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.util.Locale;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class AutoStartMobileListener
implements ServletContextListener {
    private static Logger logger = Logger.getLogger((String)AutoStartMobileListener.class.getName());
    private int timeStep = 30000;
    private int maxTime = 300000;
    private int sleepTime = 0;

    public void contextInitialized(ServletContextEvent arg0) {
        MobileThread t = new MobileThread();
        t.setServletContextEvent(arg0);
        t.start();
    }

    private void startMobile(ServletContextEvent arg0) {
        try {
            ORMServiceLocation service = new ORMServiceLocation("Mobile");
            if (!service.isLocal()) {
                logger.info((Object)"------mobile----AutoStartMobileListener---isLocal----");
                logger.info((Object)("---mobile---URL=" + service.getServiceURL()));
                return;
            }
            logger.info((Object)"start loading mobile config info");
            Context ctx = new Context((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)"00000000-0000-0000-0000-00000000000013B7DE7F")), "eas", this.getDataCenterName(), new Locale("l2"));
            IMobileConfig iMobileConfig = MobileConfigFactory.getLocalInstance(ctx);
            MobileConfigCollection mobileConfigs = iMobileConfig.getMobileConfigCollection();
            MobileConfigInfo mobileConfigInfo = null;
            if (mobileConfigs.size() > 0) {
                mobileConfigInfo = mobileConfigs.get(0);
            }
            IBizModule iBizModule = BizModuleFactory.getLocalInstance(ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            viewInfo.getSelector().add(new SelectorItemInfo("BizFunction.*"));
            BizModuleCollection bizModules = iBizModule.getBizModuleCollection(viewInfo);
            BizFunctionCollection[] bizFunctionCols = null;
            if (bizModules.size() > 0) {
                bizFunctionCols = new BizFunctionCollection[bizModules.size()];
            }
            IBizFunction iBizFunction = BizFunctionFactory.getLocalInstance(ctx);
            BizFunctionCollection bizFunctionCol = null;
            FilterInfo filterInfo = null;
            for (int i = 0; i < bizModules.size(); ++i) {
                viewInfo = new EntityViewInfo();
                viewInfo.getSelector().add(new SelectorItemInfo("id"));
                viewInfo.getSelector().add(new SelectorItemInfo("function"));
                viewInfo.getSelector().add(new SelectorItemInfo("implClassName"));
                viewInfo.getSelector().add(new SelectorItemInfo("commandObj.*"));
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("bizModule", (Object)bizModules.get(i).getId().toString(), CompareType.EQUALS));
                viewInfo.setFilter(filterInfo);
                viewInfo.getSorter().add(new SorterItemInfo("id"));
                bizFunctionCols[i] = bizFunctionCol = iBizFunction.getBizFunctionCollection(viewInfo);
            }
            IServerEngineNew serverEngineNew = ServerEngineNewFactory.getLocalInstance(ctx);
            boolean succeed = false;
            logger.info((Object)"------mobile----AutoStartMobileListener---startMobile----");
            int tryCount = 5;
            while (!succeed) {
                if (tryCount == 0) {
                    logger.info((Object)"------mobile----auto start mobile eror at MaxCount ");
                    break;
                }
                try {
                    succeed = serverEngineNew.start(mobileConfigInfo, bizModules, bizFunctionCols);
                    if (succeed) {
                        logger.info((Object)"------mobile----auto start succeed");
                        break;
                    }
                    logger.info((Object)"------mobile----not auto start");
                    this.sleepTime(this.getSleepTime());
                }
                catch (Exception err) {
                    logger.info((Object)"------mobile----auto start mobile eror", (Throwable)err);
                    this.sleepTime(this.getSleepTime());
                }
                --tryCount;
            }
            logger.info((Object)"------mobile----auto mobile already start");
        }
        catch (Exception e) {
            logger.info((Object)("------mobile----auto start mobile serive eror:" + e));
        }
    }

    private void sleepTime(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e1) {
            logger.info((Object)(Thread.currentThread().getName() + "(auto start mobile) Time InterruptedException"));
        }
    }

    private int getSleepTime() {
        this.sleepTime += this.timeStep;
        if (this.sleepTime > this.maxTime) {
            this.sleepTime = this.timeStep;
        }
        return this.sleepTime;
    }

    private String getDataCenterName() {
        logger.info((Object)"------mobile----get data center name start ");
        ConfigurationItem item = Configuration.getInstance().getConfigItem("autoStartMoblieService");
        String name = item.getProperty("dataCenter");
        logger.info((Object)("------mobile----moblie datacenter:" + name));
        return name;
    }

    public void contextDestroyed(ServletContextEvent arg0) {
    }

    class MobileThread
    extends Thread {
        ServletContextEvent sce = null;

        MobileThread() {
        }

        public void setServletContextEvent(ServletContextEvent _sce) {
            this.sce = _sce;
        }

        @Override
        public void run() {
            AutoStartMobileListener.this.startMobile(this.sce);
        }
    }
}

