/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.app.di;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mobile.CellphoneNumberTypeEnum;
import com.kingdee.eas.mobile.IMobileMessageAssign;
import com.kingdee.eas.mobile.IMsgFacade;
import com.kingdee.eas.mobile.ISendMobileMessage;
import com.kingdee.eas.mobile.MobileMessageAddressInfo;
import com.kingdee.eas.mobile.MobileMessageAssignFactory;
import com.kingdee.eas.mobile.MsgFacadeFactory;
import com.kingdee.eas.mobile.SendMobileMessageFactory;
import com.kingdee.eas.mobile.SendMobileMessageInfo;
import com.kingdee.eas.mobile.util.AppMsgUtil;
import com.kingdee.eas.mobile.util.MobileUtil;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Hashtable;

public class SendMobileMessageDI
extends AbstractDataTransmission {
    private int alreadySendThisTimeCount = 0;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SendMobileMessageFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            CoreBaseInfo newData = this.createNewData(hsData, ctx);
            return newData;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private CoreBaseInfo createNewData(Hashtable hsData, Context ctx) throws Exception {
        PersonInfo personInfo;
        String content = this.getFieldValue(hsData, "FContent");
        String prefix = this.getFieldValue(hsData, "FPrefix");
        String suffix = this.getFieldValue(hsData, "FSuffix");
        String revertible = this.getFieldValue(hsData, "FRevertible");
        String receiveMobileNumber = this.getFieldValue(hsData, "FReceiveMobileNumber");
        String receiveBizUser = this.getFieldValue(hsData, "FReceiveBizUserID");
        String sendBizUser = this.getFieldValue(hsData, "FSendBizUserID");
        this.checkRequeiredField(ctx, "\u5185\u5bb9", content);
        this.checkRequeiredField(ctx, "\u63a5\u6536\u624b\u673a\u53f7\u7801", receiveMobileNumber);
        receiveMobileNumber = this.getLegalMobileNumber(receiveMobileNumber);
        SendMobileMessageInfo sendMoMsgInfo = new SendMobileMessageInfo();
        sendMoMsgInfo.setTitle("for.hander");
        sendMoMsgInfo.setSendHandcraft(true);
        boolean canback = false;
        if ("1".equals(revertible) || "y".equalsIgnoreCase(revertible) || "true".equalsIgnoreCase(revertible)) {
            canback = true;
        }
        sendMoMsgInfo.setRevertible(canback);
        StringBuffer actualContent = new StringBuffer();
        if (!StringUtils.isEmpty((String)prefix)) {
            actualContent.append(prefix).append(" ");
        }
        actualContent.append(content);
        if (!StringUtils.isEmpty((String)suffix)) {
            actualContent.append(" ").append(suffix);
        }
        if (canback) {
            actualContent.append(" [").append(ContextUtil.getCurrentUserInfo((Context)ctx).getName()).append("]-\u53ef\u56de\u590d");
        } else {
            actualContent.append(" [").append(ContextUtil.getCurrentUserInfo((Context)ctx).getName()).append("]-\u4e0d\u53ef\u56de\u590d");
        }
        sendMoMsgInfo.setContent(actualContent.toString());
        sendMoMsgInfo.setSplitNumber(AppMsgUtil.countSplitNumber(sendMoMsgInfo.getContent()));
        MobileMessageAddressInfo addressInfo = new MobileMessageAddressInfo();
        addressInfo.setReceiveMobileNumber(receiveMobileNumber);
        addressInfo.setReceiveCellNumberType(CellphoneNumberTypeEnum.getEnum(MobileUtil.getCellphoneNumberType(receiveMobileNumber)));
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserInfo receiveUserInfo = null;
        String receiveUserId = AppMsgUtil.getUserIdByMobileNumber(ctx, receiveMobileNumber);
        if (!StringUtils.isEmpty((String)receiveUserId)) {
            receiveUserInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(receiveUserId));
        }
        if (receiveUserInfo == null) {
            if (!StringUtils.isEmpty((String)receiveBizUser)) {
                addressInfo.setReceiveBizUserName(receiveBizUser);
            }
        } else {
            addressInfo.setReceiveBizUserName(receiveBizUser);
        }
        addressInfo.setReceiveBizUser(receiveUserInfo);
        UserInfo sendUserInfo = null;
        if (!StringUtils.isEmpty((String)sendBizUser)) {
            if (iUser.exists("select 1 where number = '" + sendBizUser + "'")) {
                sendUserInfo = iUser.getUserInfo("select id,person.id where number = '" + sendBizUser + "'");
            } else {
                throw new TaskExternalException("\u53d1\u9001\u4eba\u5e10\u53f7\u7f16\u7801\u4e3a " + sendBizUser + "\u7684\u7528\u6237\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
        }
        if (sendUserInfo == null) {
            sendUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        }
        addressInfo.setSendBizUser(sendUserInfo);
        if (sendUserInfo != null && (personInfo = AppMsgUtil.getPersonByUser(ctx, sendUserInfo)) != null && !StringUtils.isEmpty((String)personInfo.getCell())) {
            addressInfo.setSendMobileNumber(personInfo.getCell().trim());
            addressInfo.setSendCellNumberType(CellphoneNumberTypeEnum.getEnum(MobileUtil.getCellphoneNumberType(personInfo.getCell().trim())));
        }
        sendMoMsgInfo.setAddress(addressInfo);
        return sendMoMsgInfo;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo == null) {
                return;
            }
            if (coreBaseInfo.getId() != null) {
                coreBaseInfo.setId(null);
            }
            this.checkNumOfMsg(coreBaseInfo, ctx);
            IMsgFacade iMsgFacade = MsgFacadeFactory.getLocalInstance(ctx);
            SendMobileMessageInfo info = (SendMobileMessageInfo)coreBaseInfo;
            this.getController(ctx).addnew(coreBaseInfo);
            ++this.alreadySendThisTimeCount;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private void checkNumOfMsg(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ObjectUuidPK orgUnitID = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
        try {
            String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)orgUnitID, (String)"MobileSendLimit");
            if (paramValue.equalsIgnoreCase("false")) {
                return;
            }
            SendMobileMessageInfo info = (SendMobileMessageInfo)coreBaseInfo;
            IMobileMessageAssign mma = MobileMessageAssignFactory.getLocalInstance(ctx);
            String userid = info.getAddress().getSendBizUser().getId().toString();
            String orgid = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            int alreadySendCount = mma.getSendedCountByUserId(userid, orgid);
            ISendMobileMessage smm = (ISendMobileMessage)this.getController(ctx);
            String sql = "select FCanSendCount from T_MO_MobileMessageAssign where FUserID='" + userid + "' and FOrgID='" + orgid + "' ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            int canSendCount = 0;
            if (rs.next()) {
                canSendCount = rs.getInt("FCanSendCount");
            }
            if (alreadySendCount + this.alreadySendThisTimeCount > canSendCount) {
                throw new TaskExternalException("\u5df2\u7ecf\u8d85\u8fc7\u4e86\u53ef\u53d1\u9001\u77ed\u4fe1\u6570\u91cf");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    private String getFieldValue(Hashtable hsData, String key) {
        return ((String)((DataToken)hsData.get((Object)key)).data).trim();
    }

    private void checkRequeiredField(Context ctx, String field, String value) throws Exception {
        if (StringUtils.isEmpty((String)value)) {
            StringBuffer message = new StringBuffer();
            message.append("\u53d1\u9001\u77ed\u4fe1[");
            message.append(field);
            message.append("]\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new Exception(message.toString());
        }
    }

    private String getLegalMobileNumber(String str) throws Exception {
        String number = str.trim();
        if (number.endsWith("E10") || number.endsWith("e10")) {
            String temp = number.substring(0, number.length() - 3);
            BigDecimal num = null;
            try {
                num = new BigDecimal(temp);
            }
            catch (NumberFormatException e) {
                throw new Exception("\u63a5\u6536\u53f7\u7801\u4e0d\u662f\u5408\u6cd5\u7684\u624b\u673a\u53f7\u7801\uff01");
            }
            num = num.multiply(new BigDecimal(10000000000L));
            number = num.toBigInteger().toString();
        }
        try {
            new Long(number);
        }
        catch (NumberFormatException e) {
            throw new Exception("\u63a5\u6536\u53f7\u7801\u4e0d\u662f\u5408\u6cd5\u7684\u624b\u673a\u53f7\u7801\uff01");
        }
        if (number.length() != 11) {
            throw new Exception("\u63a5\u6536\u53f7\u7801\u4e0d\u662f\u5408\u6cd5\u7684\u624b\u673a\u53f7\u7801\uff01");
        }
        return number;
    }
}

