/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.metas.AssignFactory;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.IAssign;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.IPersonFacade;
import com.kingdee.eas.basedata.person.PersonFacadeFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.pc.IProcCatalogFacade;
import com.kingdee.eas.cp.eip.pc.IProcessMobileCommandContext;
import com.kingdee.eas.cp.eip.pc.ProcCatalogFacadeFactory;
import com.kingdee.eas.cp.eip.pc.ProcessMobileCommandContextFactory;
import com.kingdee.eas.cp.eip.pc.ProcessMobileCommandContextInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.BizFunctionCollection;
import com.kingdee.eas.mobile.BizFunctionFactory;
import com.kingdee.eas.mobile.BizFunctionInfo;
import com.kingdee.eas.mobile.CoreReceiveMessageInfo;
import com.kingdee.eas.mobile.EmailReceiveMessageInfo;
import com.kingdee.eas.mobile.IBizFunction;
import com.kingdee.eas.mobile.ReceiveMobileMessageInfo;
import com.kingdee.eas.mobile.biz.AbstractBaseBizFunction;
import com.kingdee.eas.mobile.biz.BizFuncParamObj;
import com.kingdee.eas.mobile.biz.BizReturnObj;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ProcessQueryBiz
extends AbstractBaseBizFunction {
    private static final Logger logger = Logger.getLogger(ProcessQueryBiz.class);
    private static final String RESOURCE = "com.kingdee.eas.mobile.msg.ProcessQueryResource";
    private static final String MOBILERESOURCE = "com.kingdee.eas.mobile.msg.MobileResource";
    public static final int LCXC_VALUE = 1;
    public static final int LCCB_VALUE = 2;
    public static final int GZCX_VALUE = 3;
    public static final int LCCXLCMX_VALUE = 4;
    public static final int LCCX_VALUE = 0;
    private IProcCatalogFacade iProcCatalogFacade = null;
    private IProcessMobileCommandContext iProcessContext = null;
    private final int errorFunctionNum = -99;

    @Override
    public boolean validate(BizFuncParamObj paramObj) {
        if (paramObj.getReceiveMsg() == null || StringUtils.isEmpty((String)paramObj.getReceiveMsg().getRootMsgID())) {
            return false;
        }
        if (paramObj.getReceiveMsg() instanceof ReceiveMobileMessageInfo ? !"for.process".equals(((ReceiveMobileMessageInfo)paramObj.getReceiveMsg()).getParentMsg().getTitle()) && !"for.process".equals(((ReceiveMobileMessageInfo)paramObj.getReceiveMsg()).getParentMsg().getCustomStr()) : paramObj.getReceiveMsg() instanceof EmailReceiveMessageInfo && !"for.process".equals(((EmailReceiveMessageInfo)paramObj.getReceiveMsg()).getParentMsg().getTitle()) && !"for.process".equals(((EmailReceiveMessageInfo)paramObj.getReceiveMsg()).getParentMsg().getCustomStr())) {
            return false;
        }
        int functionNum = this.convertCommand2Int(paramObj.getCommand());
        return functionNum != -99;
    }

    @Override
    public BizReturnObj executeReplyAction(BizFuncParamObj paramObj) {
        return this.executeSendAction(paramObj);
    }

    @Override
    public BizReturnObj executeSendAction(BizFuncParamObj paramObj) {
        String[] params = null;
        Context ctx = paramObj.getCtx();
        String command = paramObj.getCommand();
        CoreReceiveMessageInfo receiveMsg = paramObj.getReceiveMsg();
        if (paramObj.getCommandParams() != null && paramObj.getCommandParams().length > 0) {
            params = new String[paramObj.getCommandParams().length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = paramObj.getCommandParams()[i];
            }
        }
        BizReturnObj bizReturnObj = new BizReturnObj();
        int functionNum = this.convertCommand2Int(command);
        if (functionNum == -99) {
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)MOBILERESOURCE, (String)"byCommand", (Locale)ctx.getLocale()) + command + ResourceBase.getString((String)MOBILERESOURCE, (String)"notFindBiz", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        if (!this.init(ctx)) {
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"SERVER_INIT_FAIL", (Locale)paramObj.getCtx().getLocale()));
            return bizReturnObj;
        }
        if (functionNum == 0) {
            bizReturnObj = this.processFind(ctx, receiveMsg, params, functionNum);
        } else if (functionNum == 1) {
            bizReturnObj = this.processFindNext(ctx, receiveMsg, params, functionNum);
        } else if (functionNum == 2) {
            bizReturnObj = this.payFind(ctx, receiveMsg, params, functionNum);
        } else if (functionNum == 3) {
            bizReturnObj = this.processUrge(ctx, receiveMsg, params, functionNum);
        } else if (functionNum == 4) {
            bizReturnObj = this.processContent(ctx, receiveMsg, params, functionNum);
        }
        return bizReturnObj;
    }

    private BizReturnObj processFind(Context ctx, CoreReceiveMessageInfo receiveMsg, String[] params, int functionNum) {
        BizReturnObj bizReturnObj = null;
        String rootID = null;
        rootID = receiveMsg.getRootMsgID();
        if (StringUtils.isEmpty((String)receiveMsg.getRootMsgID())) {
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"GET_ROOT_MSG_FAIL", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        ProcessMobileCommandContextInfo info = new ProcessMobileCommandContextInfo();
        info.setCommandRoot(functionNum);
        info.setCommandLast(functionNum);
        info.setMsgRootID(rootID);
        info.setPageCount(1);
        String msgIDForInfo = Uuid.create().toString();
        info.setInitiatePersonCell(msgIDForInfo);
        String userID = null;
        if (receiveMsg instanceof ReceiveMobileMessageInfo) {
            userID = ((ReceiveMobileMessageInfo)receiveMsg).getAddress().getSendBizUser().getId().toString();
        } else if (receiveMsg instanceof EmailReceiveMessageInfo) {
            userID = ((EmailReceiveMessageInfo)receiveMsg).getAddress().getSendBizUser().getId().toString();
        }
        ArrayList list = new ArrayList();
        try {
            list = this.iProcCatalogFacade.getMyTransactionProcessByUserAndLanaguage(ctx.getLocale(), 1, 5, "", "", userID);
        }
        catch (EASBizException e) {
            logger.info((Object)("\u83b7\u53d6\u6d41\u7a0b\u6570\u636e\u5931\u8d25:" + e.getMessage()));
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PROCESS_FAILE", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        catch (BOSException e) {
            logger.info((Object)("\u83b7\u53d6\u6d41\u7a0b\u6570\u636e\u5931\u8d25:" + e.getMessage()));
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PROCESS_FAILE", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        if (list == null) {
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"YOU_HAVE_NO_PROCESS", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        int processCount = new Integer((String)list.get(0));
        StringBuffer content = new StringBuffer();
        String assignIDlist = null;
        String assignid = null;
        if (list.size() > 1) {
            int i;
            content.append(ResourceBase.getString((String)RESOURCE, (String)"YOU_HAVE", (Locale)ctx.getLocale()));
            content.append(processCount + ResourceBase.getString((String)RESOURCE, (String)"RESOURCE_COUNT", (Locale)ctx.getLocale()));
            int size = list.size();
            for (int i2 = 1; i2 < size; ++i2) {
                String temp = "";
                String[] obj = (String[])list.get(i2);
                if (obj != null) {
                    if (assignIDlist == null) {
                        assignIDlist = obj[0];
                        assignid = obj[0];
                    } else {
                        assignIDlist = assignIDlist + "," + obj[0];
                    }
                    temp = obj[1];
                }
                if (i2 < size - 1) {
                    content.append(i2 + ResourceBase.getString((String)RESOURCE, (String)"DUHAO", (Locale)ctx.getLocale()) + temp + ResourceBase.getString((String)RESOURCE, (String)"FENHAO", (Locale)ctx.getLocale()));
                    continue;
                }
                content.append(i2 + ResourceBase.getString((String)RESOURCE, (String)"DUHAO", (Locale)ctx.getLocale()) + temp + ResourceBase.getString((String)RESOURCE, (String)"JUHAO", (Locale)ctx.getLocale()));
            }
            IBizFunction iBizFunction = null;
            BizFunctionCollection bizFunctionCo = null;
            BizFunctionInfo bizFunctionInfo = null;
            Object commandObjectInfo = null;
            try {
                iBizFunction = BizFunctionFactory.getLocalInstance(ctx);
                EntityViewInfo evi = new EntityViewInfo();
                evi = new EntityViewInfo();
                evi.getSelector().add(new SelectorItemInfo("id"));
                evi.getSelector().add(new SelectorItemInfo("function"));
                evi.getSelector().add(new SelectorItemInfo("implClassName"));
                evi.getSelector().add(new SelectorItemInfo("commandObj.*"));
                FilterInfo filters = new FilterInfo();
                filters.getFilterItems().add(new FilterItemInfo("implClassName", (Object)this.getClass().getName(), CompareType.EQUALS));
                evi.setFilter(filters);
                evi.getSorter().add(new SorterItemInfo("id"));
                bizFunctionCo = iBizFunction.getBizFunctionCollection(evi);
            }
            catch (BOSException e) {
                logger.info((Object)("\u83b7\u53d6\u7cfb\u7edf\u547d\u4ee4\u5931\u8d25: \u5b9e\u73b0\u7c7b" + this.getClass().getName() + "\u5b9a\u4e49\u7684\u547d\u4ee4\uff01"));
                bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"GET_COMMAND_ERROR", (Locale)ctx.getLocale()) + ",error: " + e.getMessage());
                return bizReturnObj;
            }
            if (bizFunctionCo == null || bizFunctionCo.size() == 0) {
                logger.info((Object)("\u83b7\u53d6\u7cfb\u7edf\u547d\u4ee4\u5931\u8d25: \u65e0\u5b9e\u73b0\u7c7b" + this.getClass().getName() + "\u5b9a\u4e49\u7684\u547d\u4ee4\uff01"));
                bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"GET_COMMAND_ERROR", (Locale)ctx.getLocale()));
                return bizReturnObj;
            }
            boolean isAppendCommand = false;
            Integer functionNumObj = new Integer(1);
            String command = functionNumObj.toString();
            for (i = 0; i < bizFunctionCo.size(); ++i) {
                bizFunctionInfo = bizFunctionCo.get(i);
                if (!command.equals(bizFunctionInfo.getCommandObj().getCommandNumber())) continue;
                content.append(ResourceBase.getString((String)RESOURCE, (String)"GOON", (Locale)ctx.getLocale()) + bizFunctionInfo.getCommandObj().getCommandNumber() + " " + ResourceBase.getString((String)RESOURCE, (String)"PAGE_NUMBER", (Locale)ctx.getLocale()));
                isAppendCommand = true;
            }
            if (isAppendCommand) {
                content.append(ResourceBase.getString((String)RESOURCE, (String)"DUHAO", (Locale)ctx.getLocale()));
                isAppendCommand = false;
            }
            functionNumObj = new Integer(4);
            command = functionNumObj.toString();
            for (i = 0; i < bizFunctionCo.size(); ++i) {
                bizFunctionInfo = bizFunctionCo.get(i);
                if (!command.equals(bizFunctionInfo.getCommandObj().getCommandNumber())) continue;
                content.append(ResourceBase.getString((String)RESOURCE, (String)"PAGE_GOON", (Locale)ctx.getLocale()) + bizFunctionInfo.getCommandObj().getCommandNumber() + " " + ResourceBase.getString((String)RESOURCE, (String)"XUHAO", (Locale)ctx.getLocale()));
                isAppendCommand = true;
            }
            if (isAppendCommand) {
                content.append(ResourceBase.getString((String)RESOURCE, (String)"DUHAO", (Locale)ctx.getLocale()));
                isAppendCommand = false;
            }
            functionNumObj = new Integer(2);
            command = functionNumObj.toString();
            for (i = 0; i < bizFunctionCo.size(); ++i) {
                bizFunctionInfo = bizFunctionCo.get(i);
                if (!command.equals(bizFunctionInfo.getCommandObj().getCommandNumber())) continue;
                content.append(ResourceBase.getString((String)RESOURCE, (String)"CUI_BAN", (Locale)ctx.getLocale()) + bizFunctionInfo.getCommandObj().getCommandNumber() + " " + ResourceBase.getString((String)RESOURCE, (String)"XUHAO", (Locale)ctx.getLocale()));
                isAppendCommand = true;
            }
            if (isAppendCommand) {
                content.append(ResourceBase.getString((String)RESOURCE, (String)"DUHAO", (Locale)ctx.getLocale()));
                isAppendCommand = false;
            }
            info.setAssignIdList(assignIDlist);
            info.setAssignId(BOSUuid.read((String)assignid));
            IObjectPK pk = null;
            try {
                pk = this.iProcessContext.addnew((CoreBaseInfo)info);
            }
            catch (EASBizException e1) {
                logger.info((Object)("\u6d41\u7a0b\u4e2d\u5fc3\u79fb\u52a8\u4e0a\u4e0b\u6587\u521d\u59cb\u5316\u5931\u8d25:" + e1.getMessage()));
                bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PROCESS_FAILE", (Locale)ctx.getLocale()));
                return bizReturnObj;
            }
            catch (BOSException e1) {
                logger.info((Object)("\u6d41\u7a0b\u4e2d\u5fc3\u79fb\u52a8\u4e0a\u4e0b\u6587\u521d\u59cb\u5316\u5931\u8d25:" + e1.getMessage()));
                bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PROCESS_FAILE", (Locale)ctx.getLocale()));
                return bizReturnObj;
            }
        }
        content.append(ResourceBase.getString((String)RESOURCE, (String)"YOU_HAVE_NO_PROCESS", (Locale)ctx.getLocale()));
        bizReturnObj = this.createSucceedReturnObj(content.toString());
        bizReturnObj.setMsgId(msgIDForInfo.toString());
        return bizReturnObj;
    }

    private BizReturnObj processFindNext(Context ctx, CoreReceiveMessageInfo receiveMsg, String[] params, int functionNum) {
        BizReturnObj bizReturnObj = null;
        String rootID = null;
        StringBuffer content = new StringBuffer();
        if (StringUtils.isEmpty((String)receiveMsg.getRootMsgID())) {
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"GET_ROOT_MSG_FAIL", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        rootID = receiveMsg.getRootMsgID();
        String msgIDForInfo = Uuid.create().toString();
        ProcessMobileCommandContextInfo info = null;
        ObjectUuidPK pk = null;
        String osql = "where msgRootID = '" + rootID + "'";
        try {
            info = this.iProcessContext.getProcessMobileCommandContextInfo(osql);
            pk = new ObjectUuidPK(info.getId());
        }
        catch (EASBizException e2) {
            logger.info((Object)("\u6d41\u7a0b\u4e2d\u5fc3\u79fb\u52a8\u4e0a\u4e0b\u6587\u53d6\u6570\u5931\u8d25:" + e2.getMessage()));
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PROCESS_FAILE", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        catch (BOSException e2) {
            logger.info((Object)("\u6d41\u7a0b\u4e2d\u5fc3\u79fb\u52a8\u4e0a\u4e0b\u6587\u53d6\u6570\u5931\u8d25:" + e2.getMessage()));
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PROCESS_FAILE", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        String userID = null;
        String parentMsgId = null;
        if (receiveMsg instanceof ReceiveMobileMessageInfo) {
            userID = ((ReceiveMobileMessageInfo)receiveMsg).getAddress().getSendBizUser().getId().toString();
            parentMsgId = ((ReceiveMobileMessageInfo)receiveMsg).getParentMsg().getMsgID();
        } else if (receiveMsg instanceof EmailReceiveMessageInfo) {
            userID = ((EmailReceiveMessageInfo)receiveMsg).getAddress().getSendBizUser().getId().toString();
            parentMsgId = ((EmailReceiveMessageInfo)receiveMsg).getParentMsg().getMsgID();
        }
        if (!info.getInitiatePersonCell().trim().equals(parentMsgId)) {
            logger.info((Object)ResourceBase.getString((String)RESOURCE, (String)"MESSAGE_BUNENGHUIFU", (Locale)ctx.getLocale()));
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"MESSAGE_BUNENGHUIFU", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        if (info.getCommandLast() == 0 || info.getCommandLast() == 1 && info.getCommandRoot() == 0) {
            int pagecount = info.getPageCount();
            ++pagecount;
            if (params != null && params.length > 0) {
                try {
                    Integer pageInterger = Integer.valueOf(params[0]);
                    pagecount = pageInterger;
                }
                catch (NumberFormatException e) {
                    logger.info((Object)("\u53c2\u6570\u9519\u8bef\uff08\u7b2c\u4e00\u53c2\u6570\u5e94\u4e3a\u6574\u5f62\uff09\uff1a" + e.getMessage()));
                    content.append(ResourceBase.getString((String)RESOURCE, (String)"FIRST_PARAM_MUST_INT", (Locale)ctx.getLocale()));
                    bizReturnObj = this.createSucceedReturnObj(content.toString());
                    return bizReturnObj;
                }
            } else {
                content.append(ResourceBase.getString((String)RESOURCE, (String)"PLEASE_INPUT_NUMBER", (Locale)ctx.getLocale()));
                bizReturnObj = this.createSucceedReturnObj(content.toString());
                return bizReturnObj;
            }
            ArrayList list = new ArrayList();
            try {
                list = this.iProcCatalogFacade.getMyTransactionProcessByUserAndLanaguage(ctx.getLocale(), pagecount, 5, "", "", userID);
            }
            catch (EASBizException e) {
                logger.info((Object)("\u83b7\u53d6\u6d41\u7a0b\u6570\u636e\u5931\u8d25:" + e.getMessage()));
                bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PROCESS_FAILE", (Locale)ctx.getLocale()));
                return bizReturnObj;
            }
            catch (BOSException e) {
                logger.info((Object)("\u83b7\u53d6\u6d41\u7a0b\u6570\u636e\u5931\u8d25:" + e.getMessage()));
                bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PROCESS_FAILE", (Locale)ctx.getLocale()));
                return bizReturnObj;
            }
            if (list == null) {
                bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PAGE_YOUINPUT_HASNT_PROCESS", (Locale)ctx.getLocale()));
                return bizReturnObj;
            }
            int processCount = new Integer((String)list.get(0));
            String assignIDlist = null;
            String assignid = null;
            if (list.size() > 1) {
                int i;
                content.append(ResourceBase.getString((String)RESOURCE, (String)"YOU_HAVE", (Locale)ctx.getLocale()));
                content.append(processCount + ResourceBase.getString((String)RESOURCE, (String)"RESOURCE_COUNT", (Locale)ctx.getLocale()));
                int size = list.size();
                for (int i2 = 1; i2 < size; ++i2) {
                    String temp = "";
                    String[] obj = (String[])list.get(i2);
                    if (obj != null) {
                        if (assignIDlist == null) {
                            assignIDlist = obj[0];
                            assignid = obj[0];
                        } else {
                            assignIDlist = assignIDlist + "," + obj[0];
                        }
                        temp = obj[1];
                    }
                    if (i2 < size - 1) {
                        content.append(i2 + ResourceBase.getString((String)RESOURCE, (String)"DUHAO", (Locale)ctx.getLocale()) + temp + ResourceBase.getString((String)RESOURCE, (String)"FENHAO", (Locale)ctx.getLocale()));
                        continue;
                    }
                    content.append(i2 + ResourceBase.getString((String)RESOURCE, (String)"DUHAO", (Locale)ctx.getLocale()) + temp + ResourceBase.getString((String)RESOURCE, (String)"JUHAO", (Locale)ctx.getLocale()));
                }
                IBizFunction iBizFunction = null;
                BizFunctionCollection bizFunctionCo = null;
                BizFunctionInfo bizFunctionInfo = null;
                Object commandObjectInfo = null;
                try {
                    iBizFunction = BizFunctionFactory.getLocalInstance(ctx);
                    EntityViewInfo evi = new EntityViewInfo();
                    evi = new EntityViewInfo();
                    evi.getSelector().add(new SelectorItemInfo("id"));
                    evi.getSelector().add(new SelectorItemInfo("function"));
                    evi.getSelector().add(new SelectorItemInfo("implClassName"));
                    evi.getSelector().add(new SelectorItemInfo("commandObj.*"));
                    FilterInfo filters = new FilterInfo();
                    filters.getFilterItems().add(new FilterItemInfo("implClassName", (Object)this.getClass().getName(), CompareType.EQUALS));
                    evi.setFilter(filters);
                    evi.getSorter().add(new SorterItemInfo("id"));
                    bizFunctionCo = iBizFunction.getBizFunctionCollection(evi);
                }
                catch (BOSException e) {
                    logger.info((Object)("\u83b7\u53d6\u7cfb\u7edf\u547d\u4ee4\u5931\u8d25: \u5b9e\u73b0\u7c7b" + this.getClass().getName() + "\u5b9a\u4e49\u7684\u547d\u4ee4\uff01"));
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"GET_COMMAND_ERROR", (Locale)ctx.getLocale()) + ",error: " + e.getMessage());
                    return bizReturnObj;
                }
                if (bizFunctionCo == null || bizFunctionCo.size() == 0) {
                    logger.info((Object)("\u83b7\u53d6\u7cfb\u7edf\u547d\u4ee4\u5931\u8d25: \u65e0\u5b9e\u73b0\u7c7b" + this.getClass().getName() + "\u5b9a\u4e49\u7684\u547d\u4ee4\uff01"));
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"GET_COMMAND_ERROR", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                boolean isAppendCommand = false;
                Integer functionNumObj = new Integer(1);
                String command = functionNumObj.toString();
                for (i = 0; i < bizFunctionCo.size(); ++i) {
                    bizFunctionInfo = bizFunctionCo.get(i);
                    if (!command.equals(bizFunctionInfo.getCommandObj().getCommandNumber())) continue;
                    content.append(ResourceBase.getString((String)RESOURCE, (String)"GOON", (Locale)ctx.getLocale()) + bizFunctionInfo.getCommandObj().getCommandNumber() + " " + ResourceBase.getString((String)RESOURCE, (String)"PAGE_NUMBER", (Locale)ctx.getLocale()));
                    isAppendCommand = true;
                }
                if (isAppendCommand) {
                    content.append(ResourceBase.getString((String)RESOURCE, (String)"DUHAO", (Locale)ctx.getLocale()));
                    isAppendCommand = false;
                }
                functionNumObj = new Integer(4);
                command = functionNumObj.toString();
                for (i = 0; i < bizFunctionCo.size(); ++i) {
                    bizFunctionInfo = bizFunctionCo.get(i);
                    if (!command.equals(bizFunctionInfo.getCommandObj().getCommandNumber())) continue;
                    content.append(ResourceBase.getString((String)RESOURCE, (String)"PAGE_GOON", (Locale)ctx.getLocale()) + bizFunctionInfo.getCommandObj().getCommandNumber() + " " + ResourceBase.getString((String)RESOURCE, (String)"XUHAO", (Locale)ctx.getLocale()));
                    isAppendCommand = true;
                }
                if (isAppendCommand) {
                    content.append(ResourceBase.getString((String)RESOURCE, (String)"DUHAO", (Locale)ctx.getLocale()));
                    isAppendCommand = false;
                }
                functionNumObj = new Integer(2);
                command = functionNumObj.toString();
                for (i = 0; i < bizFunctionCo.size(); ++i) {
                    bizFunctionInfo = bizFunctionCo.get(i);
                    if (!command.equals(bizFunctionInfo.getCommandObj().getCommandNumber())) continue;
                    content.append(ResourceBase.getString((String)RESOURCE, (String)"CUI_BAN", (Locale)ctx.getLocale()) + bizFunctionInfo.getCommandObj().getCommandNumber() + " " + ResourceBase.getString((String)RESOURCE, (String)"XUHAO", (Locale)ctx.getLocale()));
                    isAppendCommand = true;
                }
                if (isAppendCommand) {
                    content.append(ResourceBase.getString((String)RESOURCE, (String)"DUHAO", (Locale)ctx.getLocale()));
                    isAppendCommand = false;
                }
            } else {
                content.append(ResourceBase.getString((String)RESOURCE, (String)"PAGE_YOUINPUT_HASNT_PROCESS", (Locale)ctx.getLocale()));
                bizReturnObj = this.createSucceedReturnObj(content.toString());
                return bizReturnObj;
            }
            try {
                info.setPageCount(pagecount);
                info.setAssignId(BOSUuid.read((String)assignid));
                info.setAssignIdList(assignIDlist);
                info.setInitiatePersonCell(msgIDForInfo);
                this.iProcessContext.update((IObjectPK)pk, (CoreBaseInfo)info);
            }
            catch (EASBizException e1) {
                logger.info((Object)("\u6d41\u7a0b\u4e2d\u5fc3\u79fb\u52a8\u4e0a\u4e0b\u6587\u66f4\u65b0\u5931\u8d25:" + e1.getMessage()));
                bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PROCESS_FAILE", (Locale)ctx.getLocale()));
                return bizReturnObj;
            }
            catch (BOSException e1) {
                logger.info((Object)("\u6d41\u7a0b\u4e2d\u5fc3\u79fb\u52a8\u4e0a\u4e0b\u6587\u66f4\u65b0\u5931\u8d25:" + e1.getMessage()));
                bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PROCESS_FAILE", (Locale)ctx.getLocale()));
                return bizReturnObj;
            }
        }
        bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"COMMAND_ERROR", (Locale)ctx.getLocale()));
        return bizReturnObj;
        bizReturnObj = this.createSucceedReturnObj(content.toString());
        bizReturnObj.setMsgId(msgIDForInfo);
        return bizReturnObj;
    }

    private BizReturnObj processUrge(Context ctx, CoreReceiveMessageInfo receiveMsg, String[] params, int functionNum) {
        BizReturnObj bizReturnObj = null;
        String rootID = null;
        StringBuffer content = new StringBuffer();
        String assignmentID = null;
        if (StringUtils.isEmpty((String)receiveMsg.getRootMsgID())) {
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"GET_ROOT_MSG_FAIL", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        rootID = receiveMsg.getRootMsgID();
        String msgIDForInfo = Uuid.create().toString();
        ProcessMobileCommandContextInfo info = null;
        ObjectUuidPK pk = null;
        String osql = "where msgRootID = '" + rootID + "'";
        try {
            info = this.iProcessContext.getProcessMobileCommandContextInfo(osql);
            pk = new ObjectUuidPK(info.getId());
        }
        catch (EASBizException e2) {
            logger.info((Object)("\u6d41\u7a0b\u4e2d\u5fc3\u79fb\u52a8\u4e0a\u4e0b\u6587\u53d6\u6570\u5931\u8d25:" + e2.getMessage()));
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PROCESS_FAILE", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        catch (BOSException e2) {
            logger.info((Object)("\u6d41\u7a0b\u4e2d\u5fc3\u79fb\u52a8\u4e0a\u4e0b\u6587\u53d6\u6570\u5931\u8d25:" + e2.getMessage()));
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PROCESS_FAILE", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        String userID = null;
        String parentMsgId = null;
        if (receiveMsg instanceof ReceiveMobileMessageInfo) {
            userID = ((ReceiveMobileMessageInfo)receiveMsg).getAddress().getSendBizUser().getId().toString();
            parentMsgId = ((ReceiveMobileMessageInfo)receiveMsg).getParentMsg().getMsgID();
        } else if (receiveMsg instanceof EmailReceiveMessageInfo) {
            userID = ((EmailReceiveMessageInfo)receiveMsg).getAddress().getSendBizUser().getId().toString();
            parentMsgId = ((EmailReceiveMessageInfo)receiveMsg).getParentMsg().getMsgID();
        }
        if (!info.getInitiatePersonCell().trim().equals(parentMsgId)) {
            logger.info((Object)ResourceBase.getString((String)RESOURCE, (String)"MESSAGE_BUNENGHUIFU", (Locale)ctx.getLocale()));
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"MESSAGE_BUNENGHUIFU", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        if (info.getCommandLast() == 0 || info.getCommandLast() == 1 && info.getCommandRoot() == 0) {
            int processNumber = -1;
            if (params == null || params.length < 1) {
                logger.info((Object)"\u547d\u4ee4\u8f93\u5165\u9519\u8bef\uff0c\u60a8\u6ca1\u6709\u8f93\u5165\u60a8\u8981\u50ac\u529e\u7684\u6d41\u7a0b\u53f7\u7801");
                content.append(ResourceBase.getString((String)RESOURCE, (String)"COMMAND_PARAM_ERROR", (Locale)ctx.getLocale()));
                bizReturnObj = this.createFailReturnObj(content.toString());
                return bizReturnObj;
            }
            try {
                processNumber = Integer.valueOf(params[0]);
            }
            catch (NumberFormatException numException) {
                logger.info((Object)("\u53c2\u6570\u9519\u8bef\uff08\u7b2c\u4e00\u53c2\u6570\u5e94\u4e3a\u6574\u5f62\uff09:" + numException.getMessage()));
                content.append(ResourceBase.getString((String)RESOURCE, (String)"COMMAND_PARAM_ERROR", (Locale)ctx.getLocale()));
                bizReturnObj = this.createFailReturnObj(content.toString());
                return bizReturnObj;
            }
            if (processNumber > 5) {
                logger.info((Object)"\u6d41\u7a0b\u53f7\u7801\u4e0d\u80fd\u5927\u4e8e5");
                content.append(ResourceBase.getString((String)RESOURCE, (String)"PARAM_ERROR_NUM_BIGGERTHAN5", (Locale)ctx.getLocale()) + 5);
                bizReturnObj = this.createFailReturnObj(content.toString());
                return bizReturnObj;
            }
            if (processNumber > 0 && processNumber < 6) {
                String assignIDList = info.getAssignIdList();
                String[] assignID = null;
                if (assignIDList == null && assignIDList.trim().length() >= 1) {
                    logger.info((Object)"\u83b7\u53d6\u6d41\u7a0b\u6570\u636e\u5931\u8d25:");
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PROCESS_FAILE", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                assignID = assignIDList.split(",");
                if (processNumber > assignID.length) {
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PARAM_ERROR_NUM_BIGGERTHAN5", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                assignmentID = assignID[processNumber - 1];
                AssignInfo assignInfo = null;
                IAssign iAssign = null;
                UserInfo user = null;
                try {
                    iAssign = AssignFactory.getLocalInstance((Context)ctx);
                    assignInfo = iAssign.getValue((IObjectPK)new ObjectUuidPK(assignmentID));
                }
                catch (Exception e) {
                    logger.info((Object)"\u4efb\u52a1\u4efb\u52a1\u5931\u8d25");
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"GET_ASSIGN_ERROR", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                BOSUuid personUserId = assignInfo.getPersonUserID();
                BOSUuid personId = null;
                if (personUserId == null || personUserId.toString().trim().length() < 1) {
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"GET_USER_FAIL", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                try {
                    user = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(personUserId));
                }
                catch (Exception e) {
                    logger.info((Object)"\u4efb\u52a1\u7528\u6237\u5931\u8d25");
                }
                if (user == null) {
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PROCESS_FAILR_ASSIGN_FAIL", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                PersonInfo person = null;
                personId = user.getPerson().getId();
                try {
                    person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
                }
                catch (EASBizException eASBizException) {
                }
                catch (BOSException bOSException) {
                    // empty catch block
                }
                if (person == null) {
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"GET_USER_FAIL", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                String mobile = person.getCell();
                if (mobile == null || mobile.trim().length() < 1) {
                    logger.info((Object)"\u7528\u6237\u6ca1\u6709\u5728EAS\u7cfb\u7edf\u4e2d\u6ce8\u518c\u624b\u673a\u53f7\u7801");
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"USER_HASNOT_SIGN_CELL", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                String subject = assignInfo.getSubject();
                content = new StringBuffer(ResourceBase.getString((String)RESOURCE, (String)"YOU_MUST_DO_THIS_PROCESS", (Locale)ctx.getLocale()));
                content.append(subject);
                String packageName = assignInfo.getBizPackage();
                String funcName = assignInfo.getBizFunction();
                String operationName = assignInfo.getBizOperation();
                if (packageName != null && packageName.trim().length() > 0 && funcName != null && funcName.trim().length() > 0 && operationName != null && operationName.trim().length() > 0 && packageName.trim().equals("com.kingdee.eas.base.multiapprove.client") && funcName.trim().equals("MultiApproveUIFunction") && operationName.trim().equals("ActionSubmit")) {
                    content.append(ResourceBase.getString((String)RESOURCE, (String)"AUDIT_RETURN_Y_ELSE_N", (Locale)ctx.getLocale()));
                }
                bizReturnObj = this.createSucceedReturnObj(content.toString());
                bizReturnObj.setMsgId(msgIDForInfo);
                bizReturnObj.setAssignmentID(assignmentID);
                info.setInitiatePersonCell(msgIDForInfo);
                try {
                    this.iProcessContext.update((IObjectPK)pk, (CoreBaseInfo)info);
                }
                catch (EASBizException e) {
                    logger.info((Object)ResourceBase.getString((String)RESOURCE, (String)"COMMAND_ERROR", (Locale)ctx.getLocale()));
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"COMMAND_ERROR", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                catch (BOSException e) {
                    logger.info((Object)ResourceBase.getString((String)RESOURCE, (String)"COMMAND_ERROR", (Locale)ctx.getLocale()));
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"COMMAND_ERROR", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                return bizReturnObj;
            }
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PARAM_ERROR_NUM_BIGGERTHAN5", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        if (info.getCommandLast() == 4 && info.getCommandRoot() == 0) {
            BOSUuid assignID = info.getAssignId();
            assignmentID = assignID.toString();
            if (assignID != null) {
                AssignInfo assignInfo = null;
                IAssign iAssign = null;
                BOSUuid personId = null;
                UserInfo user = null;
                try {
                    user = this.getPersonByAssign(ctx, assignID);
                }
                catch (EASBizException e2) {
                    logger.info((Object)("\u4efb\u52a1\u7528\u6237\u5931\u8d25:" + e2.getMessage()));
                }
                catch (BOSException e2) {
                    logger.info((Object)("\u4efb\u52a1\u7528\u6237\u5931\u8d25" + e2.getMessage()));
                }
                if (user == null) {
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PROCESS_FAILR_ASSIGN_FAIL", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                personId = user.getPerson().getId();
                PersonInfo person = null;
                try {
                    person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
                }
                catch (EASBizException e1) {
                    e1.printStackTrace();
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
                if (person == null) {
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"GET_USER_FAIL", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                String mobile = person.getCell();
                if (mobile == null || mobile.trim().length() < 1) {
                    logger.info((Object)"\u7528\u6237\u6ca1\u6709\u5728EAS\u7cfb\u7edf\u4e2d\u6ce8\u518c\u624b\u673a\u53f7\u7801");
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"USER_HASNOT_SIGN_CELL", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                try {
                    iAssign = AssignFactory.getLocalInstance((Context)ctx);
                    assignInfo = iAssign.getValue((IObjectPK)new ObjectUuidPK(assignID));
                }
                catch (BOSException e) {
                    logger.info((Object)"\u4efb\u52a1\u7528\u6237\u5931\u8d25");
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"GET_ASSIGN_ERROR", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                String subject = assignInfo.getSubject();
                content = new StringBuffer(ResourceBase.getString((String)RESOURCE, (String)"YOU_MUST_DO_THIS_PROCESS", (Locale)ctx.getLocale()));
                content.append(subject);
                String packageName = assignInfo.getBizPackage();
                String funcName = assignInfo.getBizFunction();
                String operationName = assignInfo.getBizOperation();
                if (packageName != null && packageName.trim().length() > 0 && funcName != null && funcName.trim().length() > 0 && operationName != null && operationName.trim().length() > 0 && packageName.trim().equals("com.kingdee.eas.base.multiapprove.client") && funcName.trim().equals("MultiApproveUIFunction") && operationName.trim().equals("ActionSubmit")) {
                    content.append(ResourceBase.getString((String)RESOURCE, (String)"AUDIT_RETURN_Y_ELSE_N", (Locale)ctx.getLocale()));
                }
                bizReturnObj = this.createSucceedReturnObj(content.toString());
                bizReturnObj.setMsgId(msgIDForInfo);
                bizReturnObj.setAssignmentID(assignmentID);
                info.setInitiatePersonCell(msgIDForInfo);
                info.setInitiatePersonCell(msgIDForInfo);
                try {
                    this.iProcessContext.update((IObjectPK)pk, (CoreBaseInfo)info);
                }
                catch (EASBizException e) {
                    logger.info((Object)ResourceBase.getString((String)RESOURCE, (String)"COMMAND_ERROR", (Locale)ctx.getLocale()));
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"COMMAND_ERROR", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                catch (BOSException e) {
                    logger.info((Object)ResourceBase.getString((String)RESOURCE, (String)"COMMAND_ERROR", (Locale)ctx.getLocale()));
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"COMMAND_ERROR", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                return bizReturnObj;
            }
        } else {
            bizReturnObj = this.createFailReturnObj("\u547d\u4ee4\u8f93\u5165\u9519\u8bef\uff0c\u8bf7\u5148\u8fdb\u884c\u6d41\u7a0b\u67e5\u8be2\u64cd\u4f5c");
            return bizReturnObj;
        }
        bizReturnObj = this.createSucceedReturnObj(content.toString());
        bizReturnObj.setMsgId(msgIDForInfo);
        bizReturnObj.setAssignmentID(assignmentID);
        return bizReturnObj;
    }

    private BizReturnObj payFind(Context ctx, CoreReceiveMessageInfo receiveMsg, String[] params, int functionNum) {
        BizReturnObj bizReturnObj = null;
        if (params.length < 1) {
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"COMMAND_ERROR", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        String name = params[0];
        if (name == null || name.length() < 1) {
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"COMMAND_ERROR", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        IPersonFacade iPF = null;
        try {
            iPF = PersonFacadeFactory.getLocalInstance((Context)ctx);
            String str = iPF.getAddressList(name);
            bizReturnObj = str == null ? this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"USER_NOT_EXIT", (Locale)ctx.getLocale())) : this.createSucceedReturnObj(str);
        }
        catch (BOSException e) {
            logger.info((Object)("EAS\u670d\u52a1\u5668\u5f02\u5e38" + e.getMessage()));
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"EAS_ERROR", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        catch (EASBizException e) {
            logger.info((Object)("EAS\u670d\u52a1\u5668\u5f02\u5e38" + e.getMessage()));
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"EAS_ERROR", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        return bizReturnObj;
    }

    private BizReturnObj processContent(Context ctx, CoreReceiveMessageInfo receiveMsg, String[] params, int functionNum) {
        BizReturnObj bizReturnObj = null;
        String rootID = null;
        StringBuffer content = new StringBuffer();
        String assignmentID = null;
        if (StringUtils.isEmpty((String)receiveMsg.getRootMsgID())) {
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"GET_ROOT_MSG_FAIL", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        rootID = receiveMsg.getRootMsgID();
        String msgIDForInfo = Uuid.create().toString();
        ProcessMobileCommandContextInfo info = null;
        ObjectUuidPK pk = null;
        String osql = "where msgRootID = '" + rootID + "'";
        try {
            info = this.iProcessContext.getProcessMobileCommandContextInfo(osql);
            pk = new ObjectUuidPK(info.getId());
        }
        catch (EASBizException e2) {
            logger.info((Object)("\u6d41\u7a0b\u4e2d\u5fc3\u79fb\u52a8\u4e0a\u4e0b\u6587\u53d6\u6570\u5931\u8d25:" + e2.getMessage()));
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"COMMAND_ERROR", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        catch (BOSException e2) {
            logger.info((Object)("\u6d41\u7a0b\u4e2d\u5fc3\u79fb\u52a8\u4e0a\u4e0b\u6587\u53d6\u6570\u5931\u8d25:" + e2.getMessage()));
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"COMMAND_ERROR", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        String userID = null;
        String parentMsgId = null;
        if (receiveMsg instanceof ReceiveMobileMessageInfo) {
            userID = ((ReceiveMobileMessageInfo)receiveMsg).getAddress().getSendBizUser().getId().toString();
            parentMsgId = ((ReceiveMobileMessageInfo)receiveMsg).getParentMsg().getMsgID();
        } else if (receiveMsg instanceof EmailReceiveMessageInfo) {
            userID = ((EmailReceiveMessageInfo)receiveMsg).getAddress().getSendBizUser().getId().toString();
            parentMsgId = ((EmailReceiveMessageInfo)receiveMsg).getParentMsg().getMsgID();
        }
        if (!info.getInitiatePersonCell().trim().equals(parentMsgId)) {
            logger.info((Object)ResourceBase.getString((String)RESOURCE, (String)"MESSAGE_BUNENGHUIFU", (Locale)ctx.getLocale()));
            bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"MESSAGE_BUNENGHUIFU", (Locale)ctx.getLocale()));
            return bizReturnObj;
        }
        if (info.getCommandLast() == 0 || info.getCommandLast() == 1 && info.getCommandRoot() == 0) {
            int pagecount = info.getPageCount();
            int processNumber = -1;
            if (params != null && params.length > 0) {
                try {
                    Integer pageInterger = Integer.valueOf(params[0]);
                    processNumber = pageInterger;
                }
                catch (NumberFormatException e) {
                    logger.info((Object)("\u53c2\u6570\u9519\u8bef\uff08\u7b2c\u4e00\u53c2\u6570\u5e94\u4e3a\u6574\u5f62\uff09\uff1a" + e.getMessage()));
                    content.append(ResourceBase.getString((String)RESOURCE, (String)"FIRST_PARAM_MUST_INT", (Locale)ctx.getLocale()));
                    bizReturnObj = this.createFailReturnObj(content.toString());
                    return bizReturnObj;
                }
            } else {
                bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PLEASE_INPUT_NUMBER", (Locale)ctx.getLocale()));
                return bizReturnObj;
            }
            if (processNumber > 0 && processNumber < 6) {
                String[] assignList = info.getAssignIdList().split(",");
                if (processNumber > assignList.length) {
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"PARAM_ERROR_NUM_BIGGERTHAN5", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                String assign = assignList[processNumber - 1];
                content = new StringBuffer(ResourceBase.getString((String)RESOURCE, (String)"CONTENT", (Locale)ctx.getLocale()));
                String subject = null;
                try {
                    subject = this.getProcessContent(ctx, assign);
                }
                catch (BOSException e1) {
                    logger.info((Object)("BOSException :" + e1.getMessage()));
                    subject = null;
                }
                if (subject == null) {
                    content = new StringBuffer("\u8be5\u6d88\u606f\u4e0d\u662f\u4efb\u52a1\u6d88\u606f");
                    bizReturnObj = this.createFailReturnObj(content.toString());
                    return bizReturnObj;
                }
                content.append(subject);
                IBizFunction iBizFunction = null;
                BizFunctionCollection bizFunctionCo = null;
                BizFunctionInfo bizFunctionInfo = null;
                Object commandObjectInfo = null;
                try {
                    iBizFunction = BizFunctionFactory.getLocalInstance(ctx);
                    EntityViewInfo evi = new EntityViewInfo();
                    evi = new EntityViewInfo();
                    evi.getSelector().add(new SelectorItemInfo("id"));
                    evi.getSelector().add(new SelectorItemInfo("function"));
                    evi.getSelector().add(new SelectorItemInfo("implClassName"));
                    evi.getSelector().add(new SelectorItemInfo("commandObj.*"));
                    FilterInfo filters = new FilterInfo();
                    filters.getFilterItems().add(new FilterItemInfo("implClassName", (Object)this.getClass().getName(), CompareType.EQUALS));
                    evi.setFilter(filters);
                    evi.getSorter().add(new SorterItemInfo("id"));
                    bizFunctionCo = iBizFunction.getBizFunctionCollection(evi);
                }
                catch (BOSException e) {
                    logger.info((Object)("\u83b7\u53d6\u7cfb\u7edf\u547d\u4ee4\u5931\u8d25: \u5b9e\u73b0\u7c7b" + this.getClass().getName() + "\u5b9a\u4e49\u7684\u547d\u4ee4\uff01"));
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"GET_COMMAND_ERROR", (Locale)ctx.getLocale()) + ",error: " + e.getMessage());
                    return bizReturnObj;
                }
                if (bizFunctionCo == null || bizFunctionCo.size() == 0) {
                    logger.info((Object)("\u83b7\u53d6\u7cfb\u7edf\u547d\u4ee4\u5931\u8d25: \u65e0\u5b9e\u73b0\u7c7b" + this.getClass().getName() + "\u5b9a\u4e49\u7684\u547d\u4ee4\uff01"));
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"GET_COMMAND_ERROR", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                Integer functionNumObj = new Integer(2);
                String command = functionNumObj.toString();
                for (int i = 0; i < bizFunctionCo.size(); ++i) {
                    bizFunctionInfo = bizFunctionCo.get(i);
                    if (!command.equals(bizFunctionInfo.getCommandObj().getCommandNumber())) continue;
                    content.append(ResourceBase.getString((String)RESOURCE, (String)"CUI_BAN", (Locale)ctx.getLocale()) + bizFunctionInfo.getCommandObj().getCommandNumber());
                }
                bizReturnObj = this.createSucceedReturnObj(content.toString());
                bizReturnObj.setMsgId(msgIDForInfo);
                bizReturnObj.setAssignmentID(assignmentID);
                info.setCommandLast(4);
                info.setAssignId(BOSUuid.read((String)assign));
                info.setPageCount(pagecount);
                info.setInitiatePersonCell(msgIDForInfo);
                try {
                    this.iProcessContext.update((IObjectPK)pk, (CoreBaseInfo)info);
                }
                catch (EASBizException e) {
                    logger.info((Object)ResourceBase.getString((String)RESOURCE, (String)"COMMAND_ERROR", (Locale)ctx.getLocale()));
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"COMMAND_ERROR", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
                catch (BOSException e) {
                    logger.info((Object)ResourceBase.getString((String)RESOURCE, (String)"COMMAND_ERROR", (Locale)ctx.getLocale()));
                    bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"COMMAND_ERROR", (Locale)ctx.getLocale()));
                    return bizReturnObj;
                }
            }
            content.append(ResourceBase.getString((String)RESOURCE, (String)"PARAM_ERROR_NUM_BIGGERTHAN5", (Locale)ctx.getLocale()) + 5);
            logger.info((Object)content.toString());
            bizReturnObj = this.createFailReturnObj(content.toString());
            return bizReturnObj;
        }
        bizReturnObj = this.createFailReturnObj(ResourceBase.getString((String)RESOURCE, (String)"COMMAND_ERROR", (Locale)ctx.getLocale()));
        return bizReturnObj;
    }

    private String getProcessContent(Context ctx, String assignID) throws BOSException {
        if (assignID != null && assignID.trim().length() < 1) {
            throw new BOSException();
        }
        if (ctx.getLocale() == null) {
            ctx.setLocale(new Locale("L2"));
        }
        StringBuffer sql = new StringBuffer("select FSubject_").append(ctx.getLocale()).append(",FPersonUserName_");
        sql.append(ctx.getLocale() + ",FActdefName_").append(ctx.getLocale());
        sql.append(",FCreatedTime from T_WFR_Assign");
        sql.append(" where FAssignID = '");
        sql.append(assignID).append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                StringBuffer content = new StringBuffer(ResourceBase.getString((String)RESOURCE, (String)"ZHUTI", (Locale)ctx.getLocale()) + rows.getString(1));
                content.append(ResourceBase.getString((String)RESOURCE, (String)"ZHIXINGREN", (Locale)ctx.getLocale()) + rows.getString(2));
                content.append(ResourceBase.getString((String)RESOURCE, (String)"DANGQIANHUANJIE", (Locale)ctx.getLocale()) + rows.getString(3));
                content.append(ResourceBase.getString((String)RESOURCE, (String)"DAODASHIJIAN", (Locale)ctx.getLocale()) + rows.getString(4));
                return content.toString();
            }
        }
        catch (SQLException e) {
            throw new BOSException();
        }
        return null;
    }

    private UserInfo getPersonByAssign(Context ctx, BOSUuid assignID) throws BOSException, EASBizException {
        AssignInfo assignInfo = null;
        IAssign iAssign = null;
        UserInfo user = null;
        iAssign = AssignFactory.getLocalInstance((Context)ctx);
        assignInfo = iAssign.getValue((IObjectPK)new ObjectUuidPK(assignID));
        BOSUuid personId = assignInfo.getPersonUserID();
        user = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(personId));
        return user;
    }

    private BizReturnObj createFailReturnObj(String errorText) {
        BizReturnObj bizReturnObj = new BizReturnObj();
        bizReturnObj.setErrorText(errorText);
        bizReturnObj.setReturnText("");
        bizReturnObj.setTitle("for.process");
        bizReturnObj.setCustomStr("for.process");
        bizReturnObj.setSucceed(false);
        bizReturnObj.setMustReply(true);
        return bizReturnObj;
    }

    private BizReturnObj createSucceedReturnObj(String returnText) {
        BizReturnObj bizReturnObj = new BizReturnObj();
        bizReturnObj.setErrorText("");
        bizReturnObj.setReturnText(returnText);
        bizReturnObj.setTitle("for.process");
        bizReturnObj.setCustomStr("for.process");
        bizReturnObj.setSucceed(true);
        bizReturnObj.setMustReply(true);
        return bizReturnObj;
    }

    public boolean init(Context ctx) {
        boolean success = false;
        try {
            this.iProcessContext = ProcessMobileCommandContextFactory.getLocalInstance((Context)ctx);
            this.iProcCatalogFacade = ProcCatalogFacadeFactory.getLocalInstance((Context)ctx);
            success = true;
        }
        catch (BOSException e) {
            logger.info((Object)("\u83b7\u53d6\u6d41\u7a0b\u4fe1\u606f\u5931\u8d25\uff1aBOSException =" + e.getMessage()));
        }
        return success;
    }

    private int convertCommand2Int(String command) {
        int functionNum = -99;
        if (StringUtils.isEmpty((String)command) || command.length() > 1) {
            return -99;
        }
        char numKey = command.charAt(0);
        switch (numKey) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                break;
            }
            default: {
                return -99;
            }
        }
        switch (Integer.parseInt(command)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                functionNum = Integer.parseInt(command);
                break;
            }
            default: {
                return -99;
            }
        }
        return functionNum;
    }
}

