/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.SubmitAssignResult;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.InputType;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.CoreReceiveMessageInfo;
import com.kingdee.eas.mobile.CoreSendMessageInfo;
import com.kingdee.eas.mobile.EmailReceiveMessageInfo;
import com.kingdee.eas.mobile.ReceiveMobileMessageInfo;
import com.kingdee.eas.mobile.biz.AbstractBaseBizFunction;
import com.kingdee.eas.mobile.biz.BizFuncParamObj;
import com.kingdee.eas.mobile.biz.BizReturnObj;
import com.kingdee.eas.mobile.biz.IBizService;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WorkflowBIZ
extends AbstractBaseBizFunction
implements IBizService {
    private static final String MOBILERESOURCE = "com.kingdee.eas.mobile.msg.MobileResource";
    private static final Logger logger = Logger.getLogger(WorkflowBIZ.class);
    private Hashtable assignmentMap = new Hashtable();
    private IEnactmentService WFService;
    private IMultiApprove iMultiApprove;

    @Override
    public boolean validate(BizFuncParamObj paramObj) {
        logger.info((Object)("---mobile---WorkflowBIZ--validate--" + paramObj.getReceiveMsg().getContent()));
        if (paramObj.getReceiveMsg() == null || StringUtils.isEmpty((String)paramObj.getReceiveMsg().getRootMsgID())) {
            logger.info((Object)("---mobile---WorkflowBIZ--\u63a5\u6536\u77ed\u4fe1\u6ca1\u6709ParentMsg\u6216RootMsgID,id:" + paramObj.getReceiveMsg().getId().toString()));
            return false;
        }
        CoreSendMessageInfo coreSendMessageInfo = null;
        if (paramObj.getReceiveMsg() instanceof ReceiveMobileMessageInfo) {
            coreSendMessageInfo = ((ReceiveMobileMessageInfo)paramObj.getReceiveMsg()).getParentMsg();
        } else if (paramObj.getReceiveMsg() instanceof EmailReceiveMessageInfo) {
            coreSendMessageInfo = ((EmailReceiveMessageInfo)paramObj.getReceiveMsg()).getParentMsg();
        }
        String msgId = coreSendMessageInfo.getMsgID();
        String assignId = paramObj.getAssignID();
        if (StringUtils.isEmpty((String)assignId)) {
            logger.info((Object)("---mobile---WorkflowBIZ--\u63a5\u6536\u77ed\u4fe1\u6ca1\u6709\u5de5\u4f5c\u6d41ID,id:" + paramObj.getReceiveMsg().getId().toString()));
            return false;
        }
        this.assignmentMap.put(msgId, assignId);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BizReturnObj executeReplyAction(BizFuncParamObj paramObj) {
        logger.info((Object)("---mobile---WorkflowBIZ--executeReplyAction()---" + paramObj.getReceiveMsg().getContent()));
        BizReturnObj bizReturnObj = new BizReturnObj();
        Context ctx = paramObj.getCtx();
        if (WorkflowBIZ.disableSMSApprove(ctx)) {
            return null;
        }
        UserInfo userInfo = null;
        CoreSendMessageInfo coreSendMessageInfo = null;
        if (paramObj.getReceiveMsg() instanceof ReceiveMobileMessageInfo) {
            coreSendMessageInfo = ((ReceiveMobileMessageInfo)paramObj.getReceiveMsg()).getParentMsg();
            userInfo = ((ReceiveMobileMessageInfo)paramObj.getReceiveMsg()).getAddress().getSendBizUser();
        } else if (paramObj.getReceiveMsg() instanceof EmailReceiveMessageInfo) {
            coreSendMessageInfo = ((EmailReceiveMessageInfo)paramObj.getReceiveMsg()).getParentMsg();
            userInfo = ((EmailReceiveMessageInfo)paramObj.getReceiveMsg()).getAddress().getSendBizUser();
        }
        if (userInfo == null) {
            logger.info((Object)"---mobile---WorkflowBIZ---userInfo is null");
            return this.createFailReturnObj(ResourceBase.getString((String)MOBILERESOURCE, (String)"cannotGetUser", (Locale)ctx.getLocale()));
        }
        CoreReceiveMessageInfo coreReceiveMessageInfo = paramObj.getReceiveMsg();
        logger.info((Object)("---mobile---WorkflowBIZ---doing--\u5de5\u4f5c\u6d41\u6a21\u5757\u6b63\u5728\u5904\u7406\u8be5\u6d88\u606f" + paramObj.getReceiveMsg().getTitle()));
        String approveContent = "";
        if ("mp:mail".equals(coreReceiveMessageInfo.getMsgDevType())) {
            int index;
            Configuration bosConfig = Configuration.getInstance();
            ConfigurationItem sln = bosConfig.getConfigItem("PortalInfo");
            logger.info((Object)("---mobile---WorkflowBIZ---sln=" + sln));
            if (sln != null) {
                String isAllowEMailAudit = sln.getProperty("isAllowEMailAudit");
                logger.info((Object)("---mobile---WorkflowBIZ---isAllowEMailAudit=" + isAllowEMailAudit));
                if (isAllowEMailAudit == null) return this.createFailReturnObj(ResourceBase.getString((String)MOBILERESOURCE, (String)"systemIsNotAllowEmailAudit", (Locale)ctx.getLocale()));
                if (!isAllowEMailAudit.trim().equalsIgnoreCase("true")) {
                    return this.createFailReturnObj(ResourceBase.getString((String)MOBILERESOURCE, (String)"systemIsNotAllowEmailAudit", (Locale)ctx.getLocale()));
                }
            }
            if ((index = (approveContent = coreReceiveMessageInfo.getContent()).toLowerCase().indexOf("<body")) > 0) {
                approveContent = approveContent.substring(index);
                String regEx = "<[^>]+>|</[^>]+>";
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(approveContent);
                approveContent = m.replaceAll("");
                approveContent.trim();
                if (approveContent.indexOf("&nbsp;") > 0) {
                    regEx = "&nbsp;";
                    p = Pattern.compile(regEx);
                    m = p.matcher(approveContent);
                    approveContent = m.replaceAll("");
                    approveContent = approveContent.trim();
                }
                coreReceiveMessageInfo.setContent(approveContent);
            }
        } else {
            approveContent = coreReceiveMessageInfo.getContent();
        }
        logger.info((Object)("---mobile---WorkflowBIZ---doResponse approveContent=" + approveContent));
        if (!this.formatMatch(approveContent)) {
            return this.createFailReturnObj("\u56de\u590d\u683c\u5f0f\u4e0d\u5bf9 ,\u8bf7\u6309\u63d0\u793a\u56de\u590d!");
        }
        String assignmentId = (String)this.assignmentMap.get(coreSendMessageInfo.getMsgID());
        try {
            if (this.WFService == null && !this.init(ctx)) {
                throw new WfException("---mobile---WorkflowBIZ---\u83b7\u53d6\u5de5\u4f5c\u6d41\u63a5\u53e3IEnactmentService\u5931\u8d25,dc=" + ctx.getAIS());
            }
            AssignmentInfo info = this.WFService.getAssignmentById(assignmentId);
            if (info.getState().getValue() == 4) return this.createFailReturnObj("\u4efb\u52a1\u5df2\u7ecf\u88ab\u53d6\u6d88\u6216\u62d2\u7edd\uff0c\u8bf7\u767b\u5f55EAS\u5ba2\u6237\u7aef\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f!");
            if (info.getState().getValue() == 8) {
                return this.createFailReturnObj("\u4efb\u52a1\u5df2\u7ecf\u88ab\u53d6\u6d88\u6216\u62d2\u7edd\uff0c\u8bf7\u767b\u5f55EAS\u5ba2\u6237\u7aef\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f!");
            }
            if (info.getState().getValue() == 16) return this.createFailReturnObj("\u4efb\u52a1\u5df2\u5904\u7406\u8fc7,\u65e0\u987b\u91cd\u590d\u5904\u7406\uff0c\u8bf7\u767b\u5f55EAS\u5ba2\u6237\u7aef\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f!");
            if (info.getState().getValue() == 32) {
                return this.createFailReturnObj("\u4efb\u52a1\u5df2\u5904\u7406\u8fc7,\u65e0\u987b\u91cd\u590d\u5904\u7406\uff0c\u8bf7\u767b\u5f55EAS\u5ba2\u6237\u7aef\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f!");
            }
        }
        catch (WfException e1) {
            logger.error((Object)("\u6839\u636e\u4efb\u52a1ID\u83b7\u53d6\u4efb\u52a1\u5bf9\u8c61\u5931\u8d25\uff1a" + (Object)((Object)e1)));
            return this.createFailReturnObj(ResourceBase.getString((String)MOBILERESOURCE, (String)"processFail", (Locale)ctx.getLocale()));
        }
        logger.info((Object)("---mobile---WorkflowBIZ---assignmentId=" + assignmentId));
        if (assignmentId == null) return this.createFailReturnObj(ResourceBase.getString((String)MOBILERESOURCE, (String)"canntFindAssignFail", (Locale)ctx.getLocale()));
        try {
            ApproveContent approve = this.parseApproveContent(approveContent, assignmentId);
            if (approve.handleOpinion == -1) {
                return this.createFailReturnObj("\u56de\u590d\u683c\u5f0f\u4e0d\u5bf9,\u8bf7\u6309\u63d0\u793a\u56de\u590d!");
            }
            boolean success = this.submitAssignment(ctx, assignmentId, approveContent, userInfo);
            if (!success) return this.createFailReturnObj(ResourceBase.getString((String)MOBILERESOURCE, (String)"processFail", (Locale)ctx.getLocale()));
            bizReturnObj = this.createSucceedReturnObj(ResourceBase.getString((String)MOBILERESOURCE, (String)"AuditProcessSuccess", (Locale)ctx.getLocale()));
            if (!WorkflowBIZ.ignoreSMSSuccessResponse(ctx)) return bizReturnObj;
            bizReturnObj.setMustReply(false);
            return bizReturnObj;
        }
        catch (Exception e) {
            logger.info((Object)("errro: " + e.getMessage()));
            return this.createFailReturnObj(ResourceBase.getString((String)MOBILERESOURCE, (String)"processFail", (Locale)ctx.getLocale()));
        }
    }

    public void wrapperApproveContent(ApproveContent approve) {
        if (approve != null) {
            if (StringUtils.isEmpty((String)approve.opinion) && approve.result.equals((Object)ApproveResult.PASS)) {
                approve.opinion = "\u540c\u610f";
            }
            if (StringUtils.isEmpty((String)approve.opinion) && approve.result.equals((Object)ApproveResult.NOT_PASS)) {
                approve.opinion = "\u4e0d\u540c\u610f";
            }
        }
    }

    private ApproveContent parseApproveContent(String title, String assignmentId) throws WfException {
        title = title.trim();
        ApproveContent approve = new ApproveContent();
        char c = title.charAt(0);
        switch (c) {
            case '1': 
            case 'Y': 
            case 'y': {
                approve.result = ApproveResult.PASS;
                break;
            }
            case '0': 
            case '2': 
            case 'N': 
            case 'n': {
                approve.result = ApproveResult.NOT_PASS;
                break;
            }
            default: {
                approve.result = ApproveResult.NOT_PASS;
            }
        }
        if (title.length() == 1) {
            return approve;
        }
        boolean pass = approve.result == ApproveResult.PASS;
        title = title.substring(1).trim();
        c = title.charAt(0);
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                approve.handleOpinion = c - 48;
                title = title.substring(1).trim();
                break;
            }
            default: {
                approve.handleOpinion = 0;
            }
        }
        if (title.length() >= 255) {
            title = title.substring(0, 255);
        }
        approve.opinion = title;
        String decisions = this.WFService.getMultiApproveDecision(assignmentId);
        approve.handleContent = "";
        if (decisions != null) {
            String[] items = StringUtils.split((String)decisions, (String)":");
            String[] itemInfo = this.getitemInfo(items, approve.handleOpinion);
            if (itemInfo != null && itemInfo.length > 0) {
                String[] item = itemInfo;
                if (item.length > 1) {
                    if (pass && item[2].equals("\u4e0d\u540c\u610f") || !pass && item[2].equals("\u540c\u610f")) {
                        approve.handleOpinion = -1;
                    } else {
                        approve.handleContent = item[1];
                    }
                }
            } else {
                approve.handleOpinion = -1;
            }
        }
        return approve;
    }

    private String[] getitemInfo(String[] items, int handleOpinion) {
        for (String item : items) {
            String[] iteminfo = StringUtils.split((String)item, (String)";");
            int tempHandle = Integer.parseInt(iteminfo[0]);
            if (tempHandle < 0 || tempHandle > 9 || tempHandle != handleOpinion) continue;
            return iteminfo;
        }
        return null;
    }

    public boolean submitAssignment(Context ctx, String assignmentId, String title, UserInfo userInfo) throws Exception {
        boolean success;
        block11: {
            logger.info((Object)("---mobile---WorkflowBIZ---\u4efb\u52a1ID:" + assignmentId + ", \n\u56de\u590d\u5185\u5bb9:" + title + ",\u7528\u6237ID\n" + userInfo.getId().toString()));
            success = false;
            try {
                if (this.WFService == null && !this.init(ctx)) {
                    logger.info((Object)("---mobile---WorkflowBIZ---\u83b7\u53d6\u5de5\u4f5c\u6d41\u63a5\u53e3IEnactmentService\u5931\u8d25,dc=" + ctx.getAIS()));
                    return false;
                }
                ApproveContent approve = this.parseApproveContent(title, assignmentId);
                this.wrapperApproveContent(approve);
                ApproveResult result = approve.result;
                String opinion = approve.opinion;
                int handlerOpinion = approve.handleOpinion;
                String handlerContent = approve.handleContent;
                AssignmentInfo info = this.WFService.getAssignmentById(assignmentId);
                if (info == null) {
                    logger.info((Object)"---mobile---WorkflowBIZ---\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u4efb\u52a1\u4fe1\u606f");
                    return false;
                }
                String[] idsArray = info.getBizObjectIdArray();
                BOSUuid billId = BOSUuid.read((String)idsArray[0]);
                logger.info((Object)("---mobile---WorkflowBIZ---billId=" + billId));
                if (billId == null) break block11;
                HashMap<IObjectPK, MultiApproveInfo> dataMap = new HashMap<IObjectPK, MultiApproveInfo>();
                MultiApproveInfo multiApproveInfo = new MultiApproveInfo();
                multiApproveInfo.setIsPass(result);
                logger.info((Object)("---mobile---WorkflowBIZ---result: " + result));
                multiApproveInfo.setOpinion(opinion);
                logger.info((Object)("---mobile---WorkflowBIZ---opinion: " + opinion));
                multiApproveInfo.setHandlerOpinion(handlerOpinion);
                multiApproveInfo.setHandlerContent(handlerContent);
                logger.info((Object)("---mobile---WorkflowBIZ---handlerOpinion: " + handlerOpinion));
                multiApproveInfo.setBillId(billId);
                logger.info((Object)("---mobile---WorkflowBIZ---billId: " + billId));
                multiApproveInfo.setAssignment(assignmentId);
                Map extendedAttributes = this.WFService.getExtendedAttributesFromAssignment(assignmentId);
                String isMailNotifyNext = (String)extendedAttributes.get("isSendMail");
                String isMobelNotifyNext = (String)extendedAttributes.get("isSendSMS");
                logger.info((Object)("---mobile---WorkflowBIZ---isMailNotifyNext=" + isMailNotifyNext));
                logger.info((Object)("---mobile---WorkflowBIZ---isMobelNotifyNext=" + isMobelNotifyNext));
                if ("true".equalsIgnoreCase(isMailNotifyNext)) {
                    multiApproveInfo.setIsMailNotifyNext(true);
                } else {
                    multiApproveInfo.setIsMailNotifyNext(false);
                }
                if ("true".equalsIgnoreCase(isMobelNotifyNext)) {
                    multiApproveInfo.setIsMobelNotifyNext(true);
                } else {
                    multiApproveInfo.setIsMobelNotifyNext(false);
                }
                multiApproveInfo.setCreator(userInfo);
                multiApproveInfo.setInputType(InputType.SMS);
                IObjectPK pk = this.iMultiApprove.addnew((CoreBaseInfo)multiApproveInfo);
                dataMap.put(pk, multiApproveInfo);
                this.WFService.acceptAssignment(assignmentId);
                SubmitAssignResult submitResult = this.WFService.submitAssignment(dataMap, userInfo.getId().toString(), info);
                if (submitResult.getStatus()) {
                    success = true;
                    break block11;
                }
                return false;
            }
            catch (WfException e) {
                logger.error((Object)("---mobile---WorkflowBIZ---" + e.getMessage()));
            }
            catch (BOSException e) {
                logger.error((Object)("---mobile---WorkflowBIZ---" + e.getMessage()));
            }
            catch (UuidException e) {
                logger.error((Object)("---mobile---WorkflowBIZ---" + e.getMessage()));
            }
        }
        return success;
    }

    @Override
    public boolean init(Context ctx) {
        boolean success = true;
        try {
            if (this.WFService == null) {
                this.WFService = (IEnactmentService)BOSObjectFactory.createBOSObject((Context)ctx, (String)EnactmentServiceProxy.class.getName());
            }
            if (this.iMultiApprove == null) {
                this.iMultiApprove = MultiApproveFactory.getLocalInstance((Context)ctx);
            }
            logger.info((Object)"---mobile---WorkflowBIZ---\u5de5\u4f5c\u6d41\u6a21\u5757\u542f\u52a8");
        }
        catch (BOSException e) {
            success = false;
            logger.info((Object)("---mobile---WorkflowBIZ---" + e.getMessage()));
        }
        return success;
    }

    @Override
    public void destroy() {
        this.iMultiApprove = null;
        this.WFService = null;
        logger.info((Object)"---mobile---WorkflowBIZ---\u5de5\u4f5c\u6d41\u6a21\u5757\u88ab\u9500\u6bc1");
    }

    public boolean formatMatch(String title) {
        boolean validate = false;
        if (title == null) {
            return validate;
        }
        if (title.trim().length() == 0) {
            return validate;
        }
        char c = title.trim().toLowerCase().charAt(0);
        if (c == 'y' || c == 'n' || c == '1' || c == '0' || c == '2') {
            validate = true;
        }
        return validate;
    }

    private BizReturnObj createFailReturnObj(String errorText) {
        BizReturnObj bizReturnObj = new BizReturnObj();
        bizReturnObj.setErrorText(errorText);
        bizReturnObj.setReturnText("");
        bizReturnObj.setSucceed(false);
        bizReturnObj.setMustReply(true);
        return bizReturnObj;
    }

    private BizReturnObj createSucceedReturnObj(String returnText) {
        BizReturnObj bizReturnObj = new BizReturnObj();
        bizReturnObj.setErrorText("");
        bizReturnObj.setReturnText(returnText);
        bizReturnObj.setSucceed(true);
        bizReturnObj.setMustReply(true);
        return bizReturnObj;
    }

    public static boolean disableSMSApprove(Context ctx) {
        boolean result = false;
        String paramStr = null;
        try {
            paramStr = ParamManager.getParamValue((Context)ctx, null, (String)"DisableSMSApprove");
        }
        catch (Exception e) {
            logger.error((Object)"disableSMSApprove error", (Throwable)e);
        }
        if (paramStr != null && paramStr.equalsIgnoreCase("true")) {
            result = true;
        }
        return result;
    }

    public static boolean ignoreSMSSuccessResponse(Context ctx) {
        boolean result = false;
        String paramStr = null;
        try {
            paramStr = ParamManager.getParamValue((Context)ctx, null, (String)"ignoreSMSSuccessResponse");
        }
        catch (Exception e) {
            logger.error((Object)"ignoreSMSSuccessResponse error", (Throwable)e);
        }
        if (paramStr != null && paramStr.equalsIgnoreCase("true")) {
            result = true;
        }
        return result;
    }

    public static class ApproveContent {
        public ApproveResult result;
        public int handleOpinion = 0;
        public String handleContent = "\u65e0";
        public String opinion;
    }
}

