/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.ISendMobileMessage;
import com.kingdee.eas.mobile.SendMobileMessageCollection;
import com.kingdee.eas.mobile.SendMobileMessageFactory;
import com.kingdee.eas.mobile.SendMobileMessageInfo;
import com.kingdee.eas.mobile.dao.DBHelper;
import com.kingdee.eas.mobile.dao.DefaultSendMoMsgDaoImp;
import com.kingdee.eas.mobile.dao.SendMoMsgUpdateValueObj;
import com.kingdee.eas.mobile.util.AppMsgUtil;
import com.kingdee.eas.mobile.util.CheckLicense;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;

public class DefaultSendMoMsgDao {
    private static final Logger logger = Logger.getLogger(DefaultSendMoMsgDao.class);

    private DefaultSendMoMsgDao() {
    }

    public static SendMobileMessageInfo getSendMoMsgInfoByMsgId(Context ctx, String msgID) {
        SendMobileMessageInfo sendMobileMessageInfo = null;
        try {
            ISendMobileMessage iSendMobileMessage = SendMobileMessageFactory.getLocalInstance(ctx);
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add("*");
            evi.getSelector().add("address.*");
            evi.getSelector().add("address.receiveBizUser.person.name");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("msgID", (Object)msgID));
            evi.setFilter(filter);
            SorterItemInfo sorterItemInfo = new SorterItemInfo("createTime");
            sorterItemInfo.setSortType(SortType.DESCEND);
            evi.getSorter().add(sorterItemInfo);
            SendMobileMessageCollection sendMobileMessageCol = iSendMobileMessage.getSendMobileMessageCollection(evi);
            if (sendMobileMessageCol != null && sendMobileMessageCol.size() > 0) {
                sendMobileMessageInfo = sendMobileMessageCol.get(0);
            }
        }
        catch (Exception err) {
            logger.error((Object)("There has some error while getSendMoMsgInfoByMsgId : " + err.getMessage()));
        }
        return sendMobileMessageInfo;
    }

    public static IObjectPK addNew(Context ctx, SendMobileMessageInfo sendMoMsgInfo) throws BOSException, EASBizException {
        try {
            if (CheckLicense.checkMobileLicence(ctx, "com.kingdee.eas.mobile.client.BizConfigUI") != 1) {
                logger.error((Object)"No Match License.");
                return null;
            }
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
        catch (LoginException e) {
            e.printStackTrace();
        }
        if (StringUtils.isEmpty((String)sendMoMsgInfo.getRootMsgID())) {
            sendMoMsgInfo.setRootMsgID(sendMoMsgInfo.getMsgID());
        }
        sendMoMsgInfo.setSplitNumber(AppMsgUtil.countSplitNumber(sendMoMsgInfo.getContent()));
        IObjectPK pk = null;
        ISendMobileMessage iSendMobileMessage = SendMobileMessageFactory.getLocalInstance(ctx);
        pk = iSendMobileMessage.addnew(sendMoMsgInfo);
        return pk;
    }

    public static boolean addNew(Context ctx, SendMobileMessageCollection sendMoMsgInfos) throws BOSException, EASBizException {
        IObjectPK pk = null;
        try {
            if (CheckLicense.checkMobileLicence(ctx, "com.kingdee.eas.mobile.client.BizConfigUI") != 1) {
                logger.error((Object)"No Match License.");
                return false;
            }
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
        catch (LoginException e) {
            e.printStackTrace();
        }
        boolean succeed = true;
        if (sendMoMsgInfos.size() > 0) {
            ISendMobileMessage iSendMobileMessage = SendMobileMessageFactory.getLocalInstance(ctx);
            for (int i = 0; i < sendMoMsgInfos.size(); ++i) {
                if (StringUtils.isEmpty((String)sendMoMsgInfos.get(i).getRootMsgID())) {
                    sendMoMsgInfos.get(i).setRootMsgID(sendMoMsgInfos.get(i).getMsgID());
                }
                sendMoMsgInfos.get(i).setSplitNumber(AppMsgUtil.countSplitNumber(sendMoMsgInfos.get(i).getContent()));
                logger.info((Object)("---mobile--addnewMobile=---" + sendMoMsgInfos.get(i)));
                pk = iSendMobileMessage.addnew(sendMoMsgInfos.get(i));
                if (pk != null) continue;
                succeed = false;
                break;
            }
        }
        return succeed;
    }

    public static boolean delete(Context ctx, String sendMoMsgId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)sendMoMsgId)) {
            throw new BOSException("ID can't be null.");
        }
        ObjectUuidPK pk = null;
        BOSUuid uuid = BOSUuid.read((String)sendMoMsgId);
        pk = new ObjectUuidPK(uuid);
        ISendMobileMessage iSendMobileMessage = SendMobileMessageFactory.getLocalInstance(ctx);
        SendMobileMessageInfo sendMoMsgInfo = iSendMobileMessage.getSendMobileMessageInfo((IObjectPK)pk);
        boolean succeed = false;
        if (sendMoMsgInfo == null) {
            throw new BOSException("The record of ID isn't exist.");
        }
        sendMoMsgInfo.setDeleted(true);
        iSendMobileMessage.update((IObjectPK)pk, sendMoMsgInfo);
        succeed = true;
        return succeed;
    }

    public static SendMobileMessageCollection getUnSendMobileMsgs(Context ctx) throws BOSException, EASBizException {
        String sendDaysCount;
        ISendMobileMessage iSendMobileMessage = SendMobileMessageFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add("*");
        viewInfo.getSelector().add("address.*");
        int days = 3;
        Configuration bosConfig = Configuration.getInstance();
        ConfigurationItem sln = bosConfig.getConfigItem("PortalInfo");
        if (sln != null && (sendDaysCount = sln.getProperty("sendDaysCount")) != null) {
            try {
                days = Integer.parseInt(sendDaysCount.trim());
            }
            catch (Exception e) {
                logger.error((Object)"sendDaysCount is not correct! please reset it.");
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, calendar.get(5) - days);
        Date filterDate = calendar.getTime();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sendSucceed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("sendFail", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("deleted", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("sentFailNumber", (Object)new Integer(5), CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("createTime", (Object)filterDate, CompareType.GREATER_EQUALS));
        viewInfo.setFilter(filter);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("sentFailNumber");
        sorterItemInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorterItemInfo);
        viewInfo.getSorter().add(new SorterItemInfo("priority"));
        viewInfo.getSorter().add(new SorterItemInfo("createTime"));
        viewInfo.setTopCount(100);
        SendMobileMessageCollection sendMoMsgCollection = iSendMobileMessage.getSendMobileMessageCollection(viewInfo);
        return sendMoMsgCollection;
    }

    public static void updateSendMoMsgInfo(Context ctx, Connection con, SendMoMsgUpdateValueObj updateValueObj) throws Exception {
    }

    public static void updateSendMoMsgInfo(Context ctx, String id, Connection con, boolean isSent, boolean isSendSucceed, boolean isSendFail) throws Exception {
        new DefaultSendMoMsgDaoImp().updateSendMoMsgInfo(ctx, id, con, isSent, isSendSucceed, isSendFail);
    }

    public static void updateSendMoMsgInfo(Context ctx, String id, Connection con, String msgId) throws Exception {
        if (StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)msgId)) {
            return;
        }
        String updateCommandSQL = null;
        Object[] params = null;
        updateCommandSQL = "update T_MO_SendMoMsg set FMsgId = ?  where FID = ?";
        params = new Object[]{msgId, id};
        if (con == null) {
            DbUtil.execute((Context)ctx, (String)updateCommandSQL, (Object[])params);
        } else {
            Statement statement = null;
            try {
                PreparedStatement ps = con.prepareStatement(updateCommandSQL);
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
                if (!ps.execute()) {
                    // empty if block
                }
            }
            catch (SQLException err) {
                throw new BOSException((Throwable)err);
            }
            finally {
                DBHelper.cleanup(statement, null);
            }
        }
    }

    public static void updateSendMoMsgInfo4New(Context ctx, String id, Connection con, String msgIdInGateway) throws Exception {
        if (StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)msgIdInGateway)) {
            return;
        }
        String updateCommandSQL = null;
        Object[] params = null;
        updateCommandSQL = "update T_MO_SendMoMsg set FMsgIdInGateway = ?  where FID = ?";
        params = new Object[]{msgIdInGateway, id};
        if (con == null) {
            DbUtil.execute((Context)ctx, (String)updateCommandSQL, (Object[])params);
        } else {
            Statement statement = null;
            try {
                PreparedStatement ps = con.prepareStatement(updateCommandSQL);
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
                if (!ps.execute()) {
                    // empty if block
                }
            }
            catch (SQLException err) {
                throw new BOSException((Throwable)err);
            }
            finally {
                DBHelper.cleanup(statement, null);
            }
        }
    }

    public static void updateSendMoMsgInfo(Context ctx, String id, Connection con, boolean isResponsed) throws Exception {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        String updateCommandSQL = null;
        Object[] params = null;
        updateCommandSQL = isResponsed ? "update T_MO_SendMoMsg set FResponsed = 1  where FID = ?" : "update T_MO_SendMoMsg set FResponsed = 0  where FID = ?";
        params = new Object[]{id};
        if (con == null) {
            DbUtil.execute((Context)ctx, (String)updateCommandSQL, (Object[])params);
        } else {
            Statement statement = null;
            try {
                PreparedStatement ps = con.prepareStatement(updateCommandSQL);
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
                if (!ps.execute()) {
                    // empty if block
                }
            }
            catch (SQLException err) {
                throw new BOSException((Throwable)err);
            }
            finally {
                DBHelper.cleanup(statement, null);
            }
        }
    }

    public static int getSentMessageCount(Context ctx, String userId, Timestamp beginTime, Timestamp endTime, String controlUnitID) throws BOSException {
        if (StringUtils.isEmpty((String)userId) || beginTime == null || endTime == null || endTime.before(beginTime)) {
            return 0;
        }
        String countNumberSQL = null;
        int countNumber = 0;
        Object[] params = null;
        if (StringUtils.isEmpty((String)controlUnitID)) {
            countNumberSQL = "select sum(a.FSplitNumber) as countNumber from T_MO_SendMoMsg a, T_MO_MoMsgAddress b where a.FSendsucceed=1 and a.FSenttime is not null  and a.FAddressId=b.FID and b.FSendBizUserId=? and a.FIsDeleted=0  and a.FSenttime>=? and a.FSenttime<=?";
            params = new Object[]{userId, beginTime, endTime};
        } else {
            countNumberSQL = "select sum(a.FSplitNumber) as countNumber from T_MO_SendMoMsg a,T_MO_MoMsgAddress b where  a.FSendsucceed=1 and  a.FSenttime is not null  and a.FAddressId=b.FID and b.FSendBizUserId=? and a.FIsDeleted=0 and a.FSenttime>=? and a.FSenttime<=? and a.FControlUnitID=? ";
            params = new Object[]{userId, beginTime, endTime, controlUnitID};
        }
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)countNumberSQL, (Object[])params);
        try {
            rowset.beforeFirst();
            while (rowset.next()) {
                countNumber = rowset.getInt("countNumber");
            }
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
        return countNumber;
    }

    public static int getSentMessageCountForMonth(Context ctx, String userId, Timestamp currentTime, String controlUnitID) throws BOSException {
        if (StringUtils.isEmpty((String)userId) || currentTime == null) {
            return 0;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentTime);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        String countNumberSQL = null;
        int countNumber = 0;
        Object[] params = null;
        if (StringUtils.isEmpty((String)controlUnitID)) {
            countNumberSQL = "select sum(a.FSplitNumber) as countNumber from T_MO_SendMoMsg a,T_MO_MoMsgAddress b where (a.FSendsucceed=1 or a.FSendFail=0)  and a.FAddressId=b.FID and b.FSendBizUserId=? and a.FIsDeleted=0 and YEAR(a.FSenttime)=? and MONTH(a.FSenttime)=? ";
            params = new Object[]{userId, new Integer(year), new Integer(month)};
        } else {
            countNumberSQL = "select sum(a.FSplitNumber) as countNumber from T_MO_SendMoMsg a,T_MO_MoMsgAddress b where (a.FSendsucceed=1 or a.FSendFail=0)  and a.FAddressId=b.FID and b.FSendBizUserId=? and a.FIsDeleted=0 and YEAR(a.FSenttime)=? and MONTH(a.FSenttime)=? and a.FControlUnitID=? ";
            params = new Object[]{userId, new Integer(year), new Integer(month), controlUnitID};
        }
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)countNumberSQL, (Object[])params);
        try {
            rowset.beforeFirst();
            while (rowset.next()) {
                countNumber = rowset.getInt("countNumber");
            }
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
        return countNumber;
    }

    public static int getSentMessageCount(Context ctx, String userId, Timestamp beginTime, Timestamp endTime) throws BOSException {
        if (StringUtils.isEmpty((String)userId) || beginTime == null || endTime == null || endTime.before(beginTime)) {
            return 0;
        }
        String countNumberSQL = null;
        int countNumber = 0;
        Object[] params = null;
        countNumberSQL = "select sum(a.FSplitNumber) as countNumber from T_MO_SendMoMsg a,T_MO_MoMsgAddress b where  a.FSendsucceed=1 and  a.FSenttime is not null  and a.FAddressId=b.FID and b.FSendBizUserId=? and a.FIsDeleted=0 and DAYS_BETWEEN(?,a.FSenttime)<=0 and DAYS_BETWEEN(a.FSenttime,?)<=0 ";
        params = new Object[]{userId, beginTime, endTime};
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)countNumberSQL, (Object[])params);
        try {
            rowset.beforeFirst();
            while (rowset.next()) {
                countNumber = rowset.getInt("countNumber");
            }
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
        return countNumber;
    }

    public static int getSentMessageCountForMonth(Context ctx, String userId, Timestamp currentTime) throws BOSException {
        if (StringUtils.isEmpty((String)userId) || currentTime == null) {
            return 0;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentTime);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        String countNumberSQL = null;
        int countNumber = 0;
        Object[] params = null;
        countNumberSQL = "select sum(a.FSplitNumber) as countNumber from T_MO_SendMoMsg a,T_MO_MoMsgAddress b where  a.FSendsucceed=1 and  a.FSenttime is not null  and a.FAddressId=b.FID and b.FSendBizUserId=? and a.FIsDeleted=0  and YEAR(a.FSenttime)=? and MONTH(a.FSenttime)=? ";
        params = new Object[]{userId, new Integer(year), new Integer(month)};
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)countNumberSQL, (Object[])params);
        try {
            rowset.beforeFirst();
            while (rowset.next()) {
                countNumber = rowset.getInt("countNumber");
            }
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
        return countNumber;
    }

    public void addNew(Message msg, Connection con) throws SQLException, BOSException {
    }
}

