/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.dao;

import com.kingdee.eas.mobile.UserInfo;
import com.kingdee.eas.mobile.dao.UserInfoDao;
import com.kingdee.eas.mobile.msg.UserCommandInfo;
import com.kingdee.eas.mobile.msg.util.SysProperty;
import com.kingdee.util.Uuid;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class UserInfoDaoImpl
implements UserInfoDao {
    private static final Logger logger = Logger.getLogger(UserInfoDaoImpl.class);
    private static UserInfo monitor = SysProperty.getMonitorUser();
    private static UserInfoDaoImpl instance = new UserInfoDaoImpl();
    private static final String Person_Link_User = "select a.FID,b.FID,b.FName_L1,b.FName_L2,b.FName_L3,b.FEMail,b.FCell,b.FRTX  from T_PM_USER a,T_BD_Person b where a.FPersonId = b.FID";
    private static final String GET_USER_BY_NUM_MOBILE = "Select a.FB_ID, a.FAffix FROM T_Mobile_ShortCut a LEFT OUTER JOIN  T_PM_USER b  ON a.FUserid = b.FID LEFT OUTER JOIN T_BD_Person c  on b.FPersonId = c.FID WHERE (a.FAis = ?) and (a.FShortCut = ?)  AND (c.FCell = ?)";
    private static final String GET_USER_BY_NUM_RTX = "Select a.FB_ID, a.FAffix FROM T_Mobile_ShortCut a LEFT OUTER JOIN  T_PM_USER b  ON a.FUserid = b.FID LEFT OUTER JOIN T_BD_Person c  on b.FPersonId = c.FID WHERE (a.FAis = ?) and (a.FShortCut = ?)  AND (c.FRTX = ?)";
    private static final String GET_USER_BY_NUM_MAIL = "Select a.FB_ID, a.FAffix FROM T_Mobile_ShortCut a LEFT OUTER JOIN  T_PM_USER b  ON a.FUserid = b.FID LEFT OUTER JOIN T_BD_Person c  on b.FPersonId = c.FID WHERE (a.FAis = ?) and (a.FShortCut = ?)  AND (c.FEMail = ?)";
    private static final String GET_COMMAND_BY_BID = "SELECT FCommand from T_Mobile_Command where FB_id= ? and FAIS = ?";

    private UserInfoDaoImpl() {
    }

    public static UserInfoDaoImpl getInstance() {
        return instance;
    }

    @Override
    public UserInfo getUserInfo(String userid, Connection con, boolean autoClose) {
        UserInfo info = null;
        info = userid.equals(monitor.getUserid()) ? monitor : this.getUserInfo("a.FID", userid, con, autoClose);
        return info;
    }

    @Override
    public UserInfo getUserInfoByMobile(String moblieNum, Connection con, boolean autoClose) {
        if (moblieNum == null) {
            moblieNum = "";
        }
        return this.getUserInfo("b.FCell", moblieNum.toLowerCase(), con, autoClose);
    }

    @Override
    public UserInfo getUserInfoByRtx(String rtx, Connection con, boolean autoClose) {
        if (rtx == null) {
            rtx = "";
        }
        return this.getUserInfo("b.FRTX", rtx.toLowerCase(), con, autoClose);
    }

    @Override
    public UserInfo getUserInfoByEmail(String email, Connection con, boolean autoClose) {
        if (email != null) {
            return this.getUserInfo("b.FEMail", email.toLowerCase(), con, autoClose);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserCommand(char c, String userid, String ais, Connection con) {
        String command = "";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            String sql = "select a.FCommand ,b.FAffix from (select * from T_Mobile_Command where FAIS='" + ais + "') a inner join (select * from " + "T_Mobile_ShortCut" + " where " + "FAIS" + "='" + ais + "' and " + "FUserid" + "='" + userid + "' and " + "FShortCut" + "='" + c + "') b on a." + "FB_id" + "=b." + "FB_ID";
            logger.debug((Object)("getUserCommand sql is: " + sql));
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                command = rs.getString(1);
                String affix = rs.getString(2);
                if (affix != null && affix.trim().length() > 0) {
                    command = command + " " + affix.trim();
                }
            }
            rs.close();
            stmt.close();
            logger.debug((Object)("command:" + command));
            UserInfoDaoImpl.closeAndRelease(rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            UserInfoDaoImpl.closeAndRelease(rs, stmt);
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserCommandInfo[] getUserCommands(String userid, String ais, Connection con) {
        Statement stmt = null;
        UserCommandInfo[] cmds = new UserCommandInfo[]{};
        ResultSet rs = null;
        try {
            ArrayList<UserCommandInfo> ret = new ArrayList<UserCommandInfo>();
            stmt = con.createStatement();
            String sql = "select a.FShortCut,a.FAffix,b.FFuncNo,b.FClassName from (select * from T_Mobile_ShortCut where FAis='" + ais + "' and " + "FUserid" + "='" + userid + "') a left join " + "T_Mobile_Biz" + " b on a." + "FB_ID" + "=b." + "FB_id";
            logger.debug((Object)("getUserCommands sql is: " + sql));
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                UserCommandInfo commandInfo = new UserCommandInfo();
                String command = rs.getString(1);
                if (command.length() > 0) {
                    commandInfo.setShortCut(command.charAt(0));
                }
                commandInfo.setAppend(rs.getString(2));
                commandInfo.setFunctionNum(rs.getInt(3));
                commandInfo.setClassName(rs.getString(4));
                ret.add(commandInfo);
            }
            rs.close();
            stmt.close();
            cmds = new UserCommandInfo[ret.size()];
            ret.toArray(cmds);
        }
        catch (SQLException e) {
            UserCommandInfo[] userCommandInfoArray;
            try {
                e.printStackTrace();
                userCommandInfoArray = new UserCommandInfo[]{};
            }
            catch (Throwable throwable) {
                UserInfoDaoImpl.closeAndRelease(rs, stmt);
                throw throwable;
            }
            UserInfoDaoImpl.closeAndRelease(rs, stmt);
            return userCommandInfoArray;
        }
        UserInfoDaoImpl.closeAndRelease(rs, stmt);
        return cmds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveUser(UserInfo userinfo, UserCommandInfo[] shotCuts, Connection con, String ais) {
        boolean success = false;
        String userid = userinfo.getUserid();
        String personid = userinfo.getPersonid();
        if (userid == null) {
            return success;
        }
        if (personid == null) {
            return success;
        }
        Statement pstmt = null;
        String sql = "";
        try {
            UserInfo info2 = this.getUserInfo("a.FID", userid, con, false);
            if (info2.getPersonid() != null && info2.getPersonid().equals(personid)) {
                sql = "update T_BD_Person set FEMail = ?, FRTX = ?,FCell = ? where FID = ? ";
                pstmt = con.prepareStatement(sql);
                pstmt.setString(1, userinfo.getEmail());
                pstmt.setString(2, userinfo.getRtx());
                pstmt.setString(3, userinfo.getMobile());
                pstmt.setString(4, personid);
                pstmt.executeUpdate();
                pstmt.clearParameters();
                pstmt.close();
                sql = "delete from T_Mobile_USER where FUserID = ?";
                pstmt = con.prepareStatement(sql);
                pstmt.setString(1, userid);
                pstmt.executeUpdate();
                pstmt.close();
                String uuid = Uuid.create().toString();
                sql = " insert  T_Mobile_USER (FID,FUserID,FCommon,FImportant,FLocale ) values (?,?,?,?,?)";
                pstmt = con.prepareStatement(sql);
                pstmt.setString(1, uuid);
                pstmt.setString(2, userid);
                pstmt.setInt(3, userinfo.getCommonMode());
                pstmt.setInt(4, userinfo.getImportantMode());
                pstmt.setInt(5, userinfo.getLocale());
                pstmt.executeUpdate();
                pstmt.clearParameters();
                pstmt.close();
                sql = " delete from T_Mobile_ShortCut where FUserid = '" + userid + "' and " + "FAis" + " = '" + ais + "'";
                pstmt = con.prepareStatement(sql);
                pstmt.executeUpdate();
                pstmt.close();
                for (int i = 0; shotCuts != null && i < shotCuts.length; ++i) {
                    UserCommandInfo shotCut = shotCuts[i];
                    boolean ok = this.saveUserCommand(userid, shotCut.getShortCut(), shotCut.getClassName(), shotCut.getFunctionNum(), ais, shotCut.getAppend(), con);
                    if (ok) continue;
                    con.rollback();
                    break;
                }
                success = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)ex);
            logger.error((Object)("sql:" + sql));
            try {
                con.rollback();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveUserCommand(String userid, char c, String className, int bizKey, String ais, String affix, Connection con) throws Exception {
        boolean success = false;
        if (!UserCommandInfo.validateShotCut(c)) {
            return false;
        }
        if (affix == null) {
            affix = "";
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "select FB_id from T_Mobile_Biz where FFuncNo= ? and FClassName = ?";
            logger.debug((Object)("saveUserCommand sql is: " + sql));
            Object[] params = new Object[]{bizKey, className};
            rs = this.executeQuery(con, stmt, sql, params);
            String bizId = null;
            if (rs.next()) {
                bizId = rs.getString(1);
            }
            rs.close();
            if (bizId != null) {
                String uuid = Uuid.create().toString();
                sql = "insert into T_Mobile_ShortCut(FID,FAis,FB_ID,FShortCut,FUserid,FAffix) values(?,?,?,?,?,?)";
                logger.debug((Object)("saveUserCommand sql is: " + sql));
                params = new Object[]{uuid, ais, bizId, Character.valueOf(c), userid, affix};
                this.executeSql(con, stmt, sql, params);
                success = true;
            }
            UserInfoDaoImpl.closeAndRelease(rs, stmt);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            con.rollback();
        }
        finally {
            UserInfoDaoImpl.closeAndRelease(rs, stmt);
        }
        return success;
    }

    private static final UserInfo loadUserInfo(UserInfo info, ResultSet rs) throws SQLException {
        info.setUserid(rs.getString(1));
        info.setPersonid(rs.getString(2));
        info.setNameL1(rs.getString(3));
        info.setNameL2(rs.getString(4));
        info.setNameL3(rs.getString(5));
        info.setEmail(rs.getString(6));
        info.setMobile(rs.getString(7));
        info.setRtx(rs.getString(8));
        return info;
    }

    private UserInfo getUserInfo(String key, String value, Connection con) {
        return this.getUserInfo(key, value, con, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserInfo getUserInfo(String key, String value, Connection con, boolean close) {
        ResultSet rs;
        PreparedStatement pstmt;
        UserInfo info;
        block6: {
            info = new UserInfo();
            pstmt = null;
            rs = null;
            String sql = null;
            try {
                sql = "select a.FID,b.FID,b.FName_L1,b.FName_L2,b.FName_L3,b.FEMail,b.FCell,b.FRTX  from T_PM_USER a,T_BD_Person b where a.FPersonId = b.FID and " + key + " = ?";
                pstmt = con.prepareStatement(sql);
                pstmt.setString(1, value);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    info = UserInfoDaoImpl.loadUserInfo(info, rs);
                }
                rs.close();
                pstmt.clearParameters();
                pstmt.close();
                if (info.getUserid() == null) break block6;
                sql = "select FCommon,FImportant,FLocale from T_Mobile_USER where FUserID = ? ";
                pstmt = con.prepareStatement(sql);
                pstmt.setString(1, info.getUserid());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    info.setCommonMode(rs.getInt(1));
                    info.setImportantMode(rs.getInt(2));
                    info.setLocale(rs.getInt(3));
                }
                rs.close();
                pstmt.close();
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                    logger.error((Object)ex.getMessage());
                    logger.error((Object)(" \n sql:" + sql.replaceAll("\\?", "'" + value + "'")));
                }
                catch (Throwable throwable) {
                    UserInfoDaoImpl.closeAndRelease(rs, pstmt);
                    throw throwable;
                }
                UserInfoDaoImpl.closeAndRelease(rs, pstmt);
            }
        }
        UserInfoDaoImpl.closeAndRelease(rs, pstmt);
        return info;
    }

    public UserInfo getUserInfoNoCloseCon(String userid, Connection con) {
        return this.getUserInfo("a.FID", userid, con, true);
    }

    public static void main(String[] args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserCommand(String addressNumber, char num, String ais, int mode, Connection conn) {
        ResultSet rs;
        PreparedStatement pstmt;
        String affix;
        String command;
        block11: {
            command = "";
            affix = "";
            pstmt = null;
            String sql = "";
            rs = null;
            switch (mode) {
                case 0: {
                    sql = GET_USER_BY_NUM_MOBILE;
                    break;
                }
                case 1: {
                    sql = GET_USER_BY_NUM_RTX;
                    break;
                }
                case 2: {
                    sql = GET_USER_BY_NUM_MAIL;
                }
            }
            try {
                String bid = "";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, ais);
                pstmt.setString(2, String.valueOf(num));
                pstmt.setString(3, addressNumber);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    bid = rs.getString(1);
                    affix = rs.getString(2);
                }
                rs.close();
                pstmt.clearParameters();
                if (bid == null || bid.trim().equals("")) break block11;
                sql = GET_COMMAND_BY_BID;
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, bid);
                pstmt.setString(2, ais);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    command = rs.getString(1);
                }
                rs.close();
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)(ex.getMessage() + sql + "\n\u53c2\u6570 ais=" + ais + "\n phrase=" + num + "\n number=" + addressNumber));
                }
                catch (Throwable throwable) {
                    UserInfoDaoImpl.closeAndRelease(rs, pstmt);
                    throw throwable;
                }
                UserInfoDaoImpl.closeAndRelease(rs, pstmt);
            }
        }
        UserInfoDaoImpl.closeAndRelease(rs, pstmt);
        return command + " " + affix;
    }

    private static final void closeAndRelease(Statement stmt) {
        try {
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt = null;
    }

    private static final void closeAndRelease(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        rs = null;
    }

    private static final void closeAndRelease(ResultSet rs, Statement stmt) {
        UserInfoDaoImpl.closeAndRelease(rs);
        UserInfoDaoImpl.closeAndRelease(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSql(Connection con, PreparedStatement stmt, String sql, Object[] params) throws SQLException {
        try {
            stmt = con.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                stmt.setObject(i + 1, params[i]);
            }
            stmt.execute(sql);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executeQuery(Connection con, PreparedStatement stmt, String sql, Object[] params) throws SQLException {
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                stmt.setObject(i + 1, params[i]);
            }
            rs = stmt.executeQuery(sql);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return rs;
    }
}

