/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.framework;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.message.client.ConnectMonitor;
import com.kingdee.bos.message.client.KDMsgListener;
import com.kingdee.bos.message.common.KDMessage;
import com.kingdee.bos.message.common.KDMessageAddress;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.bos.message.common.KDMessageType;
import com.kingdee.bos.message.common.KDMimeType;
import com.kingdee.bos.message.common.KDMsgCreator;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.EmailAddressInfo;
import com.kingdee.eas.mobile.EmailSendMessageInfo;
import com.kingdee.eas.mobile.MimeTypeEnum;
import com.kingdee.eas.mobile.MobileConfigInfo;
import com.kingdee.eas.mobile.SendMobileMessageInfo;
import com.kingdee.eas.mobile.dao.DefaultSendMoMsgDao;
import com.kingdee.eas.mobile.framework.IAttachmentBrige;
import com.kingdee.eas.mobile.framework.IMobileGatewayProvider;
import com.kingdee.eas.mobile.framework.MobileMsgInfo;
import com.kingdee.eas.mobile.framework.MsgServiceAssistant;
import com.kingdee.eas.mobile.util.AppMsgUtil;
import com.kingdee.eas.mobile.util.MailUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class AbastractMobileGatewayProvider
implements IMobileGatewayProvider {
    private static final Logger logger = Logger.getLogger(AbastractMobileGatewayProvider.class);
    private IAttachmentBrige attachmentBrige = null;
    private boolean attachBrigeDoInited = false;

    protected abstract boolean _testConnection(MobileConfigInfo var1) throws EASBizException, BOSException;

    protected abstract String _displayBalance(MobileConfigInfo var1) throws EASBizException, BOSException;

    protected abstract boolean _sendMessage(MobileMsgInfo var1, MobileConfigInfo var2, Context var3) throws BOSException, EASBizException;

    protected abstract MobileMsgInfo[] _receiveMessage(MobileConfigInfo var1, Context var2) throws BOSException;

    @Override
    public boolean testConnection(MobileConfigInfo mobileConfigInfo) throws EASBizException, BOSException {
        return this._testConnection(mobileConfigInfo);
    }

    @Override
    public String displayBalance(MobileConfigInfo mobileConfigInfo) throws EASBizException, BOSException {
        return this._displayBalance(mobileConfigInfo);
    }

    @Override
    public boolean sendMessage(SendMobileMessageInfo sendMoMsgInfo, MobileConfigInfo mobileConfigInfo, Context ctx) throws EASBizException, BOSException {
        String tempMsgIdInGateway = this.getMsgIdInGateway(sendMoMsgInfo, ctx);
        this.updateMsgIdInGateway(ctx, sendMoMsgInfo.getId().toString(), null, tempMsgIdInGateway);
        MobileMsgInfo mobileMsgInfo = new MobileMsgInfo(sendMoMsgInfo.getAddress().getReceiveMobileNumber(), sendMoMsgInfo.getContent(), tempMsgIdInGateway, sendMoMsgInfo.getAddress().getSendMobileNumber(), sendMoMsgInfo.isRevertible());
        return this._sendMessage(mobileMsgInfo, mobileConfigInfo, ctx);
    }

    protected void updateMsgIdInGateway(Context ctx, String id, Connection con, String msgIdInGateway) {
    }

    @Override
    public boolean sendMail(EmailSendMessageInfo emailSendMessageInfo, Context ctx) throws EASBizException, BOSException {
        EmailAddressInfo address = emailSendMessageInfo.getAddress();
        if (address == null) {
            logger.error((Object)"sendMail error: address is null");
            return false;
        }
        String content = "";
        content = emailSendMessageInfo.getContent() != null && emailSendMessageInfo.getContent().length() > 0 ? emailSendMessageInfo.getContent() : emailSendMessageInfo.getLongContent();
        this.initAttachmentBrige();
        KDMessageAttachment[] attachment = null;
        if (this.attachmentBrige != null) {
            attachment = this.attachmentBrige.KDMessageAttachments(ctx, emailSendMessageInfo.getAssignID());
        }
        return MailUtil.sendMail(ctx, emailSendMessageInfo.getTitle(), content, emailSendMessageInfo.getMimeType(), address.getTo(), address.getBcc(), address.getCc(), attachment);
    }

    @Override
    public void receiveMessage(MobileConfigInfo mobileConfigInfo, Context ctx) throws BOSException {
        MobileMsgInfo[] mobileMsgInfos = this._receiveMessage(mobileConfigInfo, ctx);
        if (mobileMsgInfos != null) {
            logger.info((Object)("AbastractMobileGatewayProvider-receiveMessage-mobileMsgInfos.length:" + mobileMsgInfos.length));
            for (int i = 0; i < mobileMsgInfos.length; ++i) {
                MobileMsgInfo mobileMsgInfo = mobileMsgInfos[i];
                String msgId = mobileMsgInfo.getMsgIdInGateway();
                KDMessage kdMsg = this.populateReceiveKDMessage(mobileMsgInfo.getSenderPhoneNo(), mobileMsgInfo.getContent(), msgId, ctx);
                this.handleReceiveMessage(kdMsg, ctx);
            }
        } else {
            logger.info((Object)"AbastractMobileGatewayProvider-receiveMessage is null");
        }
    }

    protected KDMessage populateReceiveKDMessage(String fromPhoneNo, String content, String msgId, Context ctx) {
        logger.info((Object)("AbastractMobileGatewayProvider-populateKDMessage [relative msg id|fromPhoneNo]:" + msgId + "|" + fromPhoneNo));
        KDMsgCreator kdMsgCreator = KDMsgCreator.create();
        KDMessage kdMsg = kdMsgCreator.createMsgForSMS(fromPhoneNo, content);
        kdMsg.setRelativeId(msgId);
        KDMessageAddress senderAddress = new KDMessageAddress("mp:sms", fromPhoneNo);
        kdMsg.setSender(senderAddress);
        KDMessageAddress receiverAddress = new KDMessageAddress(ctx.getAIS(), ctx.getAIS());
        kdMsg.setReceivers(new KDMessageAddress[]{receiverAddress});
        kdMsg.setType(KDMessageType.RESPONSE);
        kdMsg.setMimeType(KDMimeType.TEXT);
        return kdMsg;
    }

    protected void handleReceiveMessage(KDMessage kdMsg, Context ctx) {
        SendMobileMessageInfo theSendMoMsgInfo = null;
        if (!StringUtils.isEmpty((String)kdMsg.getRelativeId())) {
            theSendMoMsgInfo = DefaultSendMoMsgDao.getSendMoMsgInfoByMsgId(ctx, kdMsg.getRelativeId());
            if (theSendMoMsgInfo != null && theSendMoMsgInfo.isRevertible() && theSendMoMsgInfo.isSendHandcraft() && "for.hander".equals(theSendMoMsgInfo.getTitle())) {
                logger.info((Object)"AbastractMobileGatewayProvider-handleReceiveMessage MSG begin===");
                MsgServiceAssistant.handleForSendHandcraftMsg(ctx, kdMsg, theSendMoMsgInfo);
                logger.info((Object)"AbastractMobileGatewayProvider-handleReceiveMessage MSG end===");
                return;
            }
            if (theSendMoMsgInfo != null && !theSendMoMsgInfo.isRevertible()) {
                kdMsg.setRelativeId(null);
                kdMsg.setBizName("default");
                theSendMoMsgInfo = null;
            }
            logger.info((Object)("AbastractMobileGatewayProvider-handleReceiveMessage MSG cannot find the send msg(FMsgId):" + kdMsg.getRelativeId()));
        }
        String userId = null;
        try {
            userId = AppMsgUtil.getUserIdByAddress(ctx, kdMsg.getSender());
        }
        catch (BOSException e) {
            logger.error((Object)("-----mobile---onMessage---" + kdMsg.getTitle() + " none sendUser!--\n"));
            return;
        }
        if (userId == null) {
            logger.info((Object)("-----mobile---onMessage---title = " + kdMsg.getTitle() + "\n content = " + kdMsg.getContent() + "--end--\n"));
            this.actionForUnPass(kdMsg, ctx);
            return;
        }
        MsgServiceAssistant.handleForSendOrReplyMsg(ctx, kdMsg, userId, theSendMoMsgInfo);
    }

    protected void actionForUnPass(KDMessage msg, Context context) {
        KDMessage response = new KDMessage();
        String addressDetail = msg.getSender().getDeviceName();
        String addressId = msg.getSender().getDetail();
        StringBuffer title = new StringBuffer();
        logger.info((Object)("-----mobile---actionForUnPass---addressDetail = " + addressDetail + "\n addressId = " + addressId + "--end--\n"));
        if ("mp:sms".equals(addressDetail)) {
            title.append(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"mobileNumber", (Locale)context.getLocale()));
            title.append(addressId);
            title.append(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"hasnotlogin", (Locale)context.getLocale()));
        } else if ("mp:mail".equals(addressDetail)) {
            title.append(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"emailAddress", (Locale)context.getLocale()));
            title.append(addressId);
            title.append(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"hasnotlogin", (Locale)context.getLocale()));
        } else if ("mp:im".equals(addressDetail)) {
            title.append(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"rtxNumber", (Locale)context.getLocale()));
            title.append(addressId);
            title.append(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"hasnotlogin", (Locale)context.getLocale()));
        } else {
            title.append(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"messengerTypeError", (Locale)context.getLocale()));
        }
        logger.info((Object)("-----mobile---actionForUnPass---title = " + title));
        response.setTitle(title.toString());
        response.setContent(title.toString());
        KDMessage[] msgs = AbastractMobileGatewayProvider.afterWork(new KDMessage[]{response}, msg);
        this.sendMessage(msgs[0]);
    }

    protected static KDMessage[] afterWork(KDMessage[] responses, KDMessage msg) {
        for (int i = 0; responses != null && i < responses.length; ++i) {
            KDMessage response = responses[i];
            KDMessageAddress receiver = msg.getSender();
            response.setReceivers(new KDMessageAddress[]{receiver});
            response.setRelativeId(msg.getId());
        }
        return responses;
    }

    protected String getMsgIdInGateway(SendMobileMessageInfo sendMoMsgInfo, Context ctx) {
        if (sendMoMsgInfo != null) {
            logger.debug((Object)("MobileGatewayProvider-getMsgIdInGateway return FMsgID:" + sendMoMsgInfo.getMsgID()));
            return sendMoMsgInfo.getMsgID();
        }
        logger.debug((Object)"MobileGatewayProvider-getMsgIdInGateway return empty string.");
        return "";
    }

    @Override
    public boolean sendMessage(String content, String receiver, MobileConfigInfo mobileConfigInfo, Context ctx) throws BOSException, EASBizException {
        String sendIndexStr = this.getMsgIdInGateway(null, ctx);
        MobileMsgInfo mobileMsgInfo = new MobileMsgInfo(receiver, content, sendIndexStr, null);
        return this._sendMessage(mobileMsgInfo, mobileConfigInfo, ctx);
    }

    @Override
    public boolean sendMail(Context ctx, String title, String content, MimeTypeEnum contentMimeType, String receiver, String secretReceiver, String copyReceiver, KDMessageAttachment[] attachment) throws BOSException, EASBizException {
        return MailUtil.sendMail(ctx, title, content, contentMimeType, receiver, secretReceiver, copyReceiver, attachment);
    }

    @Override
    public void addConnectMonitor(ConnectMonitor arg0) {
        logger.info((Object)"MobileGatewayProvider--addConnectMonitor did nothing.");
    }

    @Override
    public void addMsgListener(KDMsgListener arg0) {
        logger.info((Object)"MobileGatewayProvider--addMsgListener did nothing.");
    }

    @Override
    public boolean connect(String arg0, int arg1, String arg2, String arg3) {
        logger.info((Object)"MobileGatewayProvider--connect did nothing.");
        return true;
    }

    @Override
    public void disConnect() {
        logger.info((Object)"MobileGatewayProvider--disConnect did nothing.");
    }

    @Override
    public boolean isConnected() {
        logger.info((Object)"MobileGatewayProvider--isConnected did nothing.");
        return true;
    }

    @Override
    public boolean sendMessage(KDMessage arg0) {
        logger.info((Object)"MobileGatewayProvider--sendMessage did nothing.");
        return true;
    }

    public void initAttachmentBrige() {
        try {
            if (this.attachmentBrige == null && !this.attachBrigeDoInited) {
                logger.info((Object)"AbastractMobileGatewayProvider init attachmentBrige");
                this.attachBrigeDoInited = true;
                Object obj = Class.forName("com.kingdee.bos.workflow.handler.EmailApproveAttachmentBrige").newInstance();
                this.attachmentBrige = (IAttachmentBrige)obj;
            }
        }
        catch (Throwable e) {
            logger.error((Object)"AbastractMobileGatewayProvider init attachmentBrige ERROR", e);
        }
    }

    static {
        System.setProperty("sun.net.client.defaultConnectTimeout", "20000");
        System.setProperty("sun.net.client.defaultReadTimeout", "20000");
    }
}

