/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.framework;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.mobile.CoreSendMessageCollection;
import com.kingdee.eas.mobile.IMobileConfig;
import com.kingdee.eas.mobile.MobileConfigCollection;
import com.kingdee.eas.mobile.MobileConfigFactory;
import com.kingdee.eas.mobile.MobileConfigInfo;
import com.kingdee.eas.mobile.dao.DefaultMsgDAO;
import com.kingdee.eas.mobile.framework.BizServer;
import com.kingdee.eas.mobile.framework.ISendMessageService;
import com.kingdee.eas.mobile.framework.MsgServiceAssistant;
import com.kingdee.eas.mobile.framework.SendMsgThreadListener;
import com.kingdee.eas.mobile.framework.ServerCenter;
import com.kingdee.util.Uuid;
import org.apache.log4j.Logger;

public class SendReceiveMsgWithDbThread
implements ISendMessageService {
    private static final Logger logger = Logger.getLogger(SendReceiveMsgWithDbThread.class);
    private static final int MAX_INTERVAL = 30000;
    private static final int INTERVAL_START = 5000;
    private static int sleepTime = 5000;
    private Thread thread = null;
    private boolean stoped = false;
    private Thread listenerThread = null;
    private Context ctx;
    private static final int MIN_INTERVAL_TIME = 1;
    private static final int DEFAULT_INTERVAL_TIME = 5;
    private static final int MAX_INTERVAL_TIME = 60;

    @Override
    public boolean init(Context context) {
        this.ctx = context;
        this.start();
        return true;
    }

    @Override
    public void destroy() {
        this.stop();
    }

    private void start() {
        logger.info((Object)"----mobile----\u542f\u52a8\u670d\u52a1\uff1a\u4ece\u6570\u636e\u5e93\u4e2d\u53d6\u5f97\u6570\u636e");
        this.stoped = false;
        this.thread = new Thread((Runnable)this, "SendReceiveMsgWithDbThread");
        this.thread.start();
        this.sleepTime(5000L);
        this.listenerThread = new SendMsgThreadListener(this.ctx, this.thread);
        this.listenerThread.start();
    }

    private void stop() {
        this.stoped = true;
        if (this.thread != null) {
            this.thread.interrupt();
        }
        if (this.listenerThread != null) {
            this.listenerThread.interrupt();
        }
        this.listenerThread = null;
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ServerCenter serverCenter = ServerCenter.getInstance(this.ctx);
        logger.info((Object)("----mobile----Mobile Thread:" + Thread.currentThread().getName() + "----Start"));
        while (!this.stoped) {
            logger.info((Object)"----mobile----Mobile Thread send start.");
            int channels = 1;
            try {
                IMobileConfig iMobileConfig = MobileConfigFactory.getLocalInstance(this.ctx);
                MobileConfigCollection mobileConfigs = iMobileConfig.getMobileConfigCollection();
                if (mobileConfigs.size() > 0) {
                    MobileConfigInfo mobileConfigInfo = mobileConfigs.get(0);
                    channels = mobileConfigInfo.getChannels();
                }
            }
            catch (Exception err) {
                logger.error((Object)"----mobile----getMobile File error: ", (Throwable)err);
            }
            logger.info((Object)("----mobile----Mobile Thread channels =" + channels));
            boolean requestMutex = false;
            MutexParameter mutexParam = null;
            IMutexServiceControl iMutex = null;
            try {
                mutexParam = this.getMutexParam();
                iMutex = MutexServiceControlFactory.getLocalInstance((Context)this.ctx);
                requestMutex = iMutex.requestMutex2(mutexParam);
                if (requestMutex) {
                    this.sendMsgByGatherPoll(channels);
                    logger.info((Object)"----mobile----Mobile Thread send end.");
                }
            }
            catch (Throwable t) {
                logger.error((Object)"----mobile----Mobile Thread send error:", t);
            }
            finally {
                if (requestMutex) {
                    iMutex.releaseMutex(mutexParam.getRequestId());
                }
            }
            logger.info((Object)"----mobile----Mobile Thread receive start.");
            try {
                if (channels == 4 || channels == 5 || channels == 6 || channels == 7) {
                    logger.info((Object)("----mobile----Mobile Thread receive start channels =" + channels));
                    serverCenter.receiveMessage();
                    logger.info((Object)"----mobile----Mobile Thread serverCenter.receiveMessage() end.");
                }
                logger.info((Object)"----mobile----Mobile Thread receive end.");
            }
            catch (Throwable t) {
                logger.error((Object)"----mobile----Mobile Thread receive error:", t);
            }
        }
        logger.info((Object)("----mobile----Mobile Thread:" + Thread.currentThread().getName() + "----End"));
    }

    private void sendMsgByGatherPoll(int channels) {
        CoreSendMessageCollection unSendMsgs = null;
        try {
            unSendMsgs = DefaultMsgDAO.getUnSendMsgsByChannel(this.ctx, channels);
            if (channels == 4 || channels == 5 || channels == 6 || channels == 7) {
                this.testConnected();
            }
        }
        catch (Exception err) {
            logger.error((Object)"----mobile----getUnSendMsgs error: ", (Throwable)err);
        }
        long time = 0L;
        if (unSendMsgs != null && unSendMsgs.size() > 0) {
            logger.info((Object)("----mobile----\u53d6\u5f97\u6d88\u606f\u6570\u76ee: " + unSendMsgs.size()));
            MsgServiceAssistant.sendMessages(this.ctx, unSendMsgs);
            time = SendReceiveMsgWithDbThread.resume();
        } else {
            time = SendReceiveMsgWithDbThread.fblq();
        }
        logger.info((Object)("----mobile----SendReceiveMsgWithDbThread sleep\u5c06\u4f11\u606f" + time + "\u6beb\u79d2"));
        this.sleepTime(time);
    }

    private void testConnected() {
        BizServer bizServer = BizServer.getInstance(this.ctx);
        while (true) {
            try {
                bizServer.open();
                return;
            }
            catch (Throwable err) {
                logger.error((Object)"----mobile----Send messages have some communication error: ", err);
                int interval = this.getIntervalTime();
                logger.error((Object)("----mobile----SendReceiveMsgWithDbThread connect will sleep" + interval));
                this.sleepTime(interval * 60000);
                continue;
            }
            break;
        }
    }

    private void sleepTime(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e1) {
            logger.info((Object)(Thread.currentThread().getName() + "----mobile---- Time InterruptedException"), (Throwable)e1);
        }
    }

    private static int fblq() {
        if (sleepTime > 30000) {
            return SendReceiveMsgWithDbThread.resume();
        }
        return sleepTime += 3000;
    }

    private static int resume() {
        sleepTime = 5000;
        return sleepTime;
    }

    private int getIntervalTime() {
        try {
            String value = ParamManager.getParamValue((Context)this.ctx, null, (String)"ConnectInterval");
            int interval = new Integer(value);
            if (interval >= 1 && interval <= 60) {
                return interval;
            }
            return 5;
        }
        catch (Exception e) {
            logger.error((Object)"----mobile----Read parameter ConnectInterval error: ", (Throwable)e);
            return 5;
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < 10; ++i) {
        }
    }

    private MutexParameter getMutexParam() {
        MutexParameter param = new MutexParameter();
        param.setMutexName("mobileMutexLock");
        param.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        param.setRequestId(Uuid.create());
        param.setActionName("mobileMutexLock");
        return param;
    }
}

