/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.msg.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.CellphoneNumberTypeEnum;
import com.kingdee.eas.mobile.EmailAddressInfo;
import com.kingdee.eas.mobile.EmailSendMessageInfo;
import com.kingdee.eas.mobile.MimeTypeEnum;
import com.kingdee.eas.mobile.MobileException;
import com.kingdee.eas.mobile.MobileMessageAddressInfo;
import com.kingdee.eas.mobile.SendMessageParamInfo;
import com.kingdee.eas.mobile.SendMobileMessageInfo;
import com.kingdee.eas.mobile.dao.DefaultEmailMessageDAO;
import com.kingdee.eas.mobile.dao.DefaultSendMoMsgDao;
import com.kingdee.eas.mobile.framework.ServerCenter;
import com.kingdee.eas.mobile.framework.ServerCenterFactory;
import com.kingdee.eas.mobile.msg.MobileConnectException;
import com.kingdee.eas.mobile.util.AppMsgUtil;
import com.kingdee.eas.mobile.util.MobileUtil;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MsgUtil {
    private static final Logger logger = Logger.getLogger((String)MsgUtil.class.getName());
    public static final int EN_US = 0;
    public static final int CN_ZH = 1;
    public static final int CN_TW = 2;

    public static int msgGroupSend(Context ctx, String title, int priority, boolean revertible, String content, List userList, int msgType, KDMessageAttachment[] attachment) throws EASBizException, BOSException {
        if (msgType != 2 && msgType != 1) {
            throw new MobileException(MobileException.MSGTYPE_ERROR);
        }
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = null;
        BOSUuid uuid = null;
        UserInfo receiveUser = null;
        PersonInfo receivePerson = null;
        String address = null;
        int userNum = userList.size();
        int sentNum = 0;
        boolean sendSucceed = false;
        block6: for (int i = 0; i < userNum; ++i) {
            try {
                if (userList.get(i) == null || StringUtils.isEmpty((String)userList.get(i).toString()) || (receiveUser = iUser.getUserInfo((IObjectPK)(pk = new ObjectUuidPK(uuid = BOSUuid.read((String)userList.get(i).toString().trim()))))).getPerson() == null || (receivePerson = AppMsgUtil.getPersonByUser(ctx, receiveUser)) == null) continue;
                switch (msgType) {
                    case 2: {
                        address = receivePerson.getEmail();
                        if (StringUtils.isEmpty((String)address)) break;
                        sendSucceed = MsgUtil.sendMail(ctx, title, priority, revertible, content, address, attachment, null);
                    }
                    case 1: {
                        address = receivePerson.getCell();
                        if (StringUtils.isEmpty((String)address)) break;
                        sendSucceed = MsgUtil.newMsgMobile(ctx, revertible, title, content, priority, receiveUser, address);
                    }
                    default: {
                        if (!sendSucceed) continue block6;
                        ++sentNum;
                        sendSucceed = false;
                        break;
                    }
                }
                continue;
            }
            catch (Exception err) {
                logger.info((Object)("Exception in MsgUtil.msgGroupSend\u65b9\u6cd5" + err.getMessage()));
            }
        }
        return sentNum;
    }

    private static boolean newMsgMobile(Context ctx, boolean revertible, String title, String content, int priority, UserInfo receiveUserInfo, String receiveMoNumber) throws BOSException, EASBizException {
        if (receiveUserInfo == null) {
            throw new BOSException("Receive mobile user can't be null!");
        }
        SendMobileMessageInfo sendMoMsgInfo = new SendMobileMessageInfo();
        sendMoMsgInfo.setSendHandcraft(false);
        sendMoMsgInfo.setRevertible(revertible);
        sendMoMsgInfo.setPriority(AppMsgUtil.getPriorityEnum(priority));
        sendMoMsgInfo.setContent(title + "[" + ContextUtil.getCurrentUserInfo((Context)ctx).getName() + "]");
        sendMoMsgInfo.setTitle(content);
        MobileMessageAddressInfo addressInfo = new MobileMessageAddressInfo();
        if (StringUtils.isEmpty((String)receiveMoNumber)) {
            return false;
        }
        addressInfo.setReceiveMobileNumber(receiveMoNumber);
        addressInfo.setReceiveBizUser(receiveUserInfo);
        String phoneNum = "";
        try {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (userInfo != null) {
                addressInfo.setSendBizUser(userInfo);
                PersonInfo personInfo = AppMsgUtil.getPersonByUser(ctx, userInfo);
                if (personInfo != null && !StringUtils.isEmpty((String)personInfo.getCell())) {
                    phoneNum = personInfo.getCell();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        addressInfo.setSendMobileNumber(phoneNum);
        addressInfo.setReceiveCellNumberType(CellphoneNumberTypeEnum.getEnum(MobileUtil.getCellphoneNumberType(receiveMoNumber)));
        addressInfo.setSendCellNumberType(CellphoneNumberTypeEnum.getEnum(MobileUtil.getCellphoneNumberType(phoneNum)));
        sendMoMsgInfo.setAddress(addressInfo);
        IObjectPK pk = null;
        boolean sendSuccess = false;
        pk = DefaultSendMoMsgDao.addNew(ctx, sendMoMsgInfo);
        if (pk != null) {
            sendSuccess = true;
        }
        return sendSuccess;
    }

    public static Locale getLocalByPersonID(String personID, Context ctx) {
        return ctx.getLocale();
    }

    public static void msgMoblieByUserMap(Context ctx, Map map, int priority, boolean revertible) throws EASBizException, BOSException {
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        ObjectUuidPK pk = null;
        PersonInfo person = null;
        String address = null;
        while (iterator.hasNext()) {
            String personId = iterator.next().toString();
            if (personId == null || personId.trim().length() <= 0 || (address = (person = iPerson.getPersonInfo((IObjectPK)(pk = new ObjectUuidPK(personId)))).getCell()) == null || address.trim().length() < 1) continue;
            MsgUtil.sendMobileMsg(ctx, (String)map.get(personId), priority, revertible, "", address, null);
        }
    }

    public static boolean msgSend(Context ctx, String title, int priority, boolean revertible, String content, String personId, int msgType, KDMessageAttachment[] attachment, String assignID) throws EASBizException, BOSException {
        return MsgUtil.msgSend(ctx, title, priority, revertible, content, personId, msgType, attachment, assignID, null);
    }

    public static boolean msgSend(Context ctx, String title, int priority, boolean revertible, String content, String personId, int msgType, KDMessageAttachment[] attachment, String assignID, MimeTypeEnum mimeType) throws EASBizException, BOSException {
        PersonInfo person = null;
        String address = null;
        if (!StringUtils.isEmpty((String)personId)) {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = null;
            pk = new ObjectUuidPK(personId);
            person = iPerson.getPersonInfo((IObjectPK)pk);
            boolean succeed = false;
            switch (msgType) {
                case 2: {
                    address = person.getEmail();
                    if (StringUtils.isEmpty((String)address)) {
                        throw new MobileConnectException(MobileConnectException.USER_NOT_LOIGN_EMAIL);
                    }
                    succeed = MsgUtil.sendMail(ctx, title, priority, revertible, content, address, attachment, assignID, mimeType);
                    ServerCenterFactory.getServerCenter(ctx);
                    return succeed;
                }
                case 3: {
                    address = person.getRtx();
                    if (StringUtils.isEmpty((String)address)) {
                        throw new MobileConnectException(MobileConnectException.USER_NOT_LOIGN_RTX);
                    }
                    succeed = MsgUtil.sendRTXMsg(ctx, title, priority, revertible, content, address);
                    ServerCenterFactory.getServerCenter(ctx);
                    return succeed;
                }
                case 1: {
                    address = person.getCell();
                    if (StringUtils.isEmpty((String)address)) {
                        throw new MobileConnectException(MobileConnectException.USER_NOT_LOIGN);
                    }
                    succeed = MsgUtil.sendMobileMsg(ctx, title, priority, revertible, content, address, assignID);
                    return succeed;
                }
            }
            throw new MobileException(MobileException.MSGTYPE_ERROR);
        }
        throw new MobileConnectException(MobileConnectException.USER_NOT_LOIGN);
    }

    public static boolean mobileMsgSend(Context ctx, String title, int priority, boolean revertible, String content, String receiveMobileNumber, String assignID) throws EASBizException, BOSException {
        boolean succeed = MsgUtil.sendMobileMsg(ctx, title, priority, revertible, content, receiveMobileNumber, assignID);
        return succeed;
    }

    private static boolean sendMail(Context ctx, String title, int priority, boolean revertible, String content, String address, KDMessageAttachment[] attachment, String assignID) throws EASBizException, BOSException {
        return MsgUtil.sendMail(ctx, title, priority, revertible, content, address, attachment, assignID, null);
    }

    private static boolean sendMail(Context ctx, String title, int priority, boolean revertible, String content, String address, KDMessageAttachment[] attachment, String assignID, MimeTypeEnum mimeType) throws EASBizException, BOSException {
        EmailSendMessageInfo emailSendMsgInfo = new EmailSendMessageInfo();
        if (mimeType != null) {
            emailSendMsgInfo.setMimeType(mimeType);
        }
        emailSendMsgInfo.setPriority(AppMsgUtil.getPriorityEnum(priority));
        emailSendMsgInfo.setRevertible(revertible);
        emailSendMsgInfo.setAssignID(assignID);
        emailSendMsgInfo.setContent(content);
        emailSendMsgInfo.setTitle(title);
        EmailAddressInfo addressInfo = new EmailAddressInfo();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo != null) {
            addressInfo.setSendBizUser(userInfo);
            PersonInfo sendPersonInfo = AppMsgUtil.getPersonByUser(ctx, userInfo);
            if (sendPersonInfo != null && !StringUtils.isEmpty((String)sendPersonInfo.getEmail())) {
                addressInfo.setFrom(sendPersonInfo.getEmail());
            }
            emailSendMsgInfo.setTitle(title + "[" + userInfo.getName() + "]");
        } else {
            emailSendMsgInfo.setTitle(title);
        }
        addressInfo.setTo(address);
        emailSendMsgInfo.setAddress(addressInfo);
        boolean sendSuccess = false;
        IObjectPK pk = DefaultEmailMessageDAO.addNew(ctx, emailSendMsgInfo);
        if (pk != null) {
            sendSuccess = true;
        } else {
            logger.info((Object)"add email: pk is null.");
        }
        return sendSuccess;
    }

    private static boolean sendRTXMsg(Context ctx, String title, int priority, boolean revertible, String content, String address) throws EASBizException, BOSException {
        return false;
    }

    private static boolean sendMobileMsg(Context ctx, String title, int priority, boolean revertible, String content, String receiveMobileNumber, String assignID) throws EASBizException, BOSException {
        SendMobileMessageInfo sendMoMsgInfo = new SendMobileMessageInfo();
        sendMoMsgInfo.setSendHandcraft(true);
        sendMoMsgInfo.setRevertible(revertible);
        sendMoMsgInfo.setPriority(AppMsgUtil.getPriorityEnum(priority));
        sendMoMsgInfo.setContent(title);
        sendMoMsgInfo.setTitle(content);
        sendMoMsgInfo.setAssignID(assignID);
        MobileMessageAddressInfo addressInfo = new MobileMessageAddressInfo();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo != null) {
            addressInfo.setSendBizUser(userInfo);
            PersonInfo sendPersonInfo = AppMsgUtil.getPersonByUser(ctx, userInfo);
            if (sendPersonInfo != null && !StringUtils.isEmpty((String)sendPersonInfo.getCell())) {
                addressInfo.setSendMobileNumber(sendPersonInfo.getCell());
                addressInfo.setSendCellNumberType(CellphoneNumberTypeEnum.getEnum(MobileUtil.getCellphoneNumberType(sendPersonInfo.getCell())));
            }
            sendMoMsgInfo.setTitle(title + "[" + userInfo.getName() + "]");
        } else {
            sendMoMsgInfo.setTitle(content);
        }
        addressInfo.setReceiveMobileNumber(receiveMobileNumber);
        addressInfo.setReceiveCellNumberType(CellphoneNumberTypeEnum.getEnum(MobileUtil.getCellphoneNumberType(receiveMobileNumber)));
        UserInfo receiveUserInfo = null;
        String receiveUserId = AppMsgUtil.getUserIdByMobileNumber(ctx, receiveMobileNumber);
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        if (!StringUtils.isEmpty((String)receiveUserId)) {
            try {
                receiveUserInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(receiveUserId));
            }
            catch (Exception e) {
                receiveUserInfo = null;
            }
        }
        addressInfo.setReceiveBizUser(receiveUserInfo);
        sendMoMsgInfo.setAddress(addressInfo);
        IObjectPK pk = null;
        boolean sendSuccess = false;
        pk = DefaultSendMoMsgDao.addNew(ctx, sendMoMsgInfo);
        if (pk != null) {
            sendSuccess = true;
        }
        return sendSuccess;
    }

    public static boolean msgMailDerect(Context ctx, String title, String content, String receiver, String secretReceiver, String copyReceiver, KDMessageAttachment[] attachment) throws BOSException, EASBizException {
        ServerCenter server = ServerCenterFactory.getServerCenter(ctx);
        return server.sendMailDerect(ctx, title, content, MimeTypeEnum.TEXT, receiver, secretReceiver, copyReceiver, attachment);
    }

    public static boolean newMsgMobileDerect(Context ctx, boolean canback, String content, UserInfo receiveUserInfo) throws BOSException, EASBizException {
        boolean succeed = MsgUtil.newMsgMobileDirect(ctx, canback, false, false, content, null, receiveUserInfo);
        return succeed;
    }

    public static boolean newMsgMobileDerect(Context ctx, boolean canback, String content, String receiveMobileNumber) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)receiveMobileNumber)) {
            throw new BOSException("Receive mobile number can't be null!");
        }
        String[] receiveMobileNumbers = null;
        receiveMobileNumbers = receiveMobileNumber.indexOf(";") > -1 ? receiveMobileNumber.trim().split(";") : (receiveMobileNumber.indexOf(",") > -1 ? receiveMobileNumber.trim().split(",") : new String[]{receiveMobileNumber});
        boolean succeed = true;
        for (int i = 0; i < receiveMobileNumbers.length; ++i) {
            if (StringUtils.isEmpty((String)receiveMobileNumbers[i]) || MsgUtil.newMsgMobileDirect(ctx, canback, false, false, content, receiveMobileNumbers[i], null)) continue;
            succeed = false;
            break;
        }
        return succeed;
    }

    public static boolean newMsgMobileDerect(Context ctx, SendMessageParamInfo msgInfo) throws BOSException, EASBizException {
        boolean canback = msgInfo.isCanback();
        boolean isAppendRevert = msgInfo.isAppendRevert();
        boolean isAppendUserName = msgInfo.isAppendUserName();
        boolean isAppendCompanyName = msgInfo.isAppendCompanyName();
        boolean isAppendNumber = msgInfo.isAppendNumber();
        boolean isAppendPersonName = msgInfo.isAppendPersonName();
        String content = msgInfo.getContent();
        String receiveMobileNumber = msgInfo.getReceiver();
        logger.info((Object)("----mobile----receiveMobileNumber=" + receiveMobileNumber));
        if (msgInfo.getPhoneNumber() != null) {
            Iterator it = msgInfo.getPhoneNumber().iterator();
            StringBuffer sb = new StringBuffer();
            while (it.hasNext()) {
                sb.append((String)it.next()).append(",");
            }
            receiveMobileNumber = sb.toString();
        }
        logger.info((Object)("----mobile----PhoneNumber=" + msgInfo.getPhoneNumber()));
        logger.info((Object)("----mobile----receiveMobileNumber2=" + receiveMobileNumber));
        if (StringUtils.isEmpty((String)receiveMobileNumber)) {
            throw new BOSException("Receive mobile number can't be null!");
        }
        String actualContent = MsgUtil.generateActualMsgContent(ctx, canback, isAppendRevert, isAppendUserName, isAppendCompanyName, content);
        String[] receiveMobileNumbers = null;
        receiveMobileNumbers = receiveMobileNumber.indexOf(";") > -1 ? receiveMobileNumber.trim().split(";") : (receiveMobileNumber.indexOf(",") > -1 ? receiveMobileNumber.trim().split(",") : new String[]{receiveMobileNumber});
        boolean succeed = true;
        for (int i = 0; i < receiveMobileNumbers.length; ++i) {
            if (StringUtils.isEmpty((String)receiveMobileNumbers[i])) continue;
            logger.info((Object)("----mobile----i=" + i + "receiveMobileNumbers[i]" + receiveMobileNumbers[i]));
            if (MsgUtil.newMsgMobileDirect(ctx, canback, isAppendNumber, isAppendPersonName, actualContent, receiveMobileNumbers[i], null)) continue;
            succeed = false;
            break;
        }
        return succeed;
    }

    public static boolean newMsgMobileDerect(Context ctx, boolean canback, boolean isAppendRevert, boolean isAppendUserName, boolean isAppendCompanyName, String content, String receiveMobileNumber) throws BOSException, EASBizException {
        SendMessageParamInfo info = new SendMessageParamInfo();
        info.setAppendCompanyName(isAppendCompanyName);
        info.setAppendNumber(false);
        info.setAppendPersonName(false);
        info.setAppendRevert(isAppendRevert);
        info.setAppendUserName(isAppendUserName);
        info.setCanback(canback);
        info.setContent(content);
        info.setReceiver(receiveMobileNumber);
        return MsgUtil.newMsgMobileDerect(ctx, info);
    }

    private static String generateActualMsgContent(Context ctx, boolean canback, boolean isAppendRevert, boolean isAppendUserName, boolean isAppendCompanyName, String content) {
        StringBuffer actualContent = new StringBuffer(content);
        String userName = ContextUtil.getCurrentUserInfo((Context)ctx).getName();
        String companyName = null;
        if (ContextUtil.getCurrentFIUnit((Context)ctx) != null && StringUtils.isEmpty((String)(companyName = ContextUtil.getCurrentFIUnit((Context)ctx).getSimpleName()))) {
            companyName = ContextUtil.getCurrentFIUnit((Context)ctx).getName();
        }
        if (StringUtils.isEmpty(companyName) && StringUtils.isEmpty((String)(companyName = ContextUtil.getCurrentOrgUnit((Context)ctx).getSimpleName()))) {
            companyName = ContextUtil.getCurrentOrgUnit((Context)ctx).getName();
        }
        if (isAppendCompanyName && isAppendUserName) {
            actualContent.append("[").append(companyName).append("-").append(userName).append("]");
        } else if (isAppendCompanyName && !isAppendUserName) {
            actualContent.append("[").append(companyName).append("]");
        } else if (!isAppendCompanyName && isAppendUserName) {
            actualContent.append("[").append(userName).append("]");
        }
        if (canback && isAppendRevert) {
            actualContent.append(EASCommonResource.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"kehuifu", (Locale)ctx.getLocale()));
        } else if (!canback && isAppendRevert) {
            actualContent.append(EASCommonResource.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"bukehuifu", (Locale)ctx.getLocale()));
        }
        return actualContent.toString();
    }

    private static boolean newMsgMobileDirect(Context ctx, boolean canback, boolean isAppendNumber, boolean isAppendPersonName, String content, String receiveMobileNumber, UserInfo receiveUserInfo) throws BOSException, EASBizException {
        if (receiveUserInfo == null && StringUtils.isEmpty((String)receiveMobileNumber)) {
            throw new BOSException("Receive mobile number and user can't all be null!");
        }
        SendMobileMessageInfo sendMoMsgInfo = new SendMobileMessageInfo();
        sendMoMsgInfo.setSendHandcraft(true);
        sendMoMsgInfo.setRevertible(canback);
        sendMoMsgInfo.setIsAppendNumber(isAppendNumber);
        sendMoMsgInfo.setIsAppendPersonName(isAppendPersonName);
        sendMoMsgInfo.setContent(content);
        logger.info((Object)("------mobile---newMsgMobileDirect--content=" + content));
        sendMoMsgInfo.setTitle("for.hander");
        MobileMessageAddressInfo addressInfo = new MobileMessageAddressInfo();
        if (receiveUserInfo == null) {
            IUser iUser;
            UserInfo receiveUser;
            String receiveUserId = AppMsgUtil.getUserIdByMobileNumber(ctx, receiveMobileNumber);
            if (!StringUtils.isEmpty((String)receiveUserId) && (receiveUser = (iUser = UserFactory.getLocalInstance((Context)ctx)).getUserInfo((IObjectPK)new ObjectUuidPK(receiveUserId))) != null) {
                receiveUserInfo = receiveUser;
            }
        } else if (StringUtils.isEmpty((String)receiveMobileNumber)) {
            PersonInfo receivePersonInfo = AppMsgUtil.getPersonByUser(ctx, receiveUserInfo);
            receiveMobileNumber = receivePersonInfo.getCell();
        }
        logger.info((Object)("----mobile---newMsgMobileDirect--receiveUserInfo=" + receiveUserInfo));
        logger.info((Object)("----mobile---newMsgMobileDirect--receiveMobileNumber=" + receiveMobileNumber));
        addressInfo.setReceiveBizUser(receiveUserInfo);
        addressInfo.setReceiveMobileNumber(receiveMobileNumber);
        String phoneNum = "";
        try {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (userInfo != null) {
                addressInfo.setSendBizUser(userInfo);
                PersonInfo personInfo = AppMsgUtil.getPersonByUser(ctx, userInfo);
                if (personInfo != null && !StringUtils.isEmpty((String)personInfo.getCell())) {
                    phoneNum = personInfo.getCell();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        addressInfo.setSendMobileNumber(phoneNum);
        addressInfo.setReceiveCellNumberType(CellphoneNumberTypeEnum.getEnum(MobileUtil.getCellphoneNumberType(receiveMobileNumber)));
        addressInfo.setSendCellNumberType(CellphoneNumberTypeEnum.getEnum(MobileUtil.getCellphoneNumberType(phoneNum)));
        sendMoMsgInfo.setAddress(addressInfo);
        IObjectPK pk = null;
        boolean sendSuccess = false;
        pk = DefaultSendMoMsgDao.addNew(ctx, sendMoMsgInfo);
        if (pk != null) {
            sendSuccess = true;
        }
        return sendSuccess;
    }

    public static boolean msgMobileDerect(Context ctx, String title, String receiver) throws BOSException, EASBizException {
        ServerCenter server = ServerCenterFactory.getServerCenter(ctx);
        return server.sendMessageDirect(ctx, title, receiver);
    }

    public static void sendBOSMessage(Context ctx, Message msg) throws EASBizException, BOSException {
        logger.info((Object)"---mobile---MsgUtil--AppMsgUtil.sendBOSMessage---");
        AppMsgUtil.sendBOSMessage(ctx, msg);
    }

    public static Message createMessage(Context ctx, String userId, String title, String content, MsgPriority priority) {
        Message noticeMsg = MessageFactory.newMessage((String)"kingdee.mobile");
        noticeMsg.setStringHeader("databaseCenter", ctx.getAIS());
        noticeMsg.setStringHeader("solution", ctx.getSolution());
        noticeMsg.setIntHeader("type", 0);
        noticeMsg.setIntHeader("bizType", 10);
        noticeMsg.setIntHeader("sourceStatus", 0);
        noticeMsg.setIntHeader("priority", priority.getValue());
        noticeMsg.setLocaleStringHeader("title", title, ctx.getLocale());
        noticeMsg.setLocaleStringHeader("body", content, ctx.getLocale());
        noticeMsg.setLocaleStringHeader("sender", "EAS", ctx.getLocale());
        noticeMsg.setLocaleStringHeader("initiatorName", "EAS", ctx.getLocale());
        noticeMsg.setStringHeader("receiver", userId);
        return noticeMsg;
    }

    public static Message createMessage(Context ctx, String userId, String title, String content) {
        return MsgUtil.createMessage(ctx, userId, title, content, MsgPriority.MIDDLE);
    }
}

