/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.util;

import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.eas.mobile.DataTypeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class MobileUtil {
    public static int getCellphoneNumberType(String cellphoneNumber) {
        if (cellphoneNumber == null || cellphoneNumber.trim().length() == 0) {
            return 0;
        }
        String number = cellphoneNumber.trim();
        try {
            new Long(number);
        }
        catch (NumberFormatException e) {
            return 0;
        }
        if (number.length() != 11) {
            return 0;
        }
        String prefix3 = number.substring(0, 3);
        String prefix4 = number.substring(0, 4);
        int prefix3Int = new Integer(prefix3);
        int prefix4Int = new Integer(prefix4);
        if (prefix3Int >= 130 && prefix3Int <= 133) {
            return 2;
        }
        if (prefix3Int >= 134 && prefix3Int <= 139 && prefix4Int != 1349 || prefix3Int == 159 || prefix3Int == 158) {
            return 1;
        }
        return 0;
    }

    public static boolean isCellphoneNumber(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        String number = str.trim();
        try {
            new Long(number);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return number.length() == 11;
    }

    public static StringBuffer filterStringBufferDup(StringBuffer buf) {
        if (buf.toString().equals("")) {
            return buf;
        }
        String tempStr = buf.toString();
        String[] rtnStrArray = tempStr.split(",");
        if (rtnStrArray.length == 0) {
            return new StringBuffer();
        }
        return MobileUtil.filterDup(rtnStrArray);
    }

    public static StringBuffer filterDup(String[] str) {
        HashSet<String> set = new HashSet<String>();
        int num = str.length;
        for (int i = 0; i < num; ++i) {
            set.add(str[i]);
        }
        StringBuffer result = new StringBuffer();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            if (result.length() != 0) {
                result.append(",");
            }
            result.append(iter.next().toString());
        }
        return result;
    }

    public static HashMap parseQueryCondition(String condition, ArrayList keyList) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] entries = condition.split(",");
        for (int i = 0; i < keyList.size(); ++i) {
            String key = (String)keyList.get(i);
            for (int j = 0; j < entries.length; ++j) {
                String entry = entries[j];
                String[] elements = entry.split(":");
                if (!key.equals(elements[0])) continue;
                map.put(elements[0], elements[1]);
            }
        }
        return map;
    }

    public static String generateQueryCondition(HashMap map, ArrayList keyList) {
        StringBuffer condition = new StringBuffer();
        for (int i = 0; i < keyList.size(); ++i) {
            String key = (String)keyList.get(i);
            if (!map.containsKey(key)) continue;
            String value = (String)map.get(key);
            if (condition.length() > 0) {
                condition.append(",");
            }
            condition.append(key).append(":").append(value);
        }
        return condition.toString();
    }

    public static DataTypeEnum getDataTypeEnumByBOSDataType(DataType dataType) {
        if (dataType == null) {
            return null;
        }
        if (dataType.equals((Object)DataType.SHORT) || dataType.equals((Object)DataType.INTEGER) || dataType.equals((Object)DataType.LONG) || dataType.equals((Object)DataType.FLOAT) || dataType.equals((Object)DataType.DOUBLE) || dataType.equals((Object)DataType.DECIMAL)) {
            return DataTypeEnum.NUMBER;
        }
        if (dataType.equals((Object)DataType.DATE) || dataType.equals((Object)DataType.TIME) || dataType.equals((Object)DataType.TIMESTAMP)) {
            return DataTypeEnum.DATE;
        }
        if (dataType.equals((Object)DataType.CHAR) || dataType.equals((Object)DataType.STRING)) {
            return DataTypeEnum.CHARACTER;
        }
        if (dataType.equals((Object)DataType.BOOLEAN)) {
            return DataTypeEnum.BOOLEAN;
        }
        if (dataType.equals((Object)DataType.BYTE) || dataType.equals((Object)DataType.BYTEARRAY)) {
            return DataTypeEnum.BYTE;
        }
        if (dataType.equals((Object)DataType.OBJECTPK) || dataType.equals((Object)DataType.BOSUUID) || dataType.equals((Object)DataType.UUID)) {
            return DataTypeEnum.BOSPK;
        }
        if (dataType.equals((Object)DataType.ENUM)) {
            return DataTypeEnum.ENUM;
        }
        if (dataType.equals((Object)DataType.OBJECTVALUE)) {
            return DataTypeEnum.OBJECTVALUE;
        }
        if (dataType.equals((Object)DataType.OBJECTCOLLECTION)) {
            return DataTypeEnum.OBJECTCOLLECTION;
        }
        if (dataType.equals((Object)DataType.ROWSET)) {
            return DataTypeEnum.ROWSET;
        }
        return null;
    }
}

