/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.i.node;

import com.kingdee.cbos.process.vm.internal.i.node.AbstractInstruction;
import com.kingdee.cbos.process.vm.internal.i.node.Utils;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.TransitionImpl;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.plugin.Condition;
import com.kingdee.cbos.process.vm.plugin.Identifier;
import com.kingdee.cbos.process.vm.plugin.LiteralCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class FastRouteX
extends AbstractInstruction {
    private NodeImpl node;
    private Map<Object, TransitionImpl> routeTab;
    private HashSet<Identifier> identifiers;
    private TransitionImpl defaultTrans;
    private List<TransitionImpl> nomalTrans;

    public FastRouteX(NodeImpl node, int index) {
        super(index);
        this.node = node;
        if (node != null) {
            this.generateRouteTable();
        }
    }

    private void generateRouteTable() {
        this.routeTab = new HashMap<Object, TransitionImpl>();
        this.nomalTrans = new ArrayList<TransitionImpl>();
        this.identifiers = new HashSet();
        for (TransitionImpl exit : this.node.getNormalExits()) {
            Condition c = exit.getCondition();
            if (c == null) {
                if (this.defaultTrans != null) {
                    throw new RuntimeException(this.node + "\u6709\u591a\u4e2a\u9ed8\u8ba4\u51fa\u53e3\u8f6c\u79fb\uff0c\u4e0d\u5141\u8bb8\u5355\u9009\u8def\u7531!");
                }
                this.defaultTrans = exit;
                continue;
            }
            if (c instanceof LiteralCondition) {
                Object[] domain;
                LiteralCondition lc = (LiteralCondition)c;
                Identifier identifier = lc.getIdentifier();
                this.identifiers.add(identifier);
                for (Object id : domain = lc.getDomain()) {
                    if (this.routeTab.containsKey(id)) {
                        throw new RuntimeException(id + "\u5173\u8054\u591a\u4e2a\u51fa\u53e3\u8f6c\u79fb\uff0c\u4e0d\u5141\u8bb8\u5355\u9009\u8def\u7531!");
                    }
                    this.routeTab.put(id, exit);
                }
                continue;
            }
            this.nomalTrans.add(exit);
        }
    }

    @Override
    public int invoke(ExecutionImpl<NodeImpl> e) throws Exception {
        TransitionImpl selected = null;
        for (Identifier identifier : this.identifiers) {
            Object id;
            Object[] objectArray = identifier.getIds(e);
            int n = objectArray.length;
            for (int i = 0; i < n && (selected = this.routeTab.get(id = objectArray[i])) == null; ++i) {
            }
            if (selected == null) continue;
            break;
        }
        if (selected == null && this.nomalTrans.size() > 0) {
            for (TransitionImpl t : this.nomalTrans) {
                if (!t.getCondition().test(e)) continue;
                selected = t;
                break;
            }
        }
        if (selected == null) {
            if (this.defaultTrans == null) {
                throw new RuntimeException("{" + e + "}\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u8f6c\u79fb\uff01");
            }
            selected = this.defaultTrans;
        }
        Utils.transit(e, selected);
        return 1;
    }

    public String toString() {
        return "fast-route-x";
    }
}

