/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.i.node;

import com.kingdee.cbos.process.vm.internal.i.node.AbstractInstruction;
import com.kingdee.cbos.process.vm.internal.i.node.Dispatch2NotClosed;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.TransitionImpl;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.model.VariableScope;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Join
extends AbstractInstruction {
    private boolean omitReenter;

    public Join(int index) {
        this(index, false);
    }

    public Join(int index, boolean omitReenter) {
        super(index);
        this.omitReenter = omitReenter;
    }

    @Override
    public int invoke(ExecutionImpl<NodeImpl> e) {
        List<String> executed = Dispatch2NotClosed.getExecutedPriorTransitions(e);
        HashSet<String> set = new HashSet<String>();
        set.addAll(executed);
        for (TransitionImpl t : ((NodeImpl)e.getDefine()).getNormalEntries()) {
            if (set.contains(t.getId())) continue;
            return 0;
        }
        this.reenterCheck(e, executed, set);
        return 1;
    }

    private void reenterCheck(ExecutionImpl<NodeImpl> e, List<String> executed, Set<String> set) {
        if (!this.omitReenter) {
            for (String s : set) {
                executed.remove(s);
            }
            if (executed.size() > 0) {
                ExecutionImpl<VariableScope> x = new ExecutionImpl<VariableScope>((ExecutionImpl<?>)e.getParent(), e.getDefine(), e.getDataArea(), null, null);
                Dispatch2NotClosed.setExecutedPriorTransitions(x, executed);
                e.getContext().push(x);
            }
        }
    }

    public String toString() {
        return this.omitReenter ? "join-omit-reenter" : "join";
    }
}

