/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.m;

import com.kingdee.cbos.process.vm.internal.Consts;
import com.kingdee.cbos.process.vm.internal.Feature;
import com.kingdee.cbos.process.vm.internal.i.NIS;
import com.kingdee.cbos.process.vm.internal.i.wrapper.NodeListenerWrapper;
import com.kingdee.cbos.process.vm.internal.m.FlowImpl;
import com.kingdee.cbos.process.vm.internal.m.GroupImpl;
import com.kingdee.cbos.process.vm.internal.m.Output;
import com.kingdee.cbos.process.vm.internal.m.Priority;
import com.kingdee.cbos.process.vm.internal.m.TransitionImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableScopeImpl;
import com.kingdee.cbos.process.vm.internal.m.a.Graph;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.model.Event;
import com.kingdee.cbos.process.vm.model.Node;
import com.kingdee.cbos.process.vm.model.Transition;
import com.kingdee.cbos.process.vm.model.VariableScope;
import com.kingdee.cbos.process.vm.plugin.Listener;
import com.kingdee.cbos.process.vm.runtime.Execution;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class NodeImpl
extends VariableScopeImpl<NodeImpl>
implements Node {
    private NodeImpl parent;
    private List<NodeImpl> children;
    private List<TransitionImpl> normalEntries = new ArrayList<TransitionImpl>();
    private List<TransitionImpl> inComing = new ArrayList<TransitionImpl>();
    private List<TransitionImpl> normalExits = new ArrayList<TransitionImpl>();
    private List<TransitionImpl> outGoing = new ArrayList<TransitionImpl>();
    private boolean isStart;
    private boolean isEnd;
    private boolean isSubflow;
    private boolean isTask;
    private boolean isTwoPhase;
    private boolean isCompensation;
    private boolean hasCompensation;
    private List<GroupImpl> scopes;
    private List<Integer> scopes_depth;
    private Map<String, Feature> features = new HashMap<String, Feature>();
    private ArrayList<Feature> feature_list = new ArrayList();
    private boolean isComposite;
    private Output output;
    private Graph graph;
    private int index;

    public NodeImpl(FlowImpl flow, NodeImpl parent, String id, String title) {
        super(flow, id, title, Priority.STACK);
        this.parent = parent;
        this.insert(NIS.END);
        this.insert(NIS.THROW_ERROR);
        if (parent != null) {
            parent.addChildren(this);
        }
    }

    @Override
    public NodeImpl getParent() {
        return this.parent;
    }

    public void join(GroupImpl scope, int depth) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<GroupImpl>();
            this.scopes_depth = new ArrayList<Integer>();
        }
        int j = -1;
        for (int i = 0; i < this.scopes.size(); ++i) {
            if (this.scopes.get(i) != scope) continue;
            j = i;
            break;
        }
        if (j == -1) {
            scope.addNode(this);
            this.scopes.add(scope);
            this.scopes_depth.add(depth);
        } else if (this.scopes_depth.get(j) < depth) {
            this.scopes_depth.set(j, depth);
        }
        if (this.children != null) {
            for (NodeImpl child : this.children) {
                child.join(scope, depth + 1);
            }
        }
    }

    public Output getOutput() {
        return this.output;
    }

    public void setOutput(Output output) {
        this.output = output;
    }

    public List<NodeImpl> getChildren() {
        if (this.children == null) {
            return new ArrayList<NodeImpl>();
        }
        return this.children;
    }

    public int getChildrenCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public List<TransitionImpl> getOutGoing() {
        return this.outGoing;
    }

    public List<TransitionImpl> getInComing() {
        return this.inComing;
    }

    @Override
    public boolean isComposite() {
        return this.isComposite;
    }

    @Override
    public boolean isStart() {
        return this.isStart;
    }

    @Override
    public boolean isEnd() {
        return this.isEnd;
    }

    public List<TransitionImpl> getNormalEntries() {
        return this.normalEntries;
    }

    public List<TransitionImpl> getNormalExits() {
        return this.normalExits;
    }

    public void setComposite() {
        this.isComposite = true;
        this.insert(NIS.WAITING_AFTER_CHILDREN_STARTED);
    }

    void addInComing(TransitionImpl in) {
        this.inComing.add(in);
        if (in.getType() == Transition.Type.NORMAL) {
            this.normalEntries.add(in);
        }
    }

    void addOutGoing(TransitionImpl out) {
        this.outGoing.add(out);
        if (out.getType() == Transition.Type.NORMAL) {
            this.normalExits.add(out);
        }
        switch (out.getType()) {
            case NORMAL: {
                this.insert(NIS.EXCLUSIVE_CHOICE);
                break;
            }
            case ERROR: {
                this.insert(NIS.ERROR_DELIVER);
                this.insert(NIS.CLEAR_ERROR_ON_ERROR_DELIVERED);
                this.insert(NIS.GOTO_DISPOSING_ON_ERROR_DELIVERED);
                break;
            }
            case FORWARD: 
            case BACKWARD: {
                this.insert(NIS.DEFERRED_CHOICE);
                break;
            }
            case COMPENSATION: {
                this.parent.insert(NIS.START_UP_COMPENSATION_ON_DELIVERED);
                this.parent.insert(NIS.START_UP_COMPENSATION_ON_TERMINATED);
                this.hasCompensation = true;
                NodeImpl comp = out.getTarget();
                comp.insert(NIS.INTERRUPT_ON_ERROR);
                comp.isCompensation = true;
                break;
            }
        }
    }

    public boolean isCompensation() {
        return this.isCompensation;
    }

    public void addFeature(Feature f) {
        String[] keys;
        for (String key : keys = f.getCategories()) {
            Feature conflicted = this.features.get(key);
            if (f == conflicted) {
                return;
            }
            if (conflicted != null) {
                throw new RuntimeException("\u7279\u6027(" + f + ")\u4e0e(" + conflicted + ")\u53d1\u751f\u51b2\u7a81\uff0c\u4e0d\u80fd\u540c\u65f6\u8bbe\u7f6e\uff01");
            }
            this.features.put(key, f);
        }
        this.feature_list.add(f);
        f.preHandle(this);
    }

    public boolean hasFeature(String category) {
        return this.features.containsKey(category);
    }

    public Feature getFeature(String category) {
        return this.features.get(category);
    }

    @Override
    public String[] getFeatures() {
        return this.feature_list.toArray(new String[this.feature_list.size()]);
    }

    private void addChildren(NodeImpl child) {
        if (this.children == null) {
            this.children = new ArrayList<NodeImpl>();
        }
        child.index = this.children.size();
        this.children.add(child);
        if (this.scopes != null) {
            for (int i = 0; i < this.scopes.size(); ++i) {
                GroupImpl scope = this.scopes.get(i);
                child.join(scope, this.scopes_depth.get(i) + 1);
            }
        }
        this.insert(NIS.START_SUB_NODES);
        this.setComposite();
    }

    public int getIndex() {
        return this.index;
    }

    private void solidifyChildren() {
        this.children = this.children == null ? Consts.EMPTY_LIST : Collections.unmodifiableList(this.children);
    }

    private void solidifyScopes() {
        this.scopes = this.scopes == null ? Consts.EMPTY_LIST : Collections.unmodifiableList(this.scopes);
    }

    private void solidifyInComing() {
        if (this.inComing == null) {
            this.inComing = Consts.EMPTY_LIST;
            this.normalEntries = this.inComing;
        } else {
            this.normalEntries = Collections.unmodifiableList(this.normalEntries);
            this.inComing = Collections.unmodifiableList(this.inComing);
        }
    }

    private void solidifyOutGoing() {
        if (this.outGoing == null) {
            this.outGoing = Consts.EMPTY_LIST;
            this.normalExits = this.outGoing;
        } else {
            this.normalExits = Collections.unmodifiableList(this.normalExits);
            this.outGoing = Collections.unmodifiableList(this.outGoing);
        }
    }

    private void setStart() {
        int count = 0;
        for (TransitionImpl t : this.getInComing()) {
            if (t.getSource() == this || t.getType() == Transition.Type.BACKWARD) continue;
            ++count;
        }
        this.isStart = count == 0;
    }

    public void setAsStart() {
        this.isStart = true;
    }

    public void setAsNotStart() {
        this.isStart = false;
    }

    public boolean isSubflow() {
        return this.isSubflow;
    }

    public boolean isTask() {
        return this.isTask;
    }

    public boolean isTwoPhase() {
        return this.isTwoPhase;
    }

    public void setTwoPhase() {
        this.isTwoPhase = true;
    }

    public void setTask() {
        this.isTask = true;
    }

    public void setSubflow() {
        this.isSubflow = true;
        this.isTwoPhase = true;
    }

    public void setAsEnd() {
        this.isEnd = true;
    }

    private void setEnd() {
        if (this.isEnd) {
            return;
        }
        int count = 0;
        for (TransitionImpl t : this.getOutGoing()) {
            Transition.Type type = t.getType();
            if (t.getTarget() == this || type == Transition.Type.BACKWARD || type == Transition.Type.COMPENSATION) continue;
            ++count;
        }
        this.isEnd = count == 0;
    }

    private void checkChildren() {
        if (this.children.size() == 0) {
            return;
        }
        for (NodeImpl c : this.children) {
            if (!c.isStart) continue;
            return;
        }
        throw new RuntimeException("\u6ca1\u6709\u5f00\u59cb\u8282\u70b9\uff01");
    }

    private void insertDefaultInstructions() {
        if (this.hasCompensation) {
            if (this.isTwoPhase()) {
                this.insert(NIS.REGISTER_COMPENSATION_ON_RES_INJECTED);
            } else {
                this.insert(NIS.REGISTER_COMPENSATION_ON_BIZ_COMPLETED);
            }
        }
        if (this.isComposite) {
            if (this.contains(NIS.ERROR_DELIVER)) {
                this.insert(NIS.TERMINATE_CHILDREN_ON_ERROR_DELIVERED);
                this.insert(NIS.WAITING_CHILDREN_ON_DELIVERED);
            }
            this.insert(NIS.SUSPEND_CHILDREN_ON_FAILED);
            this.insert(NIS.SIGNAL_CHILDREN_ON_RETRIED);
        }
        this.insert(NIS.HALT_ON_FAILED);
        this.insert(NIS.RESUME_FROM_FAILED);
        if (this.isComposite) {
            this.insert(NIS.SUSPEND_CHILDREN_ON_SUSPENDED);
            this.insert(NIS.SIGNAL_CHILDREN_ON_SUSPENDED);
        }
        this.insert(NIS.HALT_ON_SUSPENED);
        this.insert(NIS.RESUME_FROM_SUSPENDED);
        if (this.isComposite) {
            this.insert(NIS.TERMINATE_CHILDREN_ON_TERMINATED);
            this.insert(NIS.WAITING_CHILDREN_ON_TERMINATED);
        }
        this.insert(NIS.GOTO_DISPOSING_ON_TERMINATED);
    }

    void solidify() {
        this.setStart();
        this.setEnd();
        super.solidifyVariables();
        this.applyFeatures();
        if (this.children != null) {
            for (NodeImpl child : this.children) {
                child.solidify();
            }
        }
        this.solidifyListeners();
        this.solidifyChildren();
        this.solidifyInComing();
        this.solidifyOutGoing();
        this.solidifyScopes();
        this.checkChildren();
        this.insertDefaultInstructions();
    }

    public boolean isSolidified() {
        return !(this.normalEntries instanceof ArrayList);
    }

    public synchronized void generateGraph() {
        if (this.graph == null && this.children.size() > 0) {
            Graph graph;
            this.graph = graph = new Graph(this);
        }
    }

    public Graph getGraph() {
        if (this.graph == null) {
            this.generateGraph();
        }
        return this.graph;
    }

    private void applyFeatures() {
        if (this.feature_list.size() > 0) {
            Feature[] features = this.feature_list.toArray(new Feature[this.feature_list.size()]);
            Arrays.sort(features, Feature.COMPARATOR);
            for (Feature f : features) {
                f.postHandle(this);
            }
        }
        if (this.features.size() == 0) {
            this.features = Consts.EMPTY_MAP;
        }
    }

    @Override
    Map<String, VariableImpl<? extends VariableScope>> getOtherAvailableVariables() {
        NodeImpl parent = this.getParent();
        HashMap<String, VariableImpl<? extends VariableScope>> map = new HashMap<String, VariableImpl<? extends VariableScope>>();
        map.putAll(parent == null ? this.getFlow().getAvailableVariables() : parent.getAvailableVariables());
        if (this.scopes == null) {
            return map;
        }
        HashMap scopes_vars = new HashMap();
        for (int i = 0; i < this.scopes.size(); ++i) {
            if (this.scopes_depth.get(i) > 0) continue;
            GroupImpl scope = this.scopes.get(i);
            for (VariableImpl v : scope.getVariables().values()) {
                VariableImpl exists = (VariableImpl)scopes_vars.get(v.getName());
                if (exists == null) {
                    scopes_vars.put(v.getName(), v);
                    continue;
                }
                if (exists.getParent() == v.getParent()) continue;
                throw new RuntimeException("\u8282\u70b9(" + this + ")\u6240\u5c5e\u533a\u57df(" + v.getParent() + ")\u4e0e(" + exists.getParent() + ")\u5b58\u5728\u53d8\u91cf\u540d\u51b2\u7a81\uff01");
            }
        }
        map.putAll(scopes_vars);
        return map;
    }

    public void addListener(Event<Node> e, Listener<Execution<Node>> listener) {
        this.getFlow().registerListener(listener, this);
        Listener<Execution<Node>> l = listener;
        this.addListener(new NodeListenerWrapper(e, (Listener<ExecutionImpl<NodeImpl>>)l, this.getFlow()));
    }

    void dumpMicroProgram(StringBuilder sb, int depth) {
        sb.append("\r\n");
        for (int i = 0; i <= depth; ++i) {
            sb.append("    ");
        }
        sb.append(this).append(": ");
        super.dumpMicroProgram(sb);
        for (NodeImpl child : this.getChildren()) {
            child.dumpMicroProgram(sb, depth + 1);
        }
    }

    void dumpDiagram(StringBuilder sb) {
        this.generateGraph();
        if (this.children.size() > 0) {
            sb.append("\r\n").append(this).append(":\r\n");
            for (NodeImpl c : this.children) {
                sb.append("    ").append(c);
                if (c.isStart()) {
                    sb.append("^");
                } else if (c.isEnd()) {
                    sb.append("$");
                }
                sb.append("\t=>");
                for (TransitionImpl out : c.getOutGoing()) {
                    sb.append(" ").append(out.getTarget());
                    if (out.isBackward()) {
                        sb.append("*");
                    }
                    sb.append(";");
                }
                sb.append("\r\n");
            }
        }
        for (NodeImpl child : this.getChildren()) {
            child.dumpDiagram(sb);
        }
    }
}

