/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.r;

import com.kingdee.cbos.process.vm.internal.Consts;
import com.kingdee.cbos.process.vm.internal.f.advanced.CallSubFlow;
import com.kingdee.cbos.process.vm.internal.i.Instruction;
import com.kingdee.cbos.process.vm.internal.i.NIS;
import com.kingdee.cbos.process.vm.internal.i.common.Halt;
import com.kingdee.cbos.process.vm.internal.i.node.Utils;
import com.kingdee.cbos.process.vm.internal.m.AbstractElement;
import com.kingdee.cbos.process.vm.internal.m.FlowImpl;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableScopeImpl;
import com.kingdee.cbos.process.vm.internal.r.DataAreaImpl;
import com.kingdee.cbos.process.vm.internal.r.FlowContextImpl;
import com.kingdee.cbos.process.vm.internal.r.PropertyContainerImpl;
import com.kingdee.cbos.process.vm.model.Variable;
import com.kingdee.cbos.process.vm.model.VariableScope;
import com.kingdee.cbos.process.vm.plugin.SubFlowLoader;
import com.kingdee.cbos.process.vm.plugin.Synchronizer;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.utils.InstructionNotMatchException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public final class ExecutionImpl<D extends VariableScopeImpl<?>>
extends PropertyContainerImpl
implements Execution<D> {
    private static Logger logger = Logger.getLogger(ExecutionImpl.class);
    private D scope;
    private DataAreaImpl dataArea;
    private String id;
    private ExecutionImpl<?> parent;
    private ArrayList<ExecutionImpl<?>> children;
    private int ip = 0;
    private int recovery = -1;
    private String priorIds;
    private String entryTransition;

    private ExecutionImpl() {
    }

    public static ExecutionImpl<?> fromXml(HashMap<String, FlowImpl> flows, Element e, FlowContextImpl ctx, DataAreaImpl dataArea) {
        VariableScopeImpl<?> scope = ExecutionImpl.checkDef(e, dataArea);
        ExecutionImpl exe = new ExecutionImpl();
        exe.scope = scope;
        exe.dataArea = dataArea;
        exe.id = e.getAttribute("id");
        ExecutionImpl.restoreParent(e, ctx, exe);
        ExecutionImpl.restoreInstruction(e, exe);
        ExecutionImpl.restoreRecovery(e, exe);
        ExecutionImpl.restorePriorIds(e, exe);
        ExecutionImpl.restoreEntryTransition(e, exe);
        ctx.register(exe);
        ExecutionImpl.retrieveSubFlow(flows, scope, exe);
        exe.restoreProperties(e);
        return exe;
    }

    private static void restoreRecovery(Element e, ExecutionImpl exe) {
        int recovery = Integer.parseInt(e.getAttribute("recovery"));
        exe.recovery = recovery < 40000 ? recovery : ((VariableScopeImpl)exe.getDefine()).seekInstruction(recovery);
    }

    private static void restoreInstruction(Element e, ExecutionImpl<?> exe) {
        int label = Integer.parseInt(e.getAttribute("ip"));
        exe.seek(label);
        if (exe.current().getLabel() != label) {
            String msg = exe + "\u7684\u6307\u4ee4(" + label + ")\u4e0e(" + exe.current() + ")\u4e0d\u5339\u914d.";
            logger.warn((Object)msg, (Throwable)new Exception());
            throw new InstructionNotMatchException(msg);
        }
    }

    private static void retrieveSubFlow(HashMap<String, FlowImpl> flows, VariableScopeImpl scope, ExecutionImpl exe) {
        NodeImpl node;
        if (scope instanceof NodeImpl && (node = (NodeImpl)scope).isSubflow()) {
            SubFlowLoader loader = ((CallSubFlow)node.getFeature("biz")).getSubFlow();
            FlowImpl subflow = (FlowImpl)loader.getFlow(exe);
            flows.put(subflow.getId(), subflow);
        }
    }

    private static void restoreParent(Element e, FlowContextImpl ctx, ExecutionImpl exe) {
        String parent = e.getAttribute("parent");
        if (parent.length() > 0) {
            exe.parent = ctx.getExecution(parent);
            if (exe.parent == null) {
                throw new RuntimeException("\u7236\u6267\u884c\u5bf9\u8c61(" + parent + ")\u4e0d\u5b58\u5728\uff01");
            }
            super.addChildren(exe);
        }
    }

    private static void restoreEntryTransition(Element e, ExecutionImpl<?> exe) {
        exe.entryTransition = e.getAttribute("entryTransition");
        if (exe.entryTransition.length() == 0) {
            exe.entryTransition = null;
        }
    }

    private static void restorePriorIds(Element e, ExecutionImpl<?> exe) {
        exe.priorIds = e.getAttribute("priorIds");
        if (exe.priorIds.length() == 0) {
            exe.priorIds = null;
        }
    }

    private static VariableScopeImpl<?> checkDef(Element e, DataAreaImpl dataArea) {
        String defId;
        FlowImpl flow = dataArea.getFlow();
        VariableScopeImpl scope = (VariableScopeImpl)flow.getElement(defId = e.getAttribute("def"));
        if (scope == null) {
            throw new RuntimeException("\u5bf9\u8c61(" + defId + ")\u5b9a\u4e49\u4e0d\u5b58\u5728\uff01");
        }
        return scope;
    }

    void toXml(Element e) {
        e.setAttribute("id", this.id);
        e.setAttribute("def", ((AbstractElement)this.scope).getId());
        e.setAttribute("ip", String.valueOf(this.current().getLabel()));
        String parentId = this.parent == null ? "" : this.parent.getId();
        e.setAttribute("parent", parentId);
        this.saveRecovery(e);
        this.savePriorIds(e);
        this.saveEntryTransition(e);
        this.saveProperties(e);
    }

    private void saveRecovery(Element e) {
        if (this.recovery < 0) {
            e.setAttribute("recovery", String.valueOf(this.recovery));
        } else {
            int label = ((VariableScopeImpl)this.getDefine()).getInstruction(this.recovery).getLabel();
            e.setAttribute("recovery", String.valueOf(label));
        }
    }

    private void saveEntryTransition(Element e) {
        if (this.entryTransition != null) {
            e.setAttribute("entryTransition", this.entryTransition);
        }
    }

    private void savePriorIds(Element e) {
        if (this.priorIds != null) {
            e.setAttribute("priorIds", this.priorIds);
        }
    }

    public ExecutionImpl(ExecutionImpl<?> parent, D scope, DataAreaImpl dataArea, ExecutionImpl<?> prior, String entryTransitionId) {
        if (((AbstractElement)scope).getFlow() != dataArea.getFlow()) {
            throw new RuntimeException("\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u4e00\u81f4!");
        }
        FlowContextImpl ctx = dataArea.getContext();
        this.setScope(scope, ctx);
        this.setDataArea(dataArea);
        this.setParent(parent);
        this.setPrior(prior, entryTransitionId);
        ctx.register(this);
    }

    public void setPrior(ExecutionImpl<?> prior, String entryTransitionId) {
        if (prior == null) {
            this.setPrior((String)null, entryTransitionId);
        } else {
            this.setPrior(prior.getId(), entryTransitionId);
        }
    }

    @Override
    public void setPrior(String prior) {
        this.setPrior(prior, null);
    }

    public void setPrior(String prior, String entryTransitionId) {
        if (prior != null) {
            this.priorIds = this.priorIds == null ? prior : this.priorIds + "," + prior;
        }
        if (entryTransitionId != null) {
            this.entryTransition = entryTransitionId;
        }
    }

    private void setScope(D scope, FlowContextImpl ctx) {
        this.scope = scope;
        int count = ctx.nextId();
        Synchronizer synchronizer = ctx.getFlow().getSynchronizer();
        if (synchronizer != null) {
            this.id = synchronizer.newId((VariableScope)scope);
        }
        if (this.id == null) {
            this.id = String.valueOf(count);
        }
    }

    private void setDataArea(DataAreaImpl dataArea) {
        this.dataArea = dataArea;
        dataArea.add(this);
    }

    private void setParent(ExecutionImpl<?> parent) {
        this.parent = parent;
        if (parent != null) {
            super.addChildren(this);
        }
    }

    private void addChildren(ExecutionImpl<?> child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
    }

    public void end() {
        this.dataArea.remove(this);
        FlowContextImpl ctx = this.dataArea.getContext();
        ctx.unregister(this);
        ArrayList<ExecutionImpl<?>> list = this.parent.children;
        list.remove(this);
        if (list.size() == 0) {
            ctx.push(this.parent);
        }
        this.ip = -1;
    }

    public String getEntryTransitionId() {
        return this.entryTransition;
    }

    @Override
    public String getPriorExecutionIds() {
        return this.priorIds;
    }

    public int getIp() {
        return this.ip;
    }

    @Override
    public boolean isClosed() {
        if (this.ip < 0) {
            return true;
        }
        if (this.recovery < 0) {
            return this.ip >= 502000000;
        }
        return this.recovery >= 502000000;
    }

    public void seek(int label) {
        int address = ((VariableScopeImpl)this.getDefine()).seekInstruction(label);
        if (address < 0) {
            throw new RuntimeException("\u4ece" + this.scope + "\u7684\u6307\u4ee4\u5e8f\u5217\u4e2d\u627e\u4e0d\u5230\u7d22\u5f15\u4e0d\u5c0f\u4e8e" + label + "\u7684\u6307\u4ee4\uff01");
        }
        this.ip = address;
    }

    public void dispose() {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.getContext().unregister(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public D getDefine() {
        return this.scope;
    }

    @Override
    public FlowContextImpl getContext() {
        return this.dataArea.getContext();
    }

    @Override
    public ExecutionImpl<?> getParent() {
        return this.parent;
    }

    @Override
    public List<ExecutionImpl<?>> getChildren() {
        if (this.children == null) {
            return Consts.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.children);
    }

    public int getChildrenCount() {
        return this.children == null ? 0 : this.children.size();
    }

    @Override
    public Object get(String var) {
        Variable v = ((VariableScopeImpl)this.scope).findVariable(var);
        return v == null ? null : this.dataArea.getAt((VariableImpl<?>)v);
    }

    @Override
    public Object get(Variable<?> address) {
        return this.dataArea.getAt((VariableImpl)address);
    }

    @Override
    public void set(String var, Object value) {
        Variable v = ((VariableScopeImpl)this.scope).retrieveVariable(var);
        this.dataArea.setAt((VariableImpl<?>)v, value);
    }

    @Override
    public void set(Variable<?> address, Object value) {
        this.dataArea.setAt((VariableImpl)address, value);
    }

    @Override
    public DataAreaImpl getDataArea() {
        return this.dataArea;
    }

    public String toString() {
        return ((AbstractElement)((Object)this.getDefine())).toString() + "(" + this.id + ")@" + this.dataArea.getId();
    }

    public void bizFailed() {
        this.saveRecovery();
        this.seek(700000000);
        this.getContext().enqueue(this);
    }

    public void suspend(boolean isFromParent) {
        if (this.isInterrupted()) {
            return;
        }
        if (isFromParent && this.isNotStartAppend()) {
            return;
        }
        this.saveRecovery();
        this.seek(1300000000);
        FlowContextImpl ctx = this.getContext();
        ctx.enqueueFirst(this);
    }

    @Override
    public void suspend() {
        this.suspend(false);
    }

    private boolean isNotStartAppend() {
        boolean d;
        boolean isNotStartAppend = false;
        boolean a = "true".equals(this.getProperty("$append$"));
        Instruction b = ((VariableScopeImpl)this.scope).getInstruction(this.ip);
        boolean bl = d = b.getLabel() == NIS.WAITING_FOR_PRIOR_SIBLINGS_BEFORE_CHILDRE.getLabel();
        if (a && d) {
            isNotStartAppend = true;
        }
        return isNotStartAppend;
    }

    @Override
    public void terminate() {
        if (!this.isStarted()) {
            this.end();
        } else {
            this.clearRecovery();
            this.seek(1200000000);
            FlowContextImpl ctx = this.getContext();
            ctx.enqueue(this);
        }
    }

    private void saveRecovery() {
        if (this.recovery >= 0) {
            throw new RuntimeException("\u6267\u884c\u5bf9\u8c61{" + this + "}\u4e0d\u80fd\u91cd\u590d\u4fdd\u5b58\u6062\u590d\u70b9\u3002");
        }
        this.recovery = this.ip;
    }

    public void restorRecovery() {
        this.ip = this.popRecovery();
        this.getContext().push(this);
    }

    public void signal() {
        if (this.recovery < 0 && this.current() instanceof Halt) {
            ++this.ip;
            this.getContext().push(this);
        }
    }

    @Override
    public boolean isBeforePartiallyCompleted() {
        return this.current().getLabel() <= NIS.HALT_BEFORE_PARTIAL_COMPLETED.getLabel();
    }

    @Override
    public boolean isStarted() {
        Instruction<Object> i = this.recovery < 0 ? this.current() : ((VariableScopeImpl)this.scope).getInstruction(this.recovery);
        return i.getLabel() > NIS.INSTANCE_CREATE.getLabel();
    }

    @Override
    public void resume() {
        if (this.isInterrupted() && this.current() instanceof Halt) {
            ++this.ip;
            this.getContext().push(this);
        }
    }

    @Override
    public boolean isInterrupted() {
        return this.recovery >= 0;
    }

    @Override
    public void reset(String var) {
        Variable v = ((VariableScopeImpl)this.getDefine()).retrieveVariable(var);
        this.dataArea.reset((VariableImpl<?>)v);
    }

    @Override
    public void clear(String var) {
        Variable v = ((VariableScopeImpl)this.getDefine()).retrieveVariable(var);
        this.dataArea.clear((VariableImpl<?>)v);
    }

    @Override
    public void clear(Variable<?> address) {
        this.dataArea.clear((VariableImpl)address);
    }

    @Override
    public boolean isNull(String var) {
        Variable v = ((VariableScopeImpl)this.getDefine()).retrieveVariable(var);
        return this.dataArea.isNull((VariableImpl<?>)v);
    }

    @Override
    public boolean isNull(Variable<?> address) {
        return this.dataArea.isNull((VariableImpl)address);
    }

    @Override
    public void reset(Variable<?> address) {
        this.dataArea.reset((VariableImpl)address);
    }

    public void clearRecovery() {
        this.recovery = -1;
    }

    private void checkRecovery() {
        if (this.recovery < 0) {
            throw new RuntimeException("\u6ca1\u6709\u6062\u590d\u70b9\uff01");
        }
    }

    public int popRecovery() {
        this.checkRecovery();
        int ip = this.recovery;
        this.recovery = -1;
        return ip;
    }

    public Instruction<?> current() {
        return ((VariableScopeImpl)this.scope).getInstruction(this.ip);
    }

    boolean execute() throws Exception {
        int ip = this.ip;
        Instruction i = ((VariableScopeImpl)this.scope).getInstruction(ip);
        int next = -1;
        try {
            next = i.invoke(this);
        }
        catch (Exception error) {
            if (i.getLabel() < 601000000 && !this.isInterrupted()) {
                this.bizFailed();
                this.getContext().setError(error);
            }
            throw error;
        }
        if (ip != this.ip) {
            return false;
        }
        switch (next) {
            case 1: {
                ++this.ip;
                return true;
            }
            case 0: {
                return false;
            }
        }
        this.seek(next);
        return true;
    }

    @Override
    public void activate(String nodeId) {
        NodeImpl target = ((AbstractElement)((Object)this.getDefine())).getFlow().getNode(nodeId);
        if (target == null) {
            throw new RuntimeException("\u8282\u70b9{" + nodeId + "}\u4e0d\u5b58\u5728\uff01");
        }
        Utils.transit(this, target);
    }

    @Override
    public void ignoreBiz() {
        if (this.isInterrupted()) {
            throw new RuntimeException("\u6267\u884c\u5bf9\u8c61\u88ab\u4e2d\u65ad\uff0c\u4e0d\u80fd\u5f3a\u5236\u5b8c\u6210\u3002");
        }
        this.seek(6000000);
        this.getContext().enqueue(this);
    }
}

