/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.t.c;

import com.kingdee.cbos.process.vm.model.CompositeDataType;
import com.kingdee.cbos.process.vm.model.DataType;
import java.util.ArrayList;
import java.util.Collection;

public final class Heap
extends CompositeDataType {
    public Heap(DataType elementType) {
        super(elementType);
    }

    @Override
    public Class<?> getValueClass() {
        return this.getElementType().getValueClass();
    }

    @Override
    protected void narrow(Collection innerValue, Object outerValue) {
        assert (innerValue instanceof ArrayList);
        Comparable v = (Comparable)this.getElementType().narrow(null, outerValue);
        ArrayList list = (ArrayList)innerValue;
        list.add(v);
        Heap.shiftL(list, list.size() - 1);
    }

    @Override
    protected Object wrap(Collection innerValue) {
        if (innerValue == null || innerValue.size() == 0) {
            return null;
        }
        assert (innerValue instanceof ArrayList);
        ArrayList list = (ArrayList)innerValue;
        Object top = list.get(0);
        int size = list.size() - 1;
        if (size == 0) {
            list.clear();
        } else {
            list.set(0, list.remove(size));
            Heap.shiftR(list, 0);
        }
        return top;
    }

    @Override
    protected Collection<Object> newInitialValue() {
        return new ArrayList<Object>();
    }

    private static boolean shiftL(ArrayList<Comparable<Object>> list, int i) {
        int j;
        Comparable<Object> node;
        Comparable<Object> current = list.get(i);
        int index = i;
        while (index > 0 && current.compareTo(node = list.get(j = index - 1 >> 1)) <= 0) {
            list.set(index, node);
            index = j;
        }
        list.set(index, current);
        return index != i;
    }

    private static boolean shiftR(ArrayList<Comparable<Object>> list, int i) {
        Comparable<Object> current = list.get(i);
        int index = i;
        int j = (index << 1) + 1;
        int size = list.size();
        while (j < size) {
            Comparable<Object> node2;
            Comparable<Object> node = list.get(j);
            if (j + 1 < size && (node2 = list.get(j + 1)).compareTo(node) < 0) {
                ++j;
                node = node2;
            }
            if (current.compareTo(node) < 0) break;
            list.set(index, node);
            index = j;
            j = (index << 1) + 1;
        }
        list.set(index, current);
        return index != i;
    }

    @Override
    public final boolean isCollection() {
        return false;
    }
}

