/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.utils.cache;

import com.kingdee.cbos.process.vm.utils.cache.Cache;
import com.kingdee.cbos.process.vm.utils.cache.CacheException;
import com.kingdee.cbos.process.vm.utils.cache.CacheManager;
import com.kingdee.cbos.process.vm.utils.cache.DoubleLinkedList;
import com.kingdee.cbos.process.vm.utils.cache.DoubleLinkedNode;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class LocalCache<K, V>
implements Cache<K, V> {
    private int hitted;
    private int visited;
    private HashMap<K, Node<K, V>> map;
    private DoubleLinkedList<Node<K, V>> list;
    private int capacity;
    private String name;
    private long timeout;

    public LocalCache(Class<?> ownerClass, int capacity) {
        this(ownerClass, capacity, 0);
    }

    public LocalCache(Class<?> ownerClass, int capacity, int timeout) {
        this(ownerClass.getName(), capacity, timeout);
    }

    public LocalCache(String name, int capacity, int timeout) {
        if (capacity <= 0) {
            throw new RuntimeException("\u975e\u6cd5\u53c2\u6570\uff0c CAHCE\u5bb9\u91cf\u4e0d\u53ef\u5c0f\u4e8e0!");
        }
        this.capacity = capacity;
        this.map = new HashMap(capacity * 2);
        this.list = new DoubleLinkedList(new Node());
        this.name = name;
        this.timeout = (long)timeout * 1000L;
        this.hitted = 0;
        this.visited = 1;
        CacheManager.registerCache(this);
    }

    public synchronized int getVisited() {
        return this.visited;
    }

    public int getHitted() {
        return this.hitted;
    }

    public synchronized double hittedRate() {
        return (double)this.hitted / (double)this.visited;
    }

    public int getTimeout() {
        return (int)(this.timeout / 1000L);
    }

    private boolean isFull() {
        if (this.map == null) {
            throw new CacheException.CacheDestroyedException(this.name);
        }
        return this.map.size() >= this.capacity;
    }

    private boolean isEmpty() {
        return this.map.size() == 0;
    }

    @Override
    public synchronized V put(K key, V obj) {
        if (this.map == null) {
            throw new CacheException.CacheDestroyedException(this.name);
        }
        Node<K, V> node = this.map.get(key);
        V discard = null;
        if (node != null) {
            discard = this.discard(node);
        } else if (this.isFull()) {
            node = this.list.first();
            discard = this.discard(node);
        } else {
            node = new Node();
        }
        node.key = key;
        node.obj = new SoftReference<V>(obj);
        if (this.timeout > 0L) {
            node.time = System.currentTimeMillis();
        }
        this.list.push(node);
        this.map.put(node.key, node);
        return discard;
    }

    @Override
    public synchronized int size() {
        if (this.map == null) {
            throw new CacheException.CacheDestroyedException(this.name);
        }
        return this.map.size();
    }

    @Override
    public synchronized V get(K key) {
        V v;
        ++this.visited;
        if (this.visited == 32768) {
            this.visited >>= 1;
            this.hitted >>= 1;
        }
        if ((v = this.innerGet(key)) != null) {
            ++this.hitted;
        }
        return v;
    }

    private V innerGet(K key) {
        Object v;
        if (this.map == null) {
            throw new CacheException.CacheDestroyedException(this.name);
        }
        Node<K, V> node = this.map.get(key);
        if (node == null) {
            return null;
        }
        this.list.poll(node);
        this.list.push(node);
        if (this.timeout > 0L) {
            node.time = System.currentTimeMillis();
        }
        if ((v = node.obj.get()) == null) {
            this.discard(node);
        }
        return v;
    }

    @Override
    public synchronized V remove(K key) {
        Node<K, V> node = this.map.get(key);
        if (node == null) {
            return null;
        }
        return this.discard(node);
    }

    private V discard(Node<K, V> node) {
        Object v = node.obj.get();
        this.list.poll(node);
        this.map.remove(node.key);
        node.key = null;
        node.obj.clear();
        node.obj = null;
        return v;
    }

    public synchronized boolean shrink() {
        if (this.timeout <= 0L) {
            return false;
        }
        long deadline = System.currentTimeMillis() - this.timeout;
        boolean discarded = false;
        while (!this.isEmpty()) {
            Node<K, V> node = this.list.first();
            if (node.time > deadline) break;
            this.discard(node);
            discarded = true;
        }
        return discarded;
    }

    public synchronized boolean extend(int inc) {
        if (this.capacity + inc <= 10) {
            return false;
        }
        this.capacity += inc;
        return true;
    }

    @Override
    public synchronized void clear() {
        this.list.clear();
        this.map.clear();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public synchronized boolean exists(K key) {
        return this.map.containsKey(key);
    }

    public synchronized List<K> keys() {
        ArrayList<K> tmp = new ArrayList<K>(this.size());
        tmp.addAll(this.map.keySet());
        return tmp;
    }

    private static class Node<K, V>
    extends DoubleLinkedNode<Node<K, V>> {
        private static final long serialVersionUID = -7339321303974028670L;
        transient SoftReference<V> obj;
        transient K key;
        transient long time;

        private Node() {
        }
    }
}

