/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.utils.cache;

import com.kingdee.cbos.process.vm.utils.cache.CacheListener;
import com.kingdee.cbos.process.vm.utils.cache.GroupCache;
import com.kingdee.cbos.process.vm.utils.group.MessageServer;
import com.kingdee.cbos.process.vm.utils.group.MessageService;
import java.net.SocketAddress;
import org.apache.log4j.Logger;

public class MCastListener
implements CacheListener {
    private static Logger log = Logger.getLogger(MCastListener.class);

    public MCastListener() {
        this.init();
    }

    private void init() {
        try {
            MessageServer.init();
            MessageServer.register("CACHE_EXPIRE", new CacheExpireSvc());
            MessageServer.register("CACHE_CLEAR", new CacheClearSvc());
        }
        catch (RuntimeException t) {
            t.printStackTrace();
            log.error((Object)"Erro when init multicast group", (Throwable)t);
            throw t;
        }
    }

    @Override
    public void put(String namespace, String key, Object value) {
    }

    @Override
    public void get(String namespace, String key) {
    }

    @Override
    public void remove(String namespace, String key) {
        MessageServer.send("CACHE_EXPIRE", namespace + ":" + key);
    }

    @Override
    public void clear(String namespace) {
        MessageServer.send("CACHE_CLEAR", namespace);
    }

    private static class CacheExpireSvc
    implements MessageService {
        private static final String COMMAND = "CACHE_EXPIRE";

        private CacheExpireSvc() {
        }

        @Override
        public void handle(SocketAddress host, String serverId, String msgId, String message) {
            if (MessageServer.getServerId().equals(serverId)) {
                return;
            }
            String[] data = CacheExpireSvc.parseMessage(message);
            String namespace = data[0];
            GroupCache<?> cache = GroupCache.getCache(namespace);
            if (cache != null) {
                String key = data[1];
                cache.local.remove(key);
            }
        }

        private static String[] parseMessage(String message) {
            String[] data = message.split(":", 2);
            if (data.length != 2) {
                throw new IllegalArgumentException("\u975e\u6cd5\u6d88\u606f\uff01");
            }
            return data;
        }
    }

    private static class CacheClearSvc
    implements MessageService {
        private static final String COMMAND = "CACHE_CLEAR";

        private CacheClearSvc() {
        }

        @Override
        public void handle(SocketAddress host, String serverId, String msgId, String message) {
            if (MessageServer.getServerId().equals(serverId)) {
                return;
            }
            String namespace = message;
            GroupCache<?> cache = GroupCache.getCache(namespace);
            if (cache != null) {
                cache.local.clear();
            }
        }
    }
}

