/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.cache;

import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractFileCache {
    protected String _key;
    private String _fileName;
    private QingTempFileType _fileType;

    public AbstractFileCache(String key, QingTempFileType fileType) {
        this._key = key;
        this._fileType = fileType;
        this._fileName = QingSessionUtil.get((String)this._key);
    }

    public final void delete() {
        if (this.exists()) {
            FileFactory.newFileUpdater(null, (AbstractQingFileType)this._fileType, (String)this._fileName).delete();
        }
        QingSessionUtil.remove((String)this._key);
    }

    public final boolean exists() {
        if (this._fileName == null) {
            return false;
        }
        return FileFactory.newFileVisitor((AbstractQingFileType)this._fileType, (String)this._fileName).exists();
    }

    public final void load() throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException("FileCache key:" + this._key);
        }
        QingInputStream inputStream = null;
        try {
            inputStream = this.getInputStream();
            this.read((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
    }

    public final void save() throws IOException {
        IQingFile tempDataFile = FileFactory.newTempFile((QingTempFileType)this._fileType);
        tempDataFile.write(new IWriteCall(){

            public void call(OutputStream outputStream) throws IOException {
                AbstractFileCache.this.write(outputStream);
            }
        }, true);
        this._fileName = tempDataFile.getName();
        QingSessionUtil.set((String)this._key, (String)tempDataFile.getName());
    }

    protected final QingInputStream getInputStream() throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException("FileCache key:" + this._key);
        }
        return FileFactory.newFileVisitor((AbstractQingFileType)this._fileType, (String)this._fileName).getInputStream();
    }

    protected final long getInputStreamLength() throws IOException {
        if (!this.exists()) {
            return 0L;
        }
        return FileFactory.newFileVisitor((AbstractQingFileType)this._fileType, (String)this._fileName).getLength();
    }

    protected abstract void read(InputStream var1) throws IOException;

    protected abstract void write(OutputStream var1) throws IOException;
}

