/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.reference;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.AbstractSwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.dashboard.reference.dao.ExtReportDao;
import com.kingdee.bos.qing.util.JsonUtil;
import java.sql.SQLException;
import java.util.Map;

public class ExtreportAppSwitchPathAndIdHandler
extends AbstractSwitchPathAndIdHandler {
    private ExtReportDao extReportDao;

    public ExtreportAppSwitchPathAndIdHandler(QingContext context, ITransactionManagement tx, IDBExcuter dbExcuter) {
        super(context, tx, dbExcuter);
    }

    protected ExtReportDao getExtReportDao() {
        if (this.extReportDao == null) {
            this.extReportDao = new ExtReportDao(this.dbExcuter);
        }
        return this.extReportDao;
    }

    @Override
    public String switchRefPathToId(String refPath, String name, String userId) throws AbstractQingIntegratedException, SQLException {
        Map<String, String> extreportGroupInfoMap = this.getExtReportDao().loadExtReportGroupByGroupName(refPath, userId);
        if (extreportGroupInfoMap != null) {
            String groupId = extreportGroupInfoMap.get("groupId");
            return this.getExtReportDao().loadExtReportIdByNameAndGroupID(name, groupId, userId);
        }
        return null;
    }

    @Override
    public String switchRefIdToPath(String refToId, String userId) throws AbstractQingIntegratedException, SQLException {
        Map<String, String> pathMap = this.getExtReportDao().loadExtreportPathById(refToId);
        if (pathMap != null) {
            String nameSpace = NameSpace.user.toPersistance();
            PathModel pathModel = new PathModel();
            pathModel.setNameSpace(nameSpace);
            pathModel.setGroupName(pathMap.get("groupName"));
            pathModel.setName(pathMap.get("extreportName"));
            return JsonUtil.encodeToString((Object)pathModel);
        }
        return null;
    }

    @Override
    public void replacePersistentPathToId(String refPath, String refId, String userId) throws SQLException, AbstractQingIntegratedException {
        this.updateRefPathToId(RefTypeEnum.qingreport, refPath, refId, userId);
    }

    @Override
    public void replacePersistentIdToPath(String refPath, String refToId, String userId) throws SQLException, AbstractQingIntegratedException {
        this.updateRefIdToPath(RefTypeEnum.qingreport, refPath, refToId, userId);
    }

    @Override
    public boolean RefIsPreset(String refToId) throws AbstractQingIntegratedException, SQLException {
        return false;
    }

    @Override
    public String switchRefPathToId(String fullPath, String userId) throws AbstractQingIntegratedException, SQLException {
        PathModel pathModel = (PathModel)JsonUtil.decodeFromString((String)fullPath, PathModel.class);
        Map<String, String> extreportGroupInfoMap = this.getExtReportDao().loadExtReportGroupByGroupName(pathModel.getGroupName(), userId);
        if (extreportGroupInfoMap != null) {
            String groupId = extreportGroupInfoMap.get("groupId");
            return this.getExtReportDao().loadExtReportIdByNameAndGroupID(pathModel.getName(), groupId, userId);
        }
        return null;
    }

    @Override
    public String createEmptyPath() {
        return null;
    }
}

