/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.macro.sql.model.condition;

import com.kingdee.bos.qing.data.domain.macro.sql.model.condition.AbstractConditionSegment;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BetweenConditionSegment
extends AbstractConditionSegment {
    private static final String conditionRegex = "(.+?)( (?i)between )(.+?)( (?i)and )(.+?)( ENDOFSQL)";
    private static Pattern conditionPattern = Pattern.compile("(.+?)( (?i)between )(.+?)( (?i)and )(.+?)( ENDOFSQL)");
    private String from;
    private String to;
    private String column;

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public BetweenConditionSegment copy() {
        BetweenConditionSegment copy = new BetweenConditionSegment();
        copy.setColumn(this.column);
        copy.setFrom(this.from);
        copy.setTo(this.to);
        copy.setRawSQL(this.rawSQL);
        return copy;
    }

    @Override
    public String toSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.column);
        sb.append(" between ");
        sb.append(this.from);
        sb.append(" and ");
        sb.append(this.to);
        return sb.toString();
    }

    @Override
    protected void protectedFromSQL(String sql) {
        int groupCount;
        Matcher matcher = conditionPattern.matcher(sql);
        if (matcher.find() && (groupCount = matcher.groupCount()) > 5) {
            this.column = matcher.group(1);
            this.from = matcher.group(3);
            this.to = matcher.group(5);
        }
    }

    public static boolean isMatched(String sql) {
        Matcher matcher = conditionPattern.matcher(BetweenConditionSegment.addEndMark(sql));
        return matcher.find();
    }

    @Override
    public boolean isExpected() {
        if (this.column == null) {
            return false;
        }
        if (this.column.trim().contains(" ")) {
            return false;
        }
        if (this.from == null) {
            return false;
        }
        if (this.from.trim().contains(" ")) {
            return false;
        }
        if (this.to == null) {
            return false;
        }
        return !this.to.trim().contains(" ");
    }
}

