/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.macro.sql.model.condition;

import com.kingdee.bos.qing.data.domain.macro.sql.model.condition.AbstractConditionSegment;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BinaryConditionSegment
extends AbstractConditionSegment {
    private static final String conditionRegex = "(.+?)(>\\s*=|<\\s*=| (?i)like |=|>|<)(.+?)( ENDOFSQL)";
    private static Pattern conditionPattern = Pattern.compile("(.+?)(>\\s*=|<\\s*=| (?i)like |=|>|<)(.+?)( ENDOFSQL)");
    protected String left;
    protected String right;
    protected String notation;

    public static boolean isMatched(String sql) {
        Matcher matcher = conditionPattern.matcher(BinaryConditionSegment.addEndMark(sql));
        return matcher.find();
    }

    public String getLeft() {
        return this.left;
    }

    public void setLeft(String value) {
        this.left = value;
    }

    public String getRight() {
        return this.right;
    }

    public void setRight(String right) {
        this.right = right;
    }

    public String getNotation() {
        return this.notation;
    }

    public void setNotation(String notation) {
        this.notation = notation;
    }

    public BinaryConditionSegment copy() {
        BinaryConditionSegment copy = new BinaryConditionSegment();
        copy.setLeft(this.left);
        copy.setRight(this.right);
        copy.setNotation(this.notation);
        copy.setRawSQL(this.rawSQL);
        return copy;
    }

    @Override
    public String toSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.left);
        sb.append(this.notation);
        sb.append(this.right);
        return sb.toString();
    }

    @Override
    protected void protectedFromSQL(String sql) {
        Matcher matcher = conditionPattern.matcher(sql);
        while (matcher.find()) {
            this.left = matcher.group(1);
            this.notation = matcher.group(2);
            this.right = matcher.group(3);
        }
    }

    @Override
    public boolean isExpected() {
        if (this.left == null) {
            return false;
        }
        if (this.left.trim().contains(" ")) {
            return false;
        }
        if (this.right == null) {
            return false;
        }
        return !this.right.trim().contains(" ");
    }
}

