/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.macro.sql.model.condition;

import com.kingdee.bos.qing.data.domain.macro.sql.model.condition.BinaryConditionSegment;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NegativeBinaryConditionSegment
extends BinaryConditionSegment {
    private static final String conditionRegex = "(.+?)(<\\s*>|!\\s*=)(.+?)( ENDOFSQL)";
    private static Pattern conditionPattern = Pattern.compile("(.+?)(<\\s*>|!\\s*=)(.+?)( ENDOFSQL)");

    @Override
    public boolean isOrConnective() {
        return false;
    }

    public static boolean isMatched(String sql) {
        Matcher matcher = conditionPattern.matcher(NegativeBinaryConditionSegment.addEndMark(sql));
        return matcher.find();
    }

    @Override
    public NegativeBinaryConditionSegment copy() {
        NegativeBinaryConditionSegment copy = new NegativeBinaryConditionSegment();
        copy.setLeft(this.left);
        copy.setRight(this.right);
        copy.setNotation(this.notation);
        copy.setRawSQL(this.rawSQL);
        return copy;
    }

    @Override
    protected void protectedFromSQL(String sql) {
        Matcher matcher = conditionPattern.matcher(sql);
        while (matcher.find()) {
            this.left = matcher.group(1);
            this.notation = matcher.group(2);
            this.right = matcher.group(3);
        }
    }
}

