/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.dataconvert.impl;

import com.kingdee.bos.qing.data.domain.source.db.dataconvert.impl.DefaultResultSetDataConvertor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class HiveResultSetDataConvertor
extends DefaultResultSetDataConvertor {
    @Override
    protected Object getNumber(ResultSet rs, int columnIndex) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int type = meta.getColumnType(columnIndex);
        if (type == 6) {
            float value = rs.getFloat(columnIndex);
            BigDecimal bigDecimal = BigDecimal.valueOf(value);
            if (bigDecimal.scale() > 15) {
                bigDecimal = bigDecimal.setScale(15, RoundingMode.HALF_UP);
            }
            return bigDecimal;
        }
        if (type == 8) {
            double value = rs.getDouble(columnIndex);
            BigDecimal bigDecimal = BigDecimal.valueOf(value);
            if (bigDecimal.scale() > 15) {
                bigDecimal = bigDecimal.setScale(15, RoundingMode.HALF_UP);
            }
            return bigDecimal;
        }
        return super.getNumber(rs, columnIndex);
    }
}

