/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.dataconvert.IResultSetDataConvertor;
import com.kingdee.bos.qing.data.domain.source.db.dataconvert.impl.HiveResultSetDataConvertor;
import com.kingdee.bos.qing.data.domain.source.db.util.DataTypeUtil;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.runtime.Field;
import com.kingdee.bos.qing.data.model.runtime.Table;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.util.CloseUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;

public class AbstractHiveAndSparkSQLSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    private static final String URL_TEMPLATE = "jdbc:hive2://%s:%s/%s";
    private static final String URL_CUSTOM_TEMPLATE = "jdbc:hive2://%s:%s/%s;useUnicode=true;characterEncoding=%s;serverTimezone=%s;";
    private static final String DRIVER = "org.apache.hive.jdbc.HiveDriver";

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        this.queryTableLeafNodes(root, dataBase, "show tables", null);
        return root;
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        return this.queryDBNames((DBSource)source, "show databases", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Table getTable(Connection conn, DBSource dbSource, String tableAssociateName) throws SQLException {
        ResultSet crs = null;
        PreparedStatement ps = null;
        Table table = null;
        try {
            String columnType;
            String columnName;
            table = new Table();
            table.setName(tableAssociateName);
            table.setSource(dbSource.getName());
            String sql = String.format("describe %s", tableAssociateName);
            ps = conn.prepareStatement(sql);
            crs = ps.executeQuery();
            HashSet<String> fieldList = new HashSet<String>();
            while (crs.next() && !"".equals(columnName = crs.getString(1)) && !columnName.contains("#") && fieldList.add(columnName) && (columnType = crs.getString(2)) != null) {
                Field field = new Field();
                field.setName(columnName);
                DataType dataType = DataTypeUtil.parseHiveDataType(columnType);
                if (dataType == null) continue;
                field.setDataType(dataType);
                table.addField(field);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close(ps);
            CloseUtil.close(crs);
            throw throwable;
        }
        CloseUtil.close((Statement)ps);
        CloseUtil.close((ResultSet)crs);
        return table;
    }

    @Override
    protected void setConnectionAttribute(DBSource dataBase, Connection connection) throws SQLException {
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    @Override
    protected IResultSetDataConvertor getDataConvertor() {
        return new HiveResultSetDataConvertor();
    }

    @Override
    public String getLeftDelimiter() {
        return "`";
    }

    @Override
    public String getRightDelimiter() {
        return "`";
    }

    @Override
    public String getJDBCUrl(DBSource dataBase) {
        String charset = dataBase.getAdvanceSetting().getCharset();
        String timezone = dataBase.getAdvanceSetting().getTimezone();
        String otherSetting = dataBase.getAdvanceSetting().getOtherSetting();
        if (charset == null && timezone == null && otherSetting == null) {
            return String.format(URL_TEMPLATE, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName());
        }
        String customUrl = String.format(URL_CUSTOM_TEMPLATE, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName(), charset, timezone);
        if (otherSetting != null) {
            customUrl = customUrl + otherSetting;
        }
        return customUrl;
    }

    @Override
    public String getDriverClassName() {
        return DRIVER;
    }

    @Override
    public void setQueryTimeout(QingContext qingContext, PreparedStatement ps) throws SQLException {
    }
}

