/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.dataconvert.IResultSetDataConvertor;
import com.kingdee.bos.qing.data.domain.source.db.dataconvert.impl.AccessResultSetDataConvertor;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.exception.db.AbstractDBConnectException;
import com.kingdee.bos.qing.data.exception.db.DBConnectionOpenException;
import com.kingdee.bos.qing.data.exception.db.DBExcuseException;
import com.kingdee.bos.qing.data.exception.db.DBFileNotFoundException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.data.model.vo.LeafNode;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AccessSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    public static final String URL_TEMPLATE = "jdbc:ucanaccess://%s;jackcessOpener=com.kingdee.bos.qing.data.domain.source.db.impl.AccessHandler";
    public static final String DRIVER = "net.ucanaccess.jdbc.UcanaccessDriver";
    private static Set<String> ignoreTBs = new HashSet<String>();

    private AccessSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new AccessSourceJDBCAdapter();
    }

    public boolean canEntityChangeOnline() {
        return false;
    }

    @Override
    public String getLeftDelimiter() {
        return "[";
    }

    @Override
    public String getRightDelimiter() {
        return "]";
    }

    @Override
    protected IResultSetDataConvertor getDataConvertor() {
        return new AccessResultSetDataConvertor();
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBConnectException, DBExcuseException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        Connection conn = this.getConnection(dataBase);
        Statement ps = null;
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getTables(null, null, "%", null);
            while (rs.next()) {
                String name = rs.getString(3);
                if (ignoreTBs.contains(name)) continue;
                LeafNode leafNode = new LeafNode();
                leafNode.setName(name);
                leafNode.setDisplayName(name);
                leafNode.setType("table");
                root.addChild(leafNode);
            }
        }
        catch (SQLException ex) {
            try {
                throw new DBExcuseException(ex);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Connection)conn, ps, rs);
                throw throwable;
            }
        }
        CloseUtil.close((Connection)conn, ps, (ResultSet)rs);
        return root;
    }

    @Override
    public String getJDBCUrl(DBSource dataBase) throws AbstractDBConnectException {
        IQingFileVisitor qingFile = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS, (String)dataBase.getDbAddress());
        if (!qingFile.exists()) {
            qingFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)dataBase.getDbAddress());
        }
        String fullPath = null;
        try {
            fullPath = qingFile.getLocalFullPath();
        }
        catch (FileNotFoundException e) {
            throw new DBFileNotFoundException(e);
        }
        catch (IOException e) {
            throw new DBConnectionOpenException((Throwable)e, "load Access File failed.");
        }
        return String.format(URL_TEMPLATE, fullPath);
    }

    @Override
    public String getDriverClassName() {
        return DRIVER;
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("getDatabaseList not support.");
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    static {
        ignoreTBs.add("MSysAccessStorage");
        ignoreTBs.add("MSysACEs");
        ignoreTBs.add("MSysComplexColumns");
        ignoreTBs.add("MSysNameMap");
        ignoreTBs.add("MSysNavPaneGroupCategories");
        ignoreTBs.add("MSysNavPaneGroups");
        ignoreTBs.add("MSysNavPaneGroupToObjects");
        ignoreTBs.add("MSysNavPaneObjectIDs");
        ignoreTBs.add("MSysObjects");
        ignoreTBs.add("MSysQueries");
        ignoreTBs.add("MSysRelationships");
        ignoreTBs.add("MSysResources");
    }
}

