/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class DB2SourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    public static final String URL_TEMPLATE = "jdbc:db2://%s:%s/%s:currentSchema=%s;retrieveMessagesFromServerOnGetMessage=true;";
    public static final String URL_CUSTOM_TEMPLATE = "jdbc:db2://%s:%s/%s:currentSchema=%s;useUnicode=true&characterEncoding=%s;useTimezone=true&serverTimezone=%s;";
    public static final String DRIVER = "com.ibm.db2.jcc.DB2Driver";

    private DB2SourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new DB2SourceJDBCAdapter();
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        DBSource dbSource = (DBSource)source;
        String sql = "select SCHEMANAME from syscat.schemata";
        return this.queryDBNames(dbSource, sql, null, null);
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String sql = "select name from sysibm.systables where ( type='T' or type='V' ) and creator = ? ";
        this.queryTableLeafNodes(root, dataBase, sql, new Object[]{dataBase.getSchema()});
        return root;
    }

    @Override
    public String getJDBCUrl(DBSource dataBase) {
        String charset = dataBase.getAdvanceSetting().getCharset();
        String timezone = dataBase.getAdvanceSetting().getTimezone();
        String otherSetting = dataBase.getAdvanceSetting().getOtherSetting();
        if (charset == null && timezone == null && otherSetting == null) {
            return String.format(URL_TEMPLATE, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName(), dataBase.getSchema());
        }
        String urlTemplate = URL_CUSTOM_TEMPLATE;
        if (otherSetting != null) {
            urlTemplate = urlTemplate + otherSetting;
        }
        return String.format(urlTemplate, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName(), dataBase.getSchema(), charset, timezone);
    }

    @Override
    public String getDriverClassName() {
        return DRIVER;
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String sql = "SELECT PROCNAME AS NAME FROM SYSCAT.PROCEDURES WHERE DEFINER != 'SYSIBM' ORDER BY PROCNAME";
        this.queryLeafNodes(root, dataBase, sql, null, "storedProcedure");
        DB2SourceJDBCAdapter.checkStoredProcedureNameNotRepeat(root);
        return root;
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractDBSourceException {
        String sql = "SELECT PARMNAME,TYPENAME,PARM_MODE FROM SYSIBM.SYSPROCPARMS WHERE PROCNAME = ? ORDER BY ORDINAL";
        DBSource dataBase = (DBSource)source;
        return this.queryStoredProcedureParams(sql, dataBase, new Object[]{storedProcedureName});
    }

    @Override
    protected void setConnectionAttribute(DBSource dataBase, Connection connection) throws SQLException {
        connection.setReadOnly(true);
        connection.setAutoCommit(true);
    }

    @Override
    public String getSelectVersionSql() {
        return "SELECT SERVICE_LEVEL AS VERSION FROM TABLE (SYSPROC.ENV_GET_INST_INFO())";
    }
}

