/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class DMSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    public static final String URL_TEMPLATE = "jdbc:dm://%s:%s/%s?useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull";
    public static final String DRIVER = "dm.jdbc.driver.DmDriver";

    private DMSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new DMSourceJDBCAdapter();
    }

    @Override
    public String getLeftDelimiter() {
        return "\"";
    }

    @Override
    public String getRightDelimiter() {
        return "\"";
    }

    @Override
    protected String getSPCmdFormate(DBSource dbSource) {
        return "{call \"" + dbSource.getDbName() + "\".\"%s\"( %s )}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setConnectionAttribute(DBSource dataBase, Connection connection) throws SQLException {
        connection.setReadOnly(false);
        connection.setAutoCommit(false);
        String dbName = StringUtils.isEmpty((CharSequence)dataBase.getDbName()) ? dataBase.getUserName() : dataBase.getDbName();
        String sql = String.format("ALTER SESSION SET CURRENT_SCHEMA = %s", dbName);
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(sql);
            ps.execute();
        }
        finally {
            CloseUtil.close((Statement)ps);
        }
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        if (StringUtils.isNotBlank((CharSequence)dataBase.getDbName())) {
            String sql = "SELECT OBJECT_NAME AS TABLE_NAME  FROM ALL_OBJECTS A WHERE OWNER = ? AND OBJECT_TYPE ='TABLE' AND TEMPORARY != 'Y'";
            this.queryTableLeafNodes(root, dataBase, sql, new Object[]{dataBase.getDbName()});
        } else {
            String tableSql = "SELECT TABLE_NAME FROM USER_TABLES  ORDER BY TABLE_NAME";
            this.queryTableLeafNodes(root, dataBase, tableSql, null);
        }
        return root;
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        DBSource dataBase = (DBSource)source;
        String sql = "SELECT DISTINCT OBJECT_NAME TABLE_SCHEMA FROM ALL_OBJECTS WHERE OBJECT_TYPE = 'SCH' AND OWNER = ?";
        return this.queryDBNames((DBSource)source, sql, new Object[]{dataBase.getUserName().toUpperCase()}, null);
    }

    @Override
    public String getJDBCUrl(DBSource dataBase) {
        return String.format(URL_TEMPLATE, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName());
    }

    @Override
    public String getDriverClassName() {
        return DRIVER;
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String sql = "SELECT DISTINCT OBJECT_NAME AS NAME FROM ALL_OBJECTS A WHERE OWNER = ? AND OBJECT_TYPE ='PROCEDURE' AND GENERATED != 'Y'";
        this.queryLeafNodes(root, dataBase, sql, new Object[]{dataBase.getDbName()}, "storedProcedure");
        return root;
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractDBSourceException {
        DBSource dMDbSouce = (DBSource)source;
        String sql = "SELECT B.NAME AS PARAMETERNAME,B.TYPE$ AS PARAMETERTYPE,B.INFO1 AS PARAMETERISOUTPUT FROM ALL_OBJECTS A , SYSCOLUMNS B WHERE A.OBJECT_ID = B.ID AND A.OBJECT_NAME = ? AND A.OBJECT_TYPE ='PROCEDURE' AND A.OWNER = ?";
        return this.queryStoredProcedureParams(sql, dMDbSouce, new Object[]{storedProcedureName, dMDbSouce.getDbName()});
    }

    @Override
    public String wrapTableAssociateName(DBSource dbSource, String tableAssociateName) {
        if (StringUtils.isNotBlank((CharSequence)dbSource.getDbName())) {
            return dbSource.getDbName() + "\".\"" + tableAssociateName;
        }
        return tableAssociateName;
    }
}

