/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.util.CloseUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GaussDB100SourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    public static final String URL_TEMPLATE = "jdbc:zenith:@%s:%s?loginTimeout=10";
    public static final String DRIVER = "com.huawei.gauss.jdbc.ZenithDriver";
    private static Set<String> ignoreDBs = new HashSet<String>();

    private GaussDB100SourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new GaussDB100SourceJDBCAdapter();
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        DBSource dbSource = (DBSource)source;
        String sql = "SELECT USERNAME FROM USER_USERS";
        return this.queryDBNames(dbSource, sql, null, ignoreDBs);
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String tableSql = "SELECT TABLE_NAME FROM USER_TABLES ORDER BY TABLE_NAME";
        this.queryTableLeafNodes(root, dataBase, tableSql, new Object[0]);
        return root;
    }

    @Override
    public String getJDBCUrl(DBSource dbSource) {
        return String.format(URL_TEMPLATE, dbSource.getDbAddress(), dbSource.getDbPort());
    }

    @Override
    public String getDriverClassName() {
        return DRIVER;
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        DBSource dbSource = (DBSource)source;
        FolderNode root = new FolderNode();
        String sql = "SELECT OBJECT_NAME FROM USER_OBJECTS WHERE OBJECT_TYPE='PROCEDURE' ORDER BY OBJECT_NAME";
        this.queryLeafNodes(root, dbSource, sql, new Object[0], "storedProcedure");
        return root;
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractDBSourceException {
        DBSource dbSource = (DBSource)source;
        String sql = "SELECT PARAMETER.ARGUMENT_NAME AS PARAMETERNAME, PARAMETER.DATA_TYPE AS PARAMETERTYPE, PARAMETER.IN_OUT AS PARAMETERISOUTPUT FROM USER_ARGUMENTS PARAMETER WHERE PARAMETER.OBJECT_NAME = ? ORDER BY PARAMETER.POSITION";
        return this.queryStoredProcedureParams(sql, dbSource, new Object[]{storedProcedureName});
    }

    @Override
    public String wrapTableAssociateName(DBSource dbSource, String tableAssociateName) {
        return dbSource.getDbName() + "." + tableAssociateName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setConnectionAttribute(DBSource dataBase, Connection connection) throws SQLException {
        super.setConnectionAttribute(dataBase, connection);
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement("ALTER SESSION SET CURRENT_SCHEMA=" + dataBase.getDbName());
            ps.execute();
        }
        catch (Throwable throwable) {
            CloseUtil.close(ps);
            throw throwable;
        }
        CloseUtil.close((Statement)ps);
    }

    static {
        ignoreDBs.add("SYS");
        ignoreDBs.add("SYSTEM");
        ignoreDBs.add("DBA_USER");
        ignoreDBs.add("PUBLIC");
    }
}

