/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HANASourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    public static final String CONN_URL_TEMPLATE = "jdbc:sap://%s:%s/?databaseName=%s";
    public static final String CONN_URL_WITHSCHEMA_TEMPLATE = "jdbc:sap://%s:%s/?databaseName=%s&currentSchema=%s";
    public static final String DRIVER = "com.sap.db.jdbc.Driver";
    private static Set<String> ignoreDBs = new HashSet<String>();

    private HANASourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new HANASourceJDBCAdapter();
    }

    @Override
    protected String getJDBCUrl(DBSource dataBase) {
        if (dataBase.getSchema() == null) {
            return String.format(CONN_URL_TEMPLATE, dataBase.getDbAddress(), dataBase.getDbPort(), this.emptyNameIfNull(dataBase.getDbName()));
        }
        return String.format(CONN_URL_WITHSCHEMA_TEMPLATE, dataBase.getDbAddress(), dataBase.getDbPort(), this.emptyNameIfNull(dataBase.getDbName()), dataBase.getSchema());
    }

    private String emptyNameIfNull(String value) {
        return null == value ? "" : value;
    }

    @Override
    protected String getDriverClassName() {
        return DRIVER;
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        DBSource dataBase = (DBSource)source;
        FolderNode root = new FolderNode();
        String sql = "SELECT TABLE_NAME FROM TABLES WHERE SCHEMA_NAME=?";
        this.queryTableLeafNodes(root, dataBase, sql, new Object[]{dataBase.getSchema()});
        return root;
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        String sql = "SELECT SCHEMA_NAME FROM SCHEMAS WHERE SCHEMA_OWNER=?";
        DBSource dbSource = (DBSource)source;
        return this.queryDBNames(dbSource, sql, new Object[]{dbSource.getUserName().toUpperCase()}, ignoreDBs);
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    static {
        ignoreDBs.add("SYS");
        ignoreDBs.add("SYSTEM");
        ignoreDBs.add("_SYS_SECURITY");
        ignoreDBs.add("_SYS_AUDIT");
    }
}

