/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.exception.db.DBExcuseException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.data.model.vo.LeafNode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class KylinSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    private static final String URL_TEMPLATE = "jdbc:kylin://%s:%s/%s";
    private static final String DRIVER = "org.apache.kylin.jdbc.Driver";

    private KylinSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new KylinSourceJDBCAdapter();
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        this.queryTableLeafNodes(root, dataBase, "show tables", null);
        return root;
    }

    @Override
    protected void queryLeafNodes(FolderNode root, DBSource dataBase, String tableQuerySql, Object[] params, String leafNodeType) throws AbstractDBSourceException {
        try {
            ResultSet resultSet = this.getConnection(dataBase).getMetaData().getTables(null, dataBase.getSchema(), null, new String[]{"TABLE"});
            ArrayList<LeafNode> rows = new ArrayList<LeafNode>();
            while (resultSet.next()) {
                String name = resultSet.getString("TABLE_NAME");
                LeafNode leafNode = new LeafNode();
                leafNode.setName(name);
                leafNode.setDisplayName(name);
                leafNode.setType(leafNodeType);
                rows.add(leafNode);
            }
            for (LeafNode leafNode : rows) {
                root.addChild(leafNode);
            }
        }
        catch (SQLException e) {
            throw AbstractDBSourceException.parseSQLException(e);
        }
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        DBSource dataBase = (DBSource)source;
        ArrayList<String> list = new ArrayList<String>();
        try {
            ResultSet schemas = this.getConnection(dataBase).getMetaData().getSchemas();
            while (schemas.next()) {
                list.add(schemas.getString(1));
            }
        }
        catch (SQLException e) {
            throw new DBExcuseException(e);
        }
        return list;
    }

    @Override
    protected void setConnectionAttribute(DBSource dataBase, Connection conn) throws SQLException {
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    @Override
    public String getLeftDelimiter() {
        return "";
    }

    @Override
    public String getRightDelimiter() {
        return "";
    }

    @Override
    public String getJDBCUrl(DBSource dataBase) {
        return String.format(URL_TEMPLATE, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName());
    }

    @Override
    public String getDriverClassName() {
        return DRIVER;
    }

    @Override
    public void setQueryTimeout(QingContext qingContext, PreparedStatement ps) throws SQLException {
    }
}

