/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.JDBCConnectionPool;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.db.AbstractDBConnectException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.designtime.source.OpenLookengDBSource;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class OpenLookengSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    private OpenLookengDBSource openLookengDBSource;

    public static AbstractDBSourceJDBCAdapter newInstance(AbstractSource source) {
        return new OpenLookengSourceJDBCAdapter(source);
    }

    public OpenLookengSourceJDBCAdapter(AbstractSource source) {
        this.openLookengDBSource = (OpenLookengDBSource)source;
    }

    @Override
    protected String getJDBCUrl(DBSource dataBase) throws AbstractDBConnectException {
        if (StringUtils.isBlank((CharSequence)this.openLookengDBSource.getSchema())) {
            return this.openLookengDBSource.getUrl();
        }
        return this.openLookengDBSource.getUrl() + "/" + this.openLookengDBSource.getSchema();
    }

    @Override
    protected String getDriverClassName() {
        return null;
    }

    @Override
    public Connection getConnectionImpl(DBSource dataBase) throws AbstractDBConnectException {
        Connection connection = super.getConnectionImpl(dataBase);
        if (connection instanceof JDBCConnectionPool.JDBCPooledConnection) {
            JDBCConnectionPool.JDBCPooledConnection jDBCPooledConnection = (JDBCConnectionPool.JDBCPooledConnection)connection;
        }
        return connection;
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        return null;
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    @Override
    protected JDBCConnectionPool.JDBCModel checkerDataBaseParams(DBSource dataBase) throws AbstractDBConnectException {
        String connectUrl = this.getJDBCUrl(dataBase);
        JDBCConnectionPool.JDBCModel jdbcModel = new JDBCConnectionPool.JDBCModel(null, connectUrl, null, null);
        if (this.openLookengDBSource.getProperties() != null) {
            jdbcModel.setProperties(this.openLookengDBSource.getProperties());
        }
        return jdbcModel;
    }

    @Override
    protected void setConnectionAttribute(DBSource dataBase, Connection connection) throws SQLException {
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractSourceException, AbstractQingIntegratedException {
        return null;
    }

    @Override
    public boolean isConnSupportKsql() {
        return false;
    }

    @Override
    public String getLeftDelimiter() {
        return "\"";
    }

    @Override
    public String getRightDelimiter() {
        return "\"";
    }
}

