/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.handler.ColumnListHandler;
import com.kingdee.bos.qing.data.domain.source.db.query.DBQueryRunner;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RedShiftSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    private static final String JDBC_URL = "jdbc:redshift://%s:%s/%s";
    private static Set<String> ignoreDBs = new HashSet<String>();

    private RedShiftSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new RedShiftSourceJDBCAdapter();
    }

    @Override
    protected String getJDBCUrl(DBSource dataBase) {
        return String.format(JDBC_URL, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName());
    }

    @Override
    protected String getDriverClassName() {
        return "com.amazon.redshift.jdbc42.Driver";
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String sql = "select table_name from information_schema.tables where table_schema=? and table_catalog=?";
        this.queryTableLeafNodes(root, dataBase, sql, new Object[]{dataBase.getSchema(), dataBase.getDbName()});
        return root;
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        DBSource dbSource = (DBSource)source;
        String sql = "select schema_name from information_schema.schemata where schema_owner=? and catalog_name=?";
        List<String> dbNameList = this.queryDBNames(dbSource, sql, new Object[]{dbSource.getUserName(), dbSource.getDbName()}, ignoreDBs);
        if (this.hasSchemaPrivilege(dbSource, "public", "USAGE")) {
            dbNameList.add(0, "public");
        }
        return dbNameList;
    }

    private boolean hasSchemaPrivilege(DBSource dbSource, String schemaName, String operation) {
        try {
            DBQueryRunner runnerWrap = new DBQueryRunner(this.getConnectionProvider(dbSource));
            String sql = "select has_schema_privilege(?, ?,?);";
            Object[] params = new Object[]{dbSource.getUserName(), schemaName, operation};
            List result = (List)runnerWrap.query(sql, new ColumnListHandler(1), params);
            return null == result || result.size() == 0 ? false : (Boolean)result.get(0);
        }
        catch (SQLException e) {
            LogUtil.error((String)"redshift:call method hasSchemaPrivilege error ", (Throwable)e);
            return false;
        }
    }

    @Override
    public String wrapTableAssociateName(DBSource dbSource, String tableAssociateName) {
        return dbSource.getSchema() + "." + tableAssociateName;
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    static {
        ignoreDBs.add("information_schema");
        ignoreDBs.add("pg_catalog");
        ignoreDBs.add("pg_internal");
    }
}

