/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.query;

import com.kingdee.bos.qing.common.spi.IQProfilerSupporter;
import com.kingdee.bos.qing.data.domain.source.db.query.AbstractQueryRunner;
import com.kingdee.bos.qing.data.domain.source.db.query.ResultSetHandler;
import com.kingdee.bos.qing.util.QProfilerSupporter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class QueryRunner
extends AbstractQueryRunner {
    public QueryRunner(boolean pmdKnownBroken) {
        super(pmdKnownBroken);
    }

    public <T> T query(String sql, ResultSetHandler<T> rsh, Object[] params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.query(conn, true, sql, rsh, params);
    }

    public <T> T query(String sql, ResultSetHandler<T> rsh) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.query(conn, true, sql, rsh, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T query(Connection conn, boolean closeConn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (!closeConn) throw new SQLException("Null SQL statement");
            this.close(conn);
            throw new SQLException("Null SQL statement");
        }
        if (rsh == null) {
            if (!closeConn) throw new SQLException("Null ResultSetHandler");
            this.close(conn);
            throw new SQLException("Null ResultSetHandler");
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        T result = null;
        try {
            stmt = this.prepareStatement(conn, sql);
            this.fillStatement(stmt, params);
            PreparedStatement wrapped = this.wrapPrepareStatement(sql, stmt);
            rs = this.wrap(wrapped.executeQuery());
            result = rsh.handle(rs);
            try {
                this.close(rs);
                return result;
            }
            finally {
                this.close(stmt);
                if (closeConn) {
                    this.close(conn);
                }
            }
        }
        catch (SQLException var33) {
            this.rethrow(var33, sql, params);
            return result;
        }
        finally {
            try {
                this.close(rs);
            }
            finally {
                this.close(stmt);
                if (closeConn) {
                    this.close(conn);
                }
            }
        }
    }

    protected PreparedStatement wrapPrepareStatement(String sql, PreparedStatement preparedStatement) {
        IQProfilerSupporter supporter = QProfilerSupporter.getProfilerSupporter();
        if (null != supporter) {
            return supporter.makeProxy(sql, preparedStatement);
        }
        return preparedStatement;
    }

    @Override
    protected Connection prepareConnection() throws SQLException {
        return null;
    }
}

