/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime.source;

import com.kingdee.bos.qing.data.domain.source.db.util.AESUtil;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.SourceType;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedure;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class DBSource
extends AbstractSource {
    private String name;
    private DBType dbType;
    private String dbAddress;
    private String dbPort;
    private String dbName;
    private String userName;
    private String password;
    private String schema;
    private String dbVersion;
    private String connectType;
    private List<UserSQL> userSqls;
    private List<StoredProcedure> storedProcedures;
    private DBSourceAdvanceSetting advanceSetting = new DBSourceAdvanceSetting();

    public DBSourceAdvanceSetting getAdvanceSetting() {
        return this.advanceSetting;
    }

    public void setAdvanceSetting(DBSourceAdvanceSetting advanceSetting) {
        this.advanceSetting = advanceSetting;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public SourceType getType() {
        return SourceType.DB;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void addUserSql(UserSQL userSql) {
        if (null == this.userSqls) {
            this.userSqls = new ArrayList<UserSQL>();
        }
        this.userSqls.add(userSql);
    }

    public void addStoredProcedure(StoredProcedure storedProcedure) {
        if (null == this.storedProcedures) {
            this.storedProcedures = new ArrayList<StoredProcedure>();
        }
        this.storedProcedures.add(storedProcedure);
    }

    public boolean isUserDB() {
        return true;
    }

    @Override
    public void fromXml(Element node) throws ModelParseException {
        Element nodeStoredProcedures;
        Element nodeUserSqls;
        this.name = node.getAttributeValue("name");
        this.dbType = DBType.fromPersistance(node.getAttributeValue("dbType"));
        this.dbAddress = node.getAttributeValue("dbAddress");
        this.dbPort = null != node.getAttributeValue("dbPort") ? node.getAttributeValue("dbPort") : "";
        this.dbName = null != node.getAttributeValue("dbName") ? node.getAttributeValue("dbName") : "";
        this.userName = node.getAttributeValue("userName");
        this.password = AESUtil.aesByString(node.getAttributeValue("password"), 2);
        this.schema = null != node.getAttributeValue("schema") ? node.getAttributeValue("schema") : "";
        this.dbVersion = null != node.getAttributeValue("dbVersion") ? node.getAttributeValue("dbVersion") : "";
        this.connectType = null != node.getAttributeValue("connectType") ? node.getAttributeValue("connectType") : "";
        Element advanceSettingNode = node.getChild("advanceSetting");
        if (null != advanceSettingNode) {
            this.advanceSetting.fromXml(advanceSettingNode);
        }
        if ((nodeUserSqls = node.getChild("UserSQLs")) != null) {
            this.userSqls = new ArrayList<UserSQL>(nodeUserSqls.getChildren().size());
            for (Element nodeUserSql : nodeUserSqls.getChildren()) {
                UserSQL userSql = new UserSQL();
                userSql.fromXml(nodeUserSql);
                this.userSqls.add(userSql);
            }
        }
        if ((nodeStoredProcedures = node.getChild("StoredProcedures")) != null) {
            this.storedProcedures = new ArrayList<StoredProcedure>(nodeStoredProcedures.getChildren().size());
            for (Element nodeStoredProcedure : nodeStoredProcedures.getChildren()) {
                StoredProcedure storedProcedure = new StoredProcedure();
                storedProcedure.fromXml(nodeStoredProcedure);
                this.storedProcedures.add(storedProcedure);
            }
        }
    }

    @Override
    public Element innerToXml() {
        Element node = new Element("DBSource");
        node.setAttribute("name", this.name);
        node.setAttribute("dbType", this.dbType.toPersistance());
        node.setAttribute("dbAddress", this.dbAddress);
        if (StringUtils.isNotEmpty((CharSequence)this.dbPort)) {
            node.setAttribute("dbPort", this.dbPort);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.dbName)) {
            node.setAttribute("dbName", this.dbName);
        }
        node.setAttribute("userName", this.userName);
        node.setAttribute("password", AESUtil.aesByString(this.password, 1));
        if (StringUtils.isNotEmpty((CharSequence)this.schema)) {
            node.setAttribute("schema", this.schema);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.dbVersion)) {
            node.setAttribute("dbVersion", this.dbVersion);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.connectType)) {
            node.setAttribute("connectType", this.connectType);
        }
        if (null != this.advanceSetting) {
            Element advanceSettingContentNode = this.advanceSetting.toXml();
            node.addContent((Content)advanceSettingContentNode);
        }
        Element nodeUserSqls = new Element("UserSQLs");
        if (this.userSqls != null && !this.userSqls.isEmpty()) {
            for (UserSQL userSql : this.userSqls) {
                Element nodeSql = userSql.toXml();
                nodeUserSqls.addContent((Content)nodeSql);
            }
            node.addContent((Content)nodeUserSqls);
        }
        Element nodeStoredProcedures = new Element("StoredProcedures");
        if (this.storedProcedures != null && !this.storedProcedures.isEmpty()) {
            for (StoredProcedure storedProcedure : this.storedProcedures) {
                Element nodeStoredProcedure = storedProcedure.toXml();
                nodeStoredProcedures.addContent((Content)nodeStoredProcedure);
            }
            node.addContent((Content)nodeStoredProcedures);
        }
        return node;
    }

    public DBType getDbType() {
        return this.dbType;
    }

    public void setDbType(DBType dbType) {
        this.dbType = dbType;
    }

    public String getDbAddress() {
        return this.dbAddress;
    }

    public void setDbAddress(String dbAddress) {
        this.dbAddress = dbAddress;
    }

    public String getDbPort() {
        return this.dbPort;
    }

    public void setDbPort(String dbPort) {
        this.dbPort = dbPort;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public void setDbVersion(String dbVersion) {
        this.dbVersion = dbVersion;
    }

    public String getConnectType() {
        return this.connectType;
    }

    public void setConnectType(String connectType) {
        this.connectType = connectType;
    }

    public UserSQL getUserSql(String name) {
        if (this.userSqls != null) {
            for (UserSQL userSQL : this.userSqls) {
                if (!userSQL.getName().equals(name)) continue;
                return userSQL;
            }
        }
        return null;
    }

    public StoredProcedure getStoredProcedure(String name) {
        if (this.storedProcedures != null) {
            for (StoredProcedure storedProcedure : this.storedProcedures) {
                if (!storedProcedure.getName().equals(name)) continue;
                return storedProcedure;
            }
        }
        return null;
    }

    public boolean isUserSql(String associateName) {
        return this.getUserSql(associateName) != null;
    }

    public boolean isStoredProcedure(String associateName) {
        return this.getStoredProcedure(associateName) != null;
    }

    public List<UserSQL> getUserSqls() {
        return this.userSqls;
    }

    public void setUserSqls(List<UserSQL> userSqls) {
        this.userSqls = userSqls;
    }

    public List<StoredProcedure> getStoredProcedures() {
        return this.storedProcedures;
    }

    public void setStoredProcedures(List<StoredProcedure> storedProcedures) {
        this.storedProcedures = storedProcedures;
    }

    @Override
    public String getSourceHashCode() {
        StringBuilder key = new StringBuilder();
        key.append((Object)this.getDbType()).append(this.getDbAddress()).append(this.getDbPort()).append(this.getDbName()).append(this.getUserName());
        return DigestUtils.md5Hex((String)key.toString());
    }

    @Override
    public AbstractSource cloneUserRecentUsedSource() {
        DBSource dbSource = null;
        try {
            dbSource = (DBSource)super.clone();
            dbSource.setUserSqls(null);
            dbSource.setStoredProcedures(null);
        }
        catch (CloneNotSupportedException e) {
            LogUtil.error((String)"dbSource cloneUserRecentUsedSource error", (Throwable)e);
        }
        return dbSource;
    }

    public static boolean supportStoredProcedure(DBType dbType) {
        switch (dbType) {
            case MYSQL: 
            case SQLSERVER: 
            case ORACLE: 
            case POSTGRESQL: 
            case GREENPLUM: 
            case DB2: 
            case SYBASE: 
            case DM: 
            case SYBASEIQ: 
            case KINGBASE: 
            case GAUSSDB: {
                return true;
            }
        }
        return false;
    }

    public static class UserSQL {
        private String name;
        private String sqlType;
        private String content;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getSqlType() {
            return this.sqlType;
        }

        public void setSqlType(String sqlType) {
            this.sqlType = sqlType;
        }

        public Element toXml() {
            Element node = new Element("UserSQL");
            node.setAttribute("name", this.name);
            if (this.sqlType == null || "".equals(this.sqlType)) {
                this.setSqlType(SQLType.SQL.name());
            }
            node.setAttribute("sqlType", this.sqlType);
            XmlUtil.addCDATA((Element)node, (String)this.content);
            return node;
        }

        public void fromXml(Element node) throws ModelParseException {
            this.name = node.getAttributeValue("name");
            String nodeSqlType = node.getAttributeValue("sqlType");
            if (nodeSqlType == null || "".equals(nodeSqlType)) {
                nodeSqlType = SQLType.SQL.name();
            }
            this.sqlType = nodeSqlType;
            this.content = node.getTextTrim();
        }

        public static int getKTargetDbType(DBType dbType) {
            switch (dbType) {
                case MYSQL: {
                    return 6;
                }
                case SQLSERVER: {
                    return 3;
                }
                case ORACLE: {
                    return 2;
                }
                case POSTGRESQL: 
                case GREENPLUM: {
                    return 5;
                }
                case DB2: {
                    return 9;
                }
                case SYBASE: {
                    return 4;
                }
                case DM: {
                    return 11;
                }
                case SYBASEIQ: {
                    return 4;
                }
                case KINGBASE: {
                    return 15;
                }
                case VASTBASE: {
                    return 16;
                }
                case TDSQL: {
                    return 17;
                }
                case GBASE: {
                    return 18;
                }
                case TIDB: {
                    return 19;
                }
            }
            return 0;
        }

        public static enum SQLType {
            SQL,
            KSQL;

        }
    }

    public static class DBSourceAdvanceSetting {
        private String timezone;
        private String charset;
        private String otherSetting;

        public String getTimezone() {
            return this.timezone;
        }

        public void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public String getCharset() {
            return this.charset;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public String getOtherSetting() {
            return this.otherSetting;
        }

        public void setOtherSetting(String otherSetting) {
            this.otherSetting = otherSetting;
        }

        public Element toXml() {
            Element node = new Element("advanceSetting");
            if (StringUtils.isNotEmpty((CharSequence)this.timezone)) {
                node.setAttribute("timezone", this.timezone);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.charset)) {
                node.setAttribute("charset", this.charset);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.otherSetting)) {
                node.setAttribute("otherSetting", this.otherSetting);
            }
            return node;
        }

        public void fromXml(Element node) throws ModelParseException {
            this.timezone = node.getAttributeValue("timezone");
            this.charset = node.getAttributeValue("charset");
            this.otherSetting = node.getAttributeValue("otherSetting");
        }
    }

    public static enum DBType {
        MYSQL,
        SQLSERVER,
        ORACLE,
        POSTGRESQL,
        DB2,
        SQLITE,
        ACCESS,
        HIVE,
        HANA,
        ODPS,
        SYBASE,
        REDSHIFT,
        TIDB,
        DM,
        GREENPLUM,
        GAUSSDB,
        APACHEDRILL,
        SPARKSQL,
        SYBASEIQ,
        IMPALA,
        KYLIN,
        OPENLOOKENG,
        TDSQL,
        KINGBASE,
        GBASE,
        VASTBASE;


        public String toPersistance() {
            return this.name();
        }

        public static DBType fromPersistance(String name) throws ModelParseException {
            try {
                return DBType.valueOf(name);
            }
            catch (Exception ex) {
                throw new ModelParseException("Unknown DBType: " + name);
            }
        }
    }
}

