/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.util;

import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.util.LogUtil;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public abstract class AbstractConverter<T, K> {
    protected static final ThreadLocal<DateFormat> formateToDateTime = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    protected static final ThreadLocal<DateFormat> formateToDate = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    public static final int DATA_TYPE_BOOLEAN = 0;
    public static final int DATA_TYPE_INT = 1;
    public static final int DATA_TYPE_NUMBER = 2;
    public static final int DATA_TYPE_DATE = 3;
    public static final int DATA_TYPE_DATETIME = 4;
    public static final int DATA_TYPE_STRING = 5;
    private static AbstractConverter SELF_TO_SELF = new ObjectToObject();
    private static AbstractConverter UNSUPPORT_CONVERTER = new UnsupportConverter();
    private static AbstractConverter OBJECT_TO_STRING = new ObjectToString();
    private static final AbstractConverter[][] COMPATIBILITY = new AbstractConverter[][]{{SELF_TO_SELF, new BooleanToNumber(), new BooleanToNumber(), UNSUPPORT_CONVERTER, UNSUPPORT_CONVERTER, OBJECT_TO_STRING}, {new NumberToBoolean(), SELF_TO_SELF, new IntToNumber(), new NumberToDate(), new NumberToDateTime(), OBJECT_TO_STRING}, {new NumberToBoolean(), new NumberToInt(), SELF_TO_SELF, new NumberToDate(), new NumberToDateTime(), OBJECT_TO_STRING}, {new ObjectToBoolean(), new DateToNumber(), new DateToNumber(), SELF_TO_SELF, SELF_TO_SELF, new DateToString()}, {new ObjectToBoolean(), new DateToNumber(), new DateToNumber(), new DateTimeToDate(), SELF_TO_SELF, new DateTimeToString()}, {new StringToBoolean(), new StringToInt(), new StringToNumber(), new StringToDate(), new StringToDateTime(), SELF_TO_SELF}};

    abstract K convert(T var1);

    public static Object convert(DataType src, DataType dist, Object value) {
        return COMPATIBILITY[src.getIndex()][dist.getIndex()].convert(value);
    }

    public static BigDecimal getSafetyBigDecimal(BigDecimal bigDecimal) {
        int scale = Math.min(15, bigDecimal.scale());
        bigDecimal = bigDecimal.setScale(scale, 4);
        return bigDecimal;
    }

    static class ObjectToBoolean
    extends AbstractConverter<Object, Boolean> {
        ObjectToBoolean() {
        }

        @Override
        Boolean convert(Object value) {
            return value == null ? Boolean.FALSE : Boolean.TRUE;
        }
    }

    static class StringToDateTime
    extends AbstractConverter<String, Calendar> {
        private StringToNumber stringToNumber = new StringToNumber();
        private NumberToDateTime numberToDateTime = new NumberToDateTime();

        StringToDateTime() {
        }

        @Override
        Calendar convert(String value) {
            if (value != null) {
                try {
                    Date date = ((DateFormat)formateToDateTime.get()).parse(value);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    return calendar;
                }
                catch (ParseException e) {
                    if (LogUtil.isDebugEnabled()) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                    try {
                        Date date = ((DateFormat)formateToDate.get()).parse(value);
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(date);
                        return calendar;
                    }
                    catch (ParseException e2) {
                        if (LogUtil.isDebugEnabled()) {
                            LogUtil.error((String)e2.getMessage(), (Throwable)e2);
                        }
                        Number number = this.stringToNumber.convert(value);
                        return this.numberToDateTime.convert(number);
                    }
                }
            }
            return null;
        }
    }

    static class StringToDate
    extends StringToDateTime {
        private DateTimeToDate dateTimeToDate = new DateTimeToDate();

        StringToDate() {
        }

        @Override
        Calendar convert(String value) {
            Calendar date = super.convert(value);
            return this.dateTimeToDate.convert(date);
        }
    }

    static class StringToNumber
    extends AbstractConverter<String, Number> {
        StringToNumber() {
        }

        @Override
        Number convert(String value) {
            if (value != null) {
                value = value.trim();
                try {
                    return StringToNumber.getSafetyBigDecimal(new BigDecimal(value));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    static class StringToInt
    extends StringToNumber {
        private NumberToInt toInt = new NumberToInt();

        StringToInt() {
        }

        @Override
        Number convert(String value) {
            Number number = super.convert(value);
            return this.toInt.convert(number);
        }
    }

    static class StringToBoolean
    extends AbstractConverter<String, Boolean> {
        StringToBoolean() {
        }

        @Override
        Boolean convert(String value) {
            if (value != null) {
                return Boolean.parseBoolean(value);
            }
            return null;
        }
    }

    static class NumberToDateTime
    extends AbstractConverter<Number, Calendar> {
        NumberToDateTime() {
        }

        @Override
        Calendar convert(Number value) {
            if (value != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(value.longValue());
                return calendar;
            }
            return null;
        }
    }

    static class NumberToDate
    extends NumberToDateTime {
        private DateTimeToDate toDateTime = new DateTimeToDate();

        NumberToDate() {
        }

        @Override
        Calendar convert(Number value) {
            Calendar date = super.convert(value);
            return this.toDateTime.convert(date);
        }
    }

    static class NumberToInt
    extends AbstractConverter<Number, Number> {
        NumberToInt() {
        }

        @Override
        Number convert(Number value) {
            if (value != null) {
                long longValue = value.longValue();
                return NumberToInt.getSafetyBigDecimal(new BigDecimal(longValue));
            }
            return null;
        }
    }

    static class NumberToBoolean
    extends AbstractConverter<Number, Boolean> {
        NumberToBoolean() {
        }

        @Override
        Boolean convert(Number value) {
            if (value != null) {
                if (value.intValue() > 0 || value.intValue() < 0) {
                    return Boolean.TRUE;
                }
                if (value.floatValue() > 0.0f || value.floatValue() < 0.0f) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return Boolean.FALSE;
        }
    }

    static class DateTimeToString
    extends AbstractConverter<Object, String> {
        DateTimeToString() {
        }

        @Override
        String convert(Object value) {
            if (value != null) {
                if (value instanceof Calendar) {
                    return ((DateFormat)formateToDateTime.get()).format(((Calendar)value).getTime());
                }
                if (value instanceof Date) {
                    return ((DateFormat)formateToDateTime.get()).format((Date)value);
                }
            }
            return null;
        }
    }

    static class DateToString
    extends AbstractConverter<Object, String> {
        DateToString() {
        }

        @Override
        String convert(Object value) {
            if (value != null) {
                if (value instanceof Calendar) {
                    return ((DateFormat)formateToDate.get()).format(((Calendar)value).getTime());
                }
                if (value instanceof Date) {
                    return ((DateFormat)formateToDate.get()).format((Date)value);
                }
            }
            return null;
        }
    }

    static class DateTimeToDate
    extends AbstractConverter<Object, Calendar> {
        DateTimeToDate() {
        }

        @Override
        Calendar convert(Object value) {
            if (value != null) {
                Calendar calendar = null;
                if (value instanceof Calendar) {
                    calendar = (Calendar)value;
                } else if (value instanceof Date) {
                    calendar = Calendar.getInstance();
                    calendar.setTime((Date)value);
                } else {
                    return null;
                }
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return calendar;
            }
            return null;
        }
    }

    static class DateToNumber
    extends AbstractConverter<Object, Number> {
        DateToNumber() {
        }

        @Override
        Number convert(Object value) {
            if (value != null) {
                if (value instanceof Calendar) {
                    Calendar calendar = (Calendar)value;
                    return DateToNumber.getSafetyBigDecimal(BigDecimal.valueOf(calendar.getTimeInMillis()));
                }
                if (value instanceof Date) {
                    Date date = (Date)value;
                    return DateToNumber.getSafetyBigDecimal(BigDecimal.valueOf(date.getTime()));
                }
                return null;
            }
            return null;
        }
    }

    static class BooleanToNumber
    extends AbstractConverter<Boolean, Number> {
        BooleanToNumber() {
        }

        @Override
        Number convert(Boolean value) {
            if (value != null) {
                if (value.booleanValue()) {
                    return BigDecimal.ONE;
                }
                return BigDecimal.ZERO;
            }
            return null;
        }
    }

    static class ObjectToString
    extends AbstractConverter<Object, String> {
        ObjectToString() {
        }

        @Override
        String convert(Object value) {
            if (value != null) {
                return value.toString();
            }
            return null;
        }
    }

    static class IntToNumber
    extends AbstractConverter<Number, BigDecimal> {
        IntToNumber() {
        }

        @Override
        BigDecimal convert(Number value) {
            if (value == null) {
                return null;
            }
            return BigDecimal.valueOf(value.longValue());
        }
    }

    static class UnsupportConverter
    extends AbstractConverter<Object, Object> {
        UnsupportConverter() {
        }

        @Override
        Object convert(Object value) {
            return null;
        }
    }

    static class ObjectToObject
    extends AbstractConverter<Object, Object> {
        ObjectToObject() {
        }

        @Override
        Object convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof BigDecimal) {
                return ObjectToObject.getSafetyBigDecimal((BigDecimal)value);
            }
            return value;
        }
    }
}

