/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.util.valueconvert;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.macro.IMacroVarProvider;
import com.kingdee.bos.qing.data.exception.AbstractMacroException;
import com.kingdee.bos.qing.data.util.valueconvert.PrimaryDataValueHandlerDelegate;
import com.kingdee.bos.qing.data.util.valueconvert.ValueHandlerAdapter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MacroVarValueHandler
extends ValueHandlerAdapter {
    private PrimaryDataValueHandlerDelegate primaryDataValueHandlerDelegate;
    private IMacroVarProvider macroVarComparator;
    private QingContext qingContext;

    public MacroVarValueHandler(IMacroVarProvider macroVarComparator, PrimaryDataValueHandlerDelegate primaryDataValueHandlerDelegate, QingContext qingContext) {
        this.macroVarComparator = macroVarComparator;
        this.primaryDataValueHandlerDelegate = primaryDataValueHandlerDelegate;
        this.qingContext = qingContext;
    }

    @Override
    public Object toRuntimeValue(Object originalValue) {
        String id = (String)originalValue;
        Set<Object> macroValues = new HashSet();
        try {
            macroValues = this.macroVarComparator.getMacroValue(id, this.qingContext);
        }
        catch (AbstractMacroException e) {
            return Collections.emptySet();
        }
        if (macroValues.isEmpty()) {
            return Collections.emptySet();
        }
        if (this.macroVarComparator.isMultiValue(id, this.qingContext) || macroValues.size() > 1) {
            HashSet<Object> set = new HashSet<Object>(macroValues.size());
            for (Object macroValue : macroValues) {
                set.add(this.primaryDataValueHandlerDelegate.toRuntimeValue(macroValue));
            }
            return set;
        }
        Iterator<Object> iterator = macroValues.iterator();
        return this.primaryDataValueHandlerDelegate.toRuntimeValue(iterator.next());
    }
}

