/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.util.valueconvert;

import com.kingdee.bos.qing.data.util.AbstractConverter;
import com.kingdee.bos.qing.data.util.valueconvert.IValueHandler;
import com.kingdee.bos.qing.data.util.valueconvert.ValueHandlerAdapter;
import com.kingdee.bos.qing.datasource.meta.DataType;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class PrimaryDataValueHandlerDelegate
implements IValueHandler {
    private DataType dataType;
    protected Map<DataType, IValueHandler> valueHandlerMap = new HashMap<DataType, IValueHandler>();

    public PrimaryDataValueHandlerDelegate(DataType dataType) {
        this.dataType = dataType;
        this.initPrimaryDataValueHandlerMap();
    }

    protected void initPrimaryDataValueHandlerMap() {
        this.valueHandlerMap.put(DataType.BOOLEAN, new BooleanValueHandler());
        this.valueHandlerMap.put(DataType.DATETIME, new DateTimeValueHandler());
        this.valueHandlerMap.put(DataType.DATE, new DateValueHandler());
        this.valueHandlerMap.put(DataType.INT, new IntegerValueHandler());
        this.valueHandlerMap.put(DataType.NUMBER, new NumberValueHandler());
        this.valueHandlerMap.put(DataType.STRING, new StringValueHandler());
    }

    @Override
    public Object toDbFilterValue(Object runtimValue) {
        IValueHandler valueHandler = this.valueHandlerMap.get(this.dataType);
        if (null != valueHandler) {
            return valueHandler.toDbFilterValue(runtimValue);
        }
        return runtimValue;
    }

    @Override
    public Object toCloudEntityFilterValue(Object runtimeValue) {
        IValueHandler valueHandler = this.valueHandlerMap.get(this.dataType);
        if (null != valueHandler) {
            return valueHandler.toCloudEntityFilterValue(runtimeValue);
        }
        return runtimeValue;
    }

    @Override
    public Object toRuntimeValue(Object originalValue) {
        IValueHandler valueHandler = this.valueHandlerMap.get(this.dataType);
        if (null != valueHandler) {
            return valueHandler.toRuntimeValue(originalValue);
        }
        return originalValue;
    }

    public static class DateValueHandler
    extends ValueHandlerAdapter {
        @Override
        public Object toRuntimeValue(Object originalValue) {
            String strValue = String.valueOf(originalValue);
            Long millis = Long.valueOf(strValue);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(millis);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar;
        }

        @Override
        public Object toCloudEntityFilterValue(Object runtimeValue) {
            Calendar calendar = (Calendar)runtimeValue;
            return calendar.getTime();
        }
    }

    public static class DateTimeValueHandler
    extends ValueHandlerAdapter {
        @Override
        public Object toRuntimeValue(Object originalValue) {
            String strValue = String.valueOf(originalValue);
            Long millis = Long.valueOf(strValue);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(millis);
            return calendar;
        }

        @Override
        public Object toCloudEntityFilterValue(Object runtimeValue) {
            Calendar calendar = (Calendar)runtimeValue;
            return calendar.getTime();
        }
    }

    public static class NumberValueHandler
    extends ValueHandlerAdapter {
        @Override
        public Object toRuntimeValue(Object originalValue) {
            return AbstractConverter.getSafetyBigDecimal(new BigDecimal(String.valueOf(originalValue)));
        }
    }

    public static class IntegerValueHandler
    extends ValueHandlerAdapter {
        @Override
        public Object toRuntimeValue(Object originalValue) {
            return AbstractConverter.getSafetyBigDecimal(new BigDecimal(String.valueOf(originalValue)));
        }
    }

    public static class BooleanValueHandler
    extends ValueHandlerAdapter {
        @Override
        public Object toRuntimeValue(Object originalValue) {
            String strValue = String.valueOf(originalValue);
            return Boolean.valueOf(strValue);
        }
    }

    public static class StringValueHandler
    extends ValueHandlerAdapter {
        @Override
        public Object toRuntimeValue(Object originalValue) {
            if (null == originalValue) {
                return null;
            }
            return String.valueOf(originalValue);
        }

        @Override
        public Object toDbFilterValue(Object runtimValue) {
            if (null == runtimValue) {
                return null;
            }
            return String.valueOf(runtimValue);
        }

        @Override
        public Object toCloudEntityFilterValue(Object runtimeValue) {
            return this.toDbFilterValue(runtimeValue);
        }
    }
}

