/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.util.valueconvert;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.data.util.valueconvert.PrimaryDataValueHandlerDelegate;
import com.kingdee.bos.qing.data.util.valueconvert.ValueHandlerAdapter;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class SystemVarValueHandler
extends ValueHandlerAdapter {
    private PrimaryDataValueHandlerDelegate primaryDataValueHandlerDelegate;
    private QingContext qingContext;

    public SystemVarValueHandler(QingContext qingContext, PrimaryDataValueHandlerDelegate primaryDataValueHandlerDelegate) {
        this.qingContext = qingContext;
        this.primaryDataValueHandlerDelegate = primaryDataValueHandlerDelegate;
    }

    @Override
    public Object toRuntimeValue(Object originalValue) {
        String varValue = String.valueOf(originalValue);
        SystemVarType varType = SystemVarType.valueOf((String)varValue);
        Object realValue = this.qingContext.getSystemVar(varType);
        if (varType.isCollectionType()) {
            return this.convertToSets(realValue);
        }
        return this.primaryDataValueHandlerDelegate.toRuntimeValue(realValue);
    }

    private Object convertToSets(Object realValue) {
        if (null == realValue) {
            return Collections.emptySet();
        }
        Collection collection = (Collection)realValue;
        HashSet<Object> newSets = new HashSet<Object>();
        for (Object value : collection) {
            try {
                newSets.add(this.primaryDataValueHandlerDelegate.toRuntimeValue(value));
            }
            catch (Exception e) {
                LogUtil.info((String)("to runtime value error,type not match,originalValue:" + String.valueOf(value)));
            }
        }
        return newSets;
    }
}

