/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.base;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.join.base.AbstractAtomicDataSet;
import com.kingdee.bos.qing.datasource.model.AbstractDataSetModel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class CompositeDataSet
extends AbstractAtomicDataSet {
    private List<AbstractAtomicDataSet> dataSets;
    private Iterator<AbstractAtomicDataSet> iterator;
    private AbstractAtomicDataSet currentDataSet;
    private long rowCount = -1L;

    protected CompositeDataSet(AbstractDataSetModel dataSetModel, List<AbstractAtomicDataSet> dataSets) {
        super(dataSetModel);
        this.dataSets = dataSets;
        this.rowCount = 0L;
        for (AbstractAtomicDataSet atomicDataSet : dataSets) {
            if (atomicDataSet.getAdvisesRowCount() >= 0L) {
                this.rowCount += atomicDataSet.getAdvisesRowCount();
                continue;
            }
            this.rowCount = -1L;
            break;
        }
    }

    @Override
    public boolean nextRow() throws AbstractDataSourceException, InterruptedException {
        if (this.currentDataSet == null && this.iterator.hasNext()) {
            this.currentDataSet = this.iterator.next();
        }
        if (this.currentDataSet != null && this.currentDataSet.hasNextRow()) {
            this.setCurrentRow(this.currentDataSet.getCurrentRow());
            this.currentDataSet.nextRow();
        } else {
            this.setCurrentRow(null);
        }
        return true;
    }

    @Override
    protected void beforeFirst() throws AbstractDataSourceException, InterruptedException {
        for (AbstractAtomicDataSet atomicDataSet : this.dataSets) {
            atomicDataSet.firstRow();
        }
        this.iterator = this.dataSets.iterator();
    }

    @Override
    public long getAdvisesRowCount() {
        return this.rowCount;
    }

    public static CompositeDataSet createCompositeDataSet(AbstractAtomicDataSet ... atomicDataSets) {
        LinkedList<AbstractAtomicDataSet> dataSets = new LinkedList<AbstractAtomicDataSet>();
        for (AbstractAtomicDataSet atomicDataSet : atomicDataSets) {
            dataSets.add(atomicDataSet);
        }
        AbstractDataSetModel dataSetModel = ((AbstractAtomicDataSet)dataSets.get(0)).getDataSetModel();
        return new CompositeDataSet(dataSetModel, dataSets);
    }
}

