/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.base;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.join.JoinOption;
import com.kingdee.bos.qing.datasource.join.base.AbstractAtomicDataSet;
import com.kingdee.bos.qing.datasource.join.base.AbstractDataSet;
import com.kingdee.bos.qing.datasource.join.bnl.BlockNestedLoopJoinFactory;
import com.kingdee.bos.qing.datasource.join.shj.SimpleHashJoinFactory;
import com.kingdee.bos.qing.datasource.join.snl.SimpleNestedLoopJoinFactory;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskRuntime;
import com.kingdee.bos.qing.datasource.join.util.JoinUtil;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.model.JoinDataSetModel;
import com.kingdee.bos.qing.datasource.model.MultiDataSourceWrap;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceWriter;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;

public abstract class JoinFactory {
    private static Map<JoinStrategy, JoinFactory> joinFactorys = new HashMap<JoinStrategy, JoinFactory>();

    public abstract void innerJoin(MultiDataSourceWrap var1, AbstractAtomicDataSet var2, AbstractAtomicDataSet var3, JoinDataSetModel var4, JoinOption var5, QSDataSourceWriter var6, JoinTaskRuntime var7) throws AbstractDataSourceException, InterruptedException;

    public abstract void fullJoin(MultiDataSourceWrap var1, AbstractAtomicDataSet var2, AbstractAtomicDataSet var3, JoinDataSetModel var4, JoinOption var5, QSDataSourceWriter var6, JoinTaskRuntime var7) throws AbstractDataSourceException, InterruptedException;

    public abstract void leftJoin(MultiDataSourceWrap var1, AbstractAtomicDataSet var2, AbstractAtomicDataSet var3, JoinDataSetModel var4, JoinOption var5, QSDataSourceWriter var6, JoinTaskRuntime var7) throws AbstractDataSourceException, InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOneDataSetResult(QSDataSourceWriter qsDataSourceWriter, MetaInfo joinMetaInfo, AbstractDataSet oneDataSetResult, JoinTaskRuntime runtime) throws AbstractDataSourceException, InterruptedException {
        try {
            while (oneDataSetResult.hasNextRow()) {
                runtime.checkTaskNormal();
                Map<String, Object> currentRow = oneDataSetResult.getCurrentRow();
                Object[] data = JoinUtil.mapToObject(joinMetaInfo, currentRow);
                qsDataSourceWriter.writeData(data);
                runtime.increaseRowCount();
                oneDataSetResult.nextRow();
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{oneDataSetResult});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{oneDataSetResult});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeJoinResult(QSDataSourceWriter qsDataSourceWriter, AbstractDataSet joininDataSet, JoinTaskRuntime runtime) throws AbstractDataSourceException, InterruptedException {
        try {
            joininDataSet.init();
            while (joininDataSet.hasNextRow()) {
                runtime.checkTaskNormal();
                qsDataSourceWriter.writeData(joininDataSet.getCurrentArrayDatas());
                runtime.increaseRowCount();
                joininDataSet.nextRow();
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{joininDataSet});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{joininDataSet});
    }

    public static JoinFactory getJoinFactory(JoinStrategy joinStrategy) {
        return joinFactorys.get((Object)joinStrategy);
    }

    static {
        joinFactorys.put(JoinStrategy.BNLJOIN, new BlockNestedLoopJoinFactory());
        joinFactorys.put(JoinStrategy.SHJOIN, new SimpleHashJoinFactory());
        joinFactorys.put(JoinStrategy.SNLJOIN, new SimpleNestedLoopJoinFactory());
    }

    public static enum JoinStrategy {
        SNLJOIN,
        BNLJOIN,
        SMJOIN,
        SHJOIN;

    }
}

