/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.base;

import com.kingdee.bos.qing.datasource.join.base.AbstractAtomicDataSet;
import com.kingdee.bos.qing.datasource.model.AbstractDataSetModel;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class MemoryDataSet
extends AbstractAtomicDataSet {
    private List<Map<String, Object>> memoryDatas;
    private Iterator<Map<String, Object>> memoryDataIterator;

    public MemoryDataSet(AbstractDataSetModel dataSetModel, List<Map<String, Object>> memoryDatas) {
        super(dataSetModel);
        this.memoryDatas = memoryDatas;
    }

    public MemoryDataSet copy() {
        return new MemoryDataSet(this.getDataSetModel(), this.memoryDatas);
    }

    @Override
    public long getAdvisesRowCount() {
        return this.memoryDatas.size();
    }

    @Override
    public boolean nextRow() {
        if (this.memoryDataIterator.hasNext()) {
            this.setCurrentRow(this.memoryDataIterator.next());
        } else {
            this.setCurrentRow(null);
        }
        return true;
    }

    @Override
    protected void beforeFirst() {
        this.memoryDataIterator = this.memoryDatas.iterator();
    }

    @Override
    public final void close() {
        this.memoryDataIterator = null;
        if (this.memoryDatas != null) {
            this.memoryDatas.clear();
            this.memoryDatas = null;
        }
        super.close();
    }
}

