/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.cache;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.thread.DelayedRunnable;
import com.kingdee.bos.qing.datasource.join.cache.SharedJoinFile;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SharedJoinFileCacheCleaner
implements DelayedRunnable {
    private Set<String> clearedJoinFileKey = new HashSet<String>();

    public SharedJoinFileCacheCleaner(Set<String> clearedJoinFileKey) {
        this.clearedJoinFileKey.addAll(clearedJoinFileKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        int maxLoopSize = 5;
        block7: while (this.clearedJoinFileKey.size() > 0 && --maxLoopSize > 0) {
            IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
            Iterator<String> iterator = this.clearedJoinFileKey.iterator();
            while (iterator.hasNext()) {
                String joinFileKey = iterator.next();
                ILock lock = LockFactory.createGlobalLock((String)joinFileKey);
                try {
                    boolean succeed = lock.tryLock(10000L);
                    if (!succeed) continue;
                    SharedJoinFile sharedJoinFile = (SharedJoinFile)globalQingSession.getCache(joinFileKey, SharedJoinFile.class);
                    if (null != sharedJoinFile) {
                        sharedJoinFile.decreaseCount();
                    }
                    if (sharedJoinFile == null || sharedJoinFile.getSharedCount() == 0) {
                        globalQingSession.remove(joinFileKey);
                        if (sharedJoinFile != null) {
                            LogUtil.info((String)("remove shared join file cache info:" + sharedJoinFile.getJoinFileName()));
                        }
                    } else {
                        globalQingSession.setCache((ISessionCacheable)sharedJoinFile);
                    }
                    iterator.remove();
                }
                catch (InterruptedException e) {
                    continue block7;
                }
                catch (QingLockRequireException e) {
                    LogUtil.error((String)"", (Throwable)e);
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    public long getDelayTime() {
        return 10000L;
    }
}

