/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.cache;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ThemeTableFieldAnalysisHistory
implements ISessionCacheable {
    private String themeId;
    private String userId;
    private Map<String, Set<DSFieldKey>> tableAnalysisFields = new HashMap<String, Set<DSFieldKey>>();

    public void setThemeId(String themeId) {
        this.themeId = themeId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Set<DSFieldKey> refreshAnalysisFields(Set<DSFieldKey> analysisFields, Map<String, MetaInfo> liveEntityMetas) {
        HashSet<DSFieldKey> totalAnalysisFields = new HashSet<DSFieldKey>(16);
        Set<String> entityNames = this.getEntityNames(analysisFields);
        this.syncFromHistoryAnalysisFields(liveEntityMetas, entityNames, totalAnalysisFields);
        for (DSFieldKey dsFieldKey : analysisFields) {
            totalAnalysisFields.add(dsFieldKey);
            Set<DSFieldKey> history = this.tableAnalysisFields.get(dsFieldKey.getEntityName());
            if (dsFieldKey.getPropertyName().equals("_ROWID_")) continue;
            history.add(dsFieldKey);
        }
        return totalAnalysisFields;
    }

    private void syncFromHistoryAnalysisFields(Map<String, MetaInfo> liveEntityMetas, Set<String> entityNames, Set<DSFieldKey> totalAnalysisFields) {
        for (String entityName : entityNames) {
            Set<DSFieldKey> currentCached = this.tableAnalysisFields.get(entityName);
            if (null == currentCached) {
                currentCached = new HashSet<DSFieldKey>();
                this.tableAnalysisFields.put(entityName, currentCached);
            } else {
                MetaInfo metaInfo = liveEntityMetas.get(entityName);
                if (null != metaInfo) {
                    HashSet allFieldNames = new HashSet(metaInfo.getFieldNames());
                    Iterator<DSFieldKey> iterator = currentCached.iterator();
                    while (iterator.hasNext()) {
                        DSFieldKey currentCacheField = iterator.next();
                        if (allFieldNames.contains(currentCacheField.getPropertyName())) continue;
                        iterator.remove();
                    }
                }
            }
            totalAnalysisFields.addAll(currentCached);
        }
    }

    private Set<String> getEntityNames(Set<DSFieldKey> analysisFields) {
        HashSet<String> entityNames = new HashSet<String>(16);
        for (DSFieldKey dsFieldKey : analysisFields) {
            String entityName = dsFieldKey.getEntityName();
            entityNames.add(entityName);
        }
        return entityNames;
    }

    public String getCacheKey() {
        return this.themeId + "_" + this.userId + "_AnalysisFields";
    }

    public String toJson() {
        return JsonUtil.encodeToString((Object)this);
    }

    public ISessionCacheable fromJson(String json) {
        return (ISessionCacheable)JsonUtil.decodeFromString((String)json, this.getClass());
    }

    public int getTimeoutSeconds() {
        return 172800;
    }
}

