/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.shj;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.join.JoinOption;
import com.kingdee.bos.qing.datasource.join.base.AbstractAtomicDataSet;
import com.kingdee.bos.qing.datasource.join.base.JoinFactory;
import com.kingdee.bos.qing.datasource.join.task.DataSetJoinPair;
import com.kingdee.bos.qing.datasource.join.task.DataSetJoinTask;
import com.kingdee.bos.qing.datasource.join.task.HashTask;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskRuntime;
import com.kingdee.bos.qing.datasource.join.task.NotMatchDataSetWriteTask;
import com.kingdee.bos.qing.datasource.model.JoinDataSetModel;
import com.kingdee.bos.qing.datasource.model.MultiDataSourceWrap;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceWriter;
import java.util.List;

public class SimpleHashJoinFactory
extends JoinFactory {
    @Override
    public void innerJoin(MultiDataSourceWrap multiDataSourceWrap, AbstractAtomicDataSet leftDataSet, AbstractAtomicDataSet rightDataSet, JoinDataSetModel joinDataSetModel, JoinOption joinOption, QSDataSourceWriter joinResultWriter, JoinTaskRuntime runtime) throws AbstractDataSourceException, InterruptedException {
        this.doHashJoin(leftDataSet, rightDataSet, joinDataSetModel, joinOption, joinResultWriter, runtime);
    }

    @Override
    public void fullJoin(MultiDataSourceWrap multiDataSourceWrap, AbstractAtomicDataSet leftDataSet, AbstractAtomicDataSet rightDataSet, JoinDataSetModel joinDataSetModel, JoinOption joinOption, QSDataSourceWriter joinResultWriter, JoinTaskRuntime runtime) throws AbstractDataSourceException, InterruptedException {
        this.doHashJoin(leftDataSet, rightDataSet, joinDataSetModel, joinOption, joinResultWriter, runtime);
    }

    @Override
    public void leftJoin(MultiDataSourceWrap multiDataSourceWrap, AbstractAtomicDataSet leftDataSet, AbstractAtomicDataSet rightDataSet, JoinDataSetModel joinDataSetModel, JoinOption joinOption, QSDataSourceWriter joinResultWriter, JoinTaskRuntime runtime) throws AbstractDataSourceException, InterruptedException {
        this.doHashJoin(leftDataSet, rightDataSet, joinDataSetModel, joinOption, joinResultWriter, runtime);
    }

    private void doHashJoin(AbstractAtomicDataSet leftDataSet, AbstractAtomicDataSet rightDataSet, JoinDataSetModel joinDataSetModel, JoinOption joinOption, QSDataSourceWriter joinResultWriter, JoinTaskRuntime runtime) throws AbstractDataSourceException, InterruptedException {
        HashTask hashTask = new HashTask(leftDataSet, rightDataSet, joinDataSetModel, joinOption, runtime);
        List dataSetJoinPairs = (List)hashTask.invoke();
        if (null != dataSetJoinPairs) {
            JoinDataSetModel newJoinDataSetModel = JoinDataSetModel.copy(joinDataSetModel);
            JoinOption newJoinOption = new JoinOption(null, false, joinOption.getCachePageSize(), false, joinOption.getBucketSize());
            this.invokeEachJoin(joinResultWriter, runtime, dataSetJoinPairs, newJoinDataSetModel, newJoinOption);
        }
    }

    private void invokeEachJoin(QSDataSourceWriter joinResultWriter, JoinTaskRuntime runtime, List<DataSetJoinPair> dataSetJoinPairs, JoinDataSetModel newJoinDataSetModel, JoinOption newJoinOption) {
        for (DataSetJoinPair joinPair : dataSetJoinPairs) {
            NotMatchDataSetWriteTask task;
            AbstractAtomicDataSet left = joinPair.getLeft();
            AbstractAtomicDataSet right = joinPair.getRight();
            if (null == left && null == right) continue;
            if (null != left && null != right) {
                DataSetJoinTask dataSetJoinTask = new DataSetJoinTask(left, right, newJoinDataSetModel, newJoinOption, runtime);
                dataSetJoinTask.setJoinDataWriter(joinResultWriter);
                dataSetJoinTask.invoke();
                continue;
            }
            JoinDataSetModel.JoinType joinType = newJoinDataSetModel.getJoinType();
            if (null != left && joinType != JoinDataSetModel.JoinType.InnerJoin) {
                task = new NotMatchDataSetWriteTask(left, joinResultWriter, runtime, newJoinDataSetModel);
                task.invoke();
                continue;
            }
            if (null == right || joinType != JoinDataSetModel.JoinType.FullJoin) continue;
            task = new NotMatchDataSetWriteTask(right, joinResultWriter, runtime, newJoinDataSetModel);
            task.invoke();
        }
    }
}

