/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.task;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.join.base.AbstractRecursiveTask;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskRuntime;
import com.kingdee.bos.qing.datasource.join.util.JoinUtil;
import com.kingdee.bos.qing.util.LogUtil;

public abstract class JoinTaskTemplate<T>
extends AbstractRecursiveTask<T> {
    protected JoinTaskRuntime taskRuntime;
    private boolean isRootTask = false;
    private String workNodeID;
    private String taskId;

    JoinTaskTemplate(JoinTaskRuntime taskRuntime, boolean isRootTask) {
        this.taskRuntime = taskRuntime;
        this.isRootTask = isRootTask;
        this.workNodeID = taskRuntime.getWorkNodeId();
        this.taskId = taskRuntime.getTaskId();
    }

    JoinTaskRuntime getTaskRuntime() {
        return this.taskRuntime;
    }

    @Override
    protected T compute() {
        if (this.isRootTask) {
            return this.doRootCompute();
        }
        return this.doMiddleTaskCompute();
    }

    private T doMiddleTaskCompute() {
        try {
            this.taskRuntime.checkTaskNormal();
        }
        catch (AbstractDataSourceException e) {
            this.completeExceptionally(e);
            return null;
        }
        T value = this.doCompute();
        this.taskRuntime.setException(this.getException());
        return value;
    }

    private T doRootCompute() {
        if (!this.taskRuntime.validateAndStart(this.workNodeID)) {
            this.printDebug(JoinUtil.joinLogPrefix() + "current task is stolen and executed by other node,taskId:" + this.taskId);
            return null;
        }
        T value = null;
        try {
            this.taskRuntime.checkTaskNormal();
            value = this.doCompute();
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
        finally {
            this.taskRuntime.setException(this.getException());
            this.taskRuntime.end(value);
        }
        return value;
    }

    private void printDebug(String debugMsg) {
        LogUtil.info((String)debugMsg);
    }

    protected abstract T doCompute();
}

