/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.worknodes;

import com.kingdee.bos.qing.datasource.join.worknodes.TaskReleaseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class GlobalTaskCounter {
    private AtomicInteger availableCount = new AtomicInteger(0);
    private int maxLimit;
    private List<TaskReleaseListener> releaseListeners = new ArrayList<TaskReleaseListener>();

    public void initCount(int available) {
        this.availableCount.set(available);
        this.maxLimit = available;
    }

    public void addTaskReleaseListener(TaskReleaseListener releaseListener) {
        this.releaseListeners.add(releaseListener);
    }

    public int getCurrentRunningCount() {
        return this.maxLimit - this.availableCount.get();
    }

    public boolean reachMaxLimit() {
        return this.availableCount.get() == 0;
    }

    public int getMaxLimit() {
        return this.maxLimit;
    }

    public boolean aquire() {
        int original = this.availableCount.get();
        if (original == 0) {
            return false;
        }
        while (!this.availableCount.compareAndSet(original, original - 1)) {
            original = this.availableCount.get();
            if (original != 0) continue;
            return false;
        }
        return true;
    }

    public void release(int state) {
        int original = this.availableCount.get();
        if (original == this.maxLimit) {
            return;
        }
        while (!this.availableCount.compareAndSet(original, original + 1)) {
            original = this.availableCount.get();
            if (original != this.maxLimit) continue;
            return;
        }
        for (TaskReleaseListener releaseListener : this.releaseListeners) {
            releaseListener.taskReleased(state);
        }
    }
}

