/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.worknodes;

import com.kingdee.bos.qing.datasource.join.config.QingJoinConfig;
import com.kingdee.bos.qing.datasource.join.task.TaskEvent;
import com.kingdee.bos.qing.datasource.join.worknodes.NodeStateType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class NodeState {
    private volatile NodeStateType stateType;
    private int maxRunningTaskLimit;
    private AtomicInteger taskLoadedCount = new AtomicInteger(0);
    private Set<String> longTimeTaskIds = Collections.synchronizedSet(new HashSet());
    private Map<NodeStateType, StateChangable> stateChangeProcessors = new HashMap<NodeStateType, StateChangable>();
    private AtomicInteger largeScaleTaskCount = new AtomicInteger(0);

    public static NodeState initState(int nodeThreadPoolSize) {
        if (QingJoinConfig.getInstance().isMemMonitorOpened()) {
            return new NodeState(NodeStateType.IDLE, nodeThreadPoolSize);
        }
        return new NodeState(NodeStateType.IDLE, 10);
    }

    protected NodeState(NodeStateType stateType, int maxRunningTaskLimit) {
        this.stateType = stateType;
        this.maxRunningTaskLimit = maxRunningTaskLimit;
        this.stateChangeProcessors.put(NodeStateType.IDLE, new IdleState());
        this.stateChangeProcessors.put(NodeStateType.LOADED, new LoadState());
        this.stateChangeProcessors.put(NodeStateType.FULLLOADED, new FullLoadState());
    }

    public int getMaxRunningTaskLimit() {
        return this.maxRunningTaskLimit;
    }

    public Set<String> getLongTimeTaskIds() {
        return this.longTimeTaskIds;
    }

    public NodeStateType getState() {
        return this.stateType;
    }

    boolean longTimeRunTaskExist(String taskID) {
        return this.longTimeTaskIds.contains(taskID);
    }

    public void changeState(TaskEvent event) {
        String taskId = event.getTaskId();
        TaskEvent.EventType eventType = event.getEventType();
        StateChangable stateChangeProcessor = this.stateChangeProcessors.get((Object)this.stateType);
        switch (eventType) {
            case SUBMIT: {
                this.stateType = stateChangeProcessor.onCreate(taskId);
                break;
            }
            case FINISHED: 
            case STOLEN: {
                this.stateType = stateChangeProcessor.onFinished(taskId);
                break;
            }
            case LONGTIME_RUNNING: {
                this.longTimeTaskIds.add(taskId);
            }
        }
    }

    public int getLargeScaleCount() {
        return this.largeScaleTaskCount.get();
    }

    public void increamentLargeScale() {
        this.largeScaleTaskCount.incrementAndGet();
    }

    public void descreamentLargeScale() {
        this.largeScaleTaskCount.decrementAndGet();
    }

    public boolean hasLongTimeRunningTask() {
        return this.longTimeTaskIds.size() > 0;
    }

    public int getTaskLoadedCount() {
        return this.taskLoadedCount.get();
    }

    public NodeState newCopy() {
        NodeState ns = new NodeState(this.stateType, this.maxRunningTaskLimit);
        ns.taskLoadedCount.set(this.taskLoadedCount.get());
        ns.longTimeTaskIds.addAll(this.longTimeTaskIds);
        ns.largeScaleTaskCount.set(this.getLargeScaleCount());
        return ns;
    }

    private class FullLoadState
    implements StateChangable {
        private FullLoadState() {
        }

        @Override
        public NodeStateType onCreate(String taskId) {
            throw new UnsupportedOperationException("a fullloaded state worknode is impposable to create a join work");
        }

        @Override
        public NodeStateType onFinished(String taskId) {
            int count = NodeState.this.taskLoadedCount.decrementAndGet();
            NodeState.this.longTimeTaskIds.remove(taskId);
            return count == NodeState.this.maxRunningTaskLimit ? NodeStateType.FULLLOADED : NodeStateType.LOADED;
        }
    }

    private class LoadState
    implements StateChangable {
        private LoadState() {
        }

        @Override
        public NodeStateType onCreate(String taskId) {
            int count = NodeState.this.taskLoadedCount.incrementAndGet();
            return count == NodeState.this.maxRunningTaskLimit ? NodeStateType.FULLLOADED : NodeStateType.LOADED;
        }

        @Override
        public NodeStateType onFinished(String taskId) {
            int count = NodeState.this.taskLoadedCount.decrementAndGet();
            NodeState.this.longTimeTaskIds.remove(taskId);
            if (count == 0) {
                return NodeStateType.IDLE;
            }
            return NodeStateType.LOADED;
        }
    }

    private class IdleState
    implements StateChangable {
        private IdleState() {
        }

        @Override
        public NodeStateType onCreate(String taskId) {
            NodeState.this.taskLoadedCount.incrementAndGet();
            return NodeStateType.LOADED;
        }

        @Override
        public NodeStateType onFinished(String taskId) {
            throw new UnsupportedOperationException("an idle state work node is impposable to finish a join work");
        }
    }

    private static interface StateChangable {
        public NodeStateType onCreate(String var1);

        public NodeStateType onFinished(String var1);
    }
}

