/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.model;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.join.util.RowValueComparator;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DSMeta;
import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.meta.DSMetaProperty;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.model.AbstractDataSetModel;
import com.kingdee.bos.qing.datasource.model.MultiDataSourceWrap;
import com.kingdee.bos.qing.datasource.spec.AbstractSingleDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class DataSetModel
extends AbstractDataSetModel {
    private final List<IDataSourceVisitor> dataSourceVisitors;
    private final Set<DSFieldKey> selectedFields;

    public DataSetModel(Set<String> entityNames, MetaInfo metaInfo, Set<DSFieldKey> selectedFields, List<IDataSourceVisitor> dataSourceVisitors) {
        super(metaInfo);
        this.entityNames.addAll(entityNames);
        if (selectedFields == null) {
            DSMetaEntity dsMetaEntity = (DSMetaEntity)dataSourceVisitors.get(0).getMeta().getEntities().get(0);
            this.selectedFields = new HashSet<DSFieldKey>(dsMetaEntity.getProperties().size());
            for (DSMetaProperty metaProperty : dsMetaEntity.getProperties()) {
                this.selectedFields.add(new DSFieldKey(metaProperty.getName()));
            }
        } else {
            this.selectedFields = selectedFields;
        }
        this.dataSourceVisitors = dataSourceVisitors;
    }

    public DataSetModel(Set<String> entityNames, MetaInfo metaInfo, Set<DSFieldKey> selectedFields, List<IDataSourceVisitor> dataSourceVisitors, RowValueComparator rowValueComparator) {
        this(entityNames, metaInfo, selectedFields, dataSourceVisitors);
        if (rowValueComparator != null) {
            this.rowValueComparator = rowValueComparator;
            this.markSortedField(rowValueComparator.getComparisonField());
        }
    }

    public List<IDataSourceVisitor> getDataSourceVisitors() {
        return Collections.unmodifiableList(this.dataSourceVisitors);
    }

    public Set<DSFieldKey> getSelectedFields() {
        return Collections.unmodifiableSet(this.selectedFields);
    }

    public static DataSetModel createDataSetModel(MultiDataSourceWrap multiDataSourceWrap, String entityName, Set<String> selectedFields) throws AbstractDataSourceException {
        if (selectedFields == null) {
            selectedFields = new HashSet<String>();
        }
        HashSet<String> entityNames = new HashSet<String>();
        entityNames.add(entityName);
        AbstractSingleDataSourceVisitor dataSourceVisitor = multiDataSourceWrap.get(entityNames);
        DSMeta dSMeta = dataSourceVisitor.getMeta();
        DSMetaEntity dsMetaEntity = (DSMetaEntity)dSMeta.getEntities().get(0);
        List dsMetaProperties = dsMetaEntity.getProperties();
        MetaInfo metaInfo = new MetaInfo();
        HashSet<DSFieldKey> selectedFieldKeys = new HashSet<DSFieldKey>();
        for (int columnIndex = 0; columnIndex < dsMetaProperties.size(); ++columnIndex) {
            DSMetaProperty property = (DSMetaProperty)dsMetaProperties.get(columnIndex);
            String fieldName = property.getName();
            if (!selectedFields.isEmpty() && !selectedFields.contains(fieldName)) continue;
            DSFieldKey fieldKey = new DSFieldKey(entityName, fieldName);
            selectedFieldKeys.add(fieldKey);
            String displayName = property.getDisplayName();
            DataType dataType = property.getDataType();
            metaInfo.addField(fieldKey.toFullName(), displayName, dataType, property.isHide().booleanValue());
        }
        if (selectedFields.contains("_ROWID_")) {
            DSFieldKey fieldKey = new DSFieldKey(entityName, "_ROWID_");
            selectedFieldKeys.add(fieldKey);
            metaInfo.addField(fieldKey.toFullName(), "_ROWID_", DataType.INT, true);
        }
        ArrayList<IDataSourceVisitor> dataSourceVisitors = new ArrayList<IDataSourceVisitor>();
        dataSourceVisitors.add(dataSourceVisitor);
        return new DataSetModel(entityNames, metaInfo, selectedFieldKeys, dataSourceVisitors);
    }

    @Override
    public String getModelDesc() {
        ArrayList<String> leftOrderedEntityNames = new ArrayList<String>(this.getEntityNames());
        Collections.sort(leftOrderedEntityNames);
        ArrayList<String> leftOrderedFields = new ArrayList<String>(10);
        Set<DSFieldKey> leftSelectedFields = this.getSelectedFields();
        for (DSFieldKey dsFieldKey : leftSelectedFields) {
            leftOrderedFields.add(dsFieldKey.toFullName());
        }
        Collections.sort(leftOrderedFields);
        LinkedHashMap<String, String> desc = new LinkedHashMap<String, String>();
        desc.put("ModelType:", "SimpleType");
        desc.put("entities", ((Object)leftOrderedEntityNames).toString());
        desc.put("fields:", ((Object)leftOrderedFields).toString());
        return JsonUtil.encodeToString(desc);
    }
}

