/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.spec;

import com.kingdee.bos.qing.datasource.cache.DataSourceCache;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.model.filter.IPushdownFilter;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListDataIterator
implements IDataIterator {
    private int currentIetratorIndex;
    private IDataIterator currentDataIterator;
    private List<IDataIterator> dataIterators;
    private IDataSourceWriter _dataSourceWriter;
    private Exception _exception;
    private DataSourceCache _dataSoruceCache;
    private boolean _isCache = false;
    private MetaInfo _iteratorMetaInfo;

    public ListDataIterator(List<IDataIterator> dataIterators) {
        this.dataIterators = dataIterators;
    }

    public void init(Set<DSFieldKey> fields, Set<IPushdownFilter> filters, String cacheKey) throws AbstractDataSourceException, InterruptedException {
        try {
            this.currentIetratorIndex = 0;
            this.currentDataIterator = this.dataIterators.get(this.currentIetratorIndex);
            this.currentDataIterator.init(fields, filters, null);
            for (int index = 1; index < this.dataIterators.size(); ++index) {
                IDataIterator dataIterator = this.dataIterators.get(this.currentIetratorIndex);
                dataIterator.init(fields, filters, null);
            }
        }
        catch (AbstractDataSourceException e) {
            this._exception = e;
            throw e;
        }
        catch (InterruptedException e) {
            this._exception = e;
            throw e;
        }
        if (cacheKey != null && !cacheKey.isEmpty()) {
            this._isCache = true;
            this._dataSoruceCache = new DataSourceCache(cacheKey);
            this._dataSourceWriter = this._dataSoruceCache.createWriter();
            this._dataSourceWriter.start(this._iteratorMetaInfo);
        } else {
            this._isCache = false;
            this._dataSoruceCache = null;
        }
    }

    public boolean hasNextRow() throws AbstractDataSourceException, InterruptedException {
        try {
            if (this.currentDataIterator != null && this.currentDataIterator.hasNextRow()) {
                return true;
            }
            while (this.currentIetratorIndex < this.dataIterators.size()) {
                ++this.currentIetratorIndex;
                this.currentDataIterator = this.dataIterators.get(this.currentIetratorIndex);
                if (this.currentDataIterator != null && this.currentDataIterator.hasNextRow()) {
                    return true;
                }
                this.currentDataIterator = null;
            }
        }
        catch (AbstractDataSourceException e) {
            this._exception = e;
            throw e;
        }
        catch (InterruptedException e) {
            this._exception = e;
            throw e;
        }
        return false;
    }

    public Map<String, Object> nextRow() throws AbstractDataSourceException, InterruptedException {
        Map row = null;
        try {
            if (this.currentDataIterator != null) {
                row = this.currentDataIterator.nextRow();
            }
            if (row == null || !this._isCache) {
                return row;
            }
            Object[] newRow = new Object[this._iteratorMetaInfo.getSize()];
            for (int index = 0; index < this._iteratorMetaInfo.getSize(); ++index) {
                newRow[index] = row.get(this._iteratorMetaInfo.getFieldName(index));
            }
            this._dataSourceWriter.writeData(newRow);
        }
        catch (AbstractDataSourceException e) {
            this._exception = e;
            throw e;
        }
        catch (InterruptedException e) {
            this._exception = e;
            throw e;
        }
        return row;
    }

    public void setAllFieldsNeeded(boolean isAllFieldsNeeded) {
    }

    public void close() {
        for (int index = 1; index < this.dataIterators.size(); ++index) {
            IDataIterator dataIterator = this.dataIterators.get(this.currentIetratorIndex);
            dataIterator.close();
        }
        if (this._dataSourceWriter != null) {
            try {
                this._dataSourceWriter.finishWriteData();
            }
            catch (DataSourcePersistenceException e) {
                if (this._exception == null) {
                    this._exception = e;
                }
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
            this._dataSourceWriter.close(this._exception);
            this._dataSourceWriter = null;
            if (this._exception != null) {
                this._dataSoruceCache.remove();
                this._dataSoruceCache = null;
            }
        }
    }
}

