/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.spec.csv;

import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.datasource.spec.csv.QingCsvWriterWraper;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class CsvDataSourceWriter
implements IDataSourceWriter {
    public static final String CHARSET = "utf-8";
    public static final String CSV = ".csv";
    public static final String META = ".meta";
    private static final ThreadLocal<DateFormat> dateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private QingCsvWriterWraper _metaWriter;
    private QingCsvWriterWraper _dataWriter;
    private MetaInfo _metaInfo;
    private Map<String, DataType> _dataTypeMap = new HashMap<String, DataType>();
    private boolean _isFirstPage = true;
    private List<String> _unmodifiableFieldNams;
    private List<DataType> _unmodifiableDataTypes;
    private List<String> _unmodifiableFieldDisplayNams;
    private boolean finishedWriteData;

    public CsvDataSourceWriter(IQingFile dataFile, IQingFile metaFile, boolean isAppend) {
        this._dataWriter = new QingCsvWriterWraper(dataFile.createWriter());
        if (!isAppend) {
            this._metaWriter = new QingCsvWriterWraper(metaFile.createWriter());
        }
    }

    @Override
    public void start(MetaInfo metaInfo) {
        this._metaInfo = metaInfo;
        this._unmodifiableFieldNams = metaInfo.getFieldNames();
        this._unmodifiableDataTypes = metaInfo.getFieldDataTypes();
        this._unmodifiableFieldDisplayNams = metaInfo.getFieldDisplayNames();
    }

    @Override
    public void writeData(Object[] row) throws DataSourcePersistenceException {
        if (this._dataWriter != null) {
            this._dataWriter.start();
            if (this._metaWriter != null) {
                this._metaWriter.start();
            }
        }
        if (this._metaInfo == null) {
            throw new DataSourcePersistenceException("no metainfo");
        }
        if (row == null) {
            return;
        }
        int index = 0;
        if (this._isFirstPage) {
            this._isFirstPage = false;
            for (index = 0; index < this._unmodifiableFieldNams.size(); ++index) {
                String name = this._unmodifiableFieldNams.get(index);
                this._dataTypeMap.put(name, this._unmodifiableDataTypes.get(index));
            }
            String[] array = new String[this._unmodifiableFieldNams.size()];
            this._unmodifiableFieldNams.toArray(array);
            this._dataWriter.writeRecord(array);
        }
        ArrayList<String> values = new ArrayList<String>(this._unmodifiableFieldNams.size());
        int c = this._unmodifiableFieldNams.size();
        for (int i = 0; i < c; ++i) {
            String value;
            String key = this._unmodifiableFieldNams.get(i);
            DataType type = this._dataTypeMap.get(key);
            Object oValue = row[i];
            String string = value = oValue == null ? null : oValue.toString();
            if (oValue == null) {
                value = null;
            } else if (oValue instanceof Date) {
                value = dateFormat.get().format((Date)oValue);
                if (type == null) {
                    this._dataTypeMap.put(key, DataType.DATE);
                }
            } else if (oValue instanceof Calendar) {
                value = dateFormat.get().format(((Calendar)oValue).getTime());
                if (type == null) {
                    this._dataTypeMap.put(key, DataType.DATE);
                }
            } else if (oValue instanceof Number) {
                value = oValue.toString();
                if (type != DataType.STRING) {
                    this._dataTypeMap.put(key, DataType.NUMBER);
                }
            } else {
                value = oValue.toString();
                if (type != DataType.STRING) {
                    if (Pattern.matches("^\\d{4}(/|-)\\d{1,2}(/|-)\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}", value) || Pattern.matches("^\\d{4}(/|-)\\d{1,2}(/|-)\\d{1,2}", value)) {
                        if (type == null || type == DataType.NUMBER) {
                            this._dataTypeMap.put(key, DataType.DATE);
                        }
                    } else if (Pattern.matches("^-?\\d+(\\.\\d+)?$", value)) {
                        if (type == null) {
                            this._dataTypeMap.put(key, DataType.NUMBER);
                        }
                    } else if (type == null || type != DataType.STRING) {
                        this._dataTypeMap.put(key, DataType.STRING);
                    }
                }
            }
            if (value == null) {
                value = "";
            }
            values.add(value);
        }
        String[] array = new String[values.size()];
        values.toArray(array);
        this._dataWriter.writeRecord(array);
        this._dataWriter.flush();
    }

    @Override
    public void finishWriteData() throws DataSourcePersistenceException {
        if (this.finishedWriteData) {
            return;
        }
        this.finishedWriteData = true;
        if (this._metaWriter != null) {
            ArrayList<String> dataTypeList = new ArrayList<String>(this._unmodifiableFieldNams.size());
            for (String name : this._unmodifiableFieldNams) {
                DataType type = this._dataTypeMap.get(name);
                if (type == null) {
                    type = DataType.STRING;
                }
                dataTypeList.add(type.toString());
            }
            String[] array = new String[this._unmodifiableFieldNams.size()];
            this._unmodifiableFieldNams.toArray(array);
            this._metaWriter.writeRecord(array);
            array = new String[this._unmodifiableFieldDisplayNams.size()];
            this._unmodifiableFieldDisplayNams.toArray(array);
            this._metaWriter.writeRecord(array);
            array = new String[dataTypeList.size()];
            dataTypeList.toArray(array);
            this._metaWriter.writeRecord(array);
            this._metaWriter.flush();
        }
    }

    @Override
    public void close(Exception exception) {
        if (this._dataWriter != null) {
            this._dataWriter.close(exception);
            this._dataWriter = null;
        }
        if (this._metaWriter != null) {
            this._metaWriter.close(exception);
            this._metaWriter = null;
        }
    }
}

